use bincode::{Decode, Encode};
use serde::Serialize;
use std::collections::BTreeMap;

#[derive(Encode, Decode, Serialize)]
pub struct Report {
    pub id: u8,
    pub ack: u8,
    pub syn: bool,
    pub peers: Vec<PeerQuality>,
}

#[derive(Encode, Decode, Copy, Clone, Serialize)]
pub struct PeerQuality {
    pub delay: i16,
    pub reliability: u8,
    pub jitter: u8,
}

#[derive(Encode, Decode, Default, Serialize)]
pub struct Change {
    pub seq: u8,
    pub rst: bool,
    pub via: BTreeMap<u8, u8>,
    pub plan: BTreeMap<u8, BTreeMap<u8, u8>>,
}
