use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Clone)]
pub struct RouterData {
    pub id: u8,
    pub name: String,
    pub location: String,
    // pub host: String,
    // #[serde(default)]
    // pub ssh_port: u16,
    // pub user: String,
}

#[derive(Serialize, Deserialize, Clone)]
pub struct ConnectionData {
    pub protocol: Schema,
    pub metric: u32,
}

#[derive(Serialize, Deserialize, Default, PartialEq, Clone, Copy)]
pub enum Schema {
    #[default]
    IP,
    UDP,
    TCP,
}
