use axum::{Json, routing::get};
use serde::Serialize;
use std::collections::BTreeMap;
use std::sync::Arc;
use tokio::sync::RwLock;

use crate::data::{ConnectionData, RouterData};
use crate::router::Router;
use tower_http::cors::CorsLayer;

#[derive(Serialize, Clone)]
pub struct Info {
    pub routers: Arc<Vec<RouterData>>,
    pub connections: Arc<BTreeMap<u8, BTreeMap<u8, ConnectionData>>>,
}

pub fn create_app(routers: Arc<Vec<RouterData>>, connections: Arc<BTreeMap<u8, BTreeMap<u8, ConnectionData>>>, routers2: Arc<RwLock<BTreeMap<u8, Router>>>) -> axum::Router {
    axum::Router::new()
        .route("/info", get(|| async move { Json(Info { routers, connections }) }))
        .route("/metrics", get(|| async move { Json(routers2.read().await.clone()) }))
        .layer(CorsLayer::permissive())
}
