import { GatewayGroup as GatewayGroupData } from '../import/scripts/GatewayGroup';
import _ from 'lodash';
import routers from '../import/data/Router.json';
import gatewayGroups from '../import/data/GatewayGroup.json';

export interface GatewayGroup extends GatewayGroupData {}

export class GatewayGroup {
  static all: Record<number, GatewayGroup> = _.keyBy(
    gatewayGroups.map((g) => new this(g)),
    'id'
  );
  public routers: number[];

  constructor(public data: GatewayGroupData) {
    Object.assign(this, data);
    this.routers = GatewayGroup.groupRouters(data);
  }

  static groupRouters(g: GatewayGroupData): number[] {
    return _.uniq(
      g.locationPrefix
        .flatMap((p) => routers.filter((r) => r.location.startsWith(p)))
        .concat(routers.filter((r) => g.includeRouters.includes(r.name)))
        .filter((r) => !g.excludeRouters.includes(r.name))
        .map((r) => r.id)
        .concat(gatewayGroups.filter((g1) => g.children.includes(g1.name)).flatMap((c) => this.groupRouters(c)))
    );
  }
}
