import {PeerQuality} from "./api.service";

export class Quality {
  static unreachable = new Quality(0, 0, 0, 0);

  constructor(public delay = 0, public jitter = 0, public reliability = 1, public cost = 0, public hop = 0) {
  }

  concat(delay: number, jitter: number, reliability: number, cost: number, hop: number): Quality {
    this.delay += delay;
    this.jitter += jitter;
    this.reliability *= reliability;
    this.cost += cost;
    this.hop += hop;
    return this;
  }

  concatPeer(quality?: PeerQuality): Quality {
    if (!quality) return Quality.unreachable
    return this.concat(quality.delay, quality.jitter, quality.reliability, 0, 1);
  }

  concatQuality(quality: Quality): Quality {
    return this.concat(quality.delay, quality.jitter, quality.reliability, quality.cost, quality.hop);
  }

  // 若 reliability = 0，metric 应为 +∞
  // 对于两条路线，同时连接任何一个相同的(reliability > 0的)线路，大小关系不变
  metric() {
    // assert(this.jitter >= 0);
    // assert(0 <= this.reliability && this.reliability <= 1);
    // assert(this.cost >= 0);
    if (this.reliability === 0) {
      return Infinity;
    } else {
      // 公式
      return this.delay + (1 - this.reliability) * 1000 + this.cost * 0.1;
    }
  }
}
