import dgram from 'dgram';
import { UploadMessage } from '../protocol';
import assert from 'assert';
import { Router } from './Router';
import config from '../config/config.json';
import { api } from './Api';
import express from 'express';
import path from 'path';

// http
const app = express();
app.use(express.static(path.join(__dirname, '..', 'public')));
app.use('/api', api);
app.listen(config.port);

// udp routing protocol
const socket = dgram
  .createSocket('udp4')
  .on('listening', () => {
    const address = socket.address();
    console.log(`listening ${address.address}:${address.port}`);
  })
  .on('message', function (message, rinfo) {
    try {
      const hello: UploadMessage = JSON.parse(message.toString());

      assert(hello.id);
      const router: Router = Router.all.find((r) => r.id === hello.id)!;
      assert(router);

      router.rinfo = rinfo;
      router.onMessage(hello);
    } catch (e) {
      console.warn(e);
    }
  });
socket.bind(config.port);

setInterval(() => {
  for (const from of Router.all) {
    if (Router.updating) return;
    from.update(socket);
  }
}, config.interval);
