# Railgun Routing Protocol

Fast & Simple routing protocol, for overlay network.

- 通过中心化部署，简单的正面算出数学最优解
- 环路避免
- 支持三角路由

## 客户端的行为:

### 每秒

向直接相连的邻居发送 Hello 报文，报内容为:

```typescript
interface Hello {
  id: number // 自己的id
  seq: number // 这个报文的顺序号，每次发送自增
  time: number // 自己的系统时间，EPOCH 以来的毫秒数
}
```

### 收到邻居信息时

若顺序号跟上次收到的差距较大，重置状态  
若顺序号比上次收到的略小，忽略  
根据 seq 计算可靠性，根据 time 计算单向延迟  
单向延迟为：自己的系统时间 - hello报文写的对方的系统时间  
双方时钟**不**需要同步

### 每秒

检查邻居是否超时，超时标记为下线  
向服务器发送 Report 报文汇报邻居到自己的质量，报文内容为

```typescript
interface Report {
  id: number // 自己的 id
  seq: number // 顺序号，每次收到 Change 后自增
  peers?: { id: number, reliability: number, delay: number }[]
}
```

### 收到服务器 Change 报文时

```typescript
interface Change {
  seq: number // 顺序号，每次下发新的 Change 指令时自增
  via: Record<number, number> // 有变更的下一跳路由
}
```
如果报文的 seq 为 0，重置状态和路由表  
如果报文的 seq 跟自己的 report seq 不同，忽略。  
seq自增，按照要求修改路由表，改完之后立即额外发送一次 Report 报文 (可以不带 peers)  

## 服务器行为

每秒：

检查客户端是否超时，若超时标记为下线

- 非 正在变更 状态：   
  为每个路由器检查，目标到每个路由器，下一跳哪个路由器最优。  
  只假设这台路由器的下一跳会变化，其他路由表用旧的不考虑改变。  
  如果发现有比现在更优的，就为这个路由器 下发 Change 报文。之后进入正在变更状态，跳过其他路由器的检查

- 正在变更 状态：  
  向路由器发送 Change 报文  
  若正在变更的客户端被标记为下线，退出正在变更状态

### 收到客户端 Report 报文时
如果报文顺序号为 0，重置状态并立即发送 Change(seq=0)  
如果报文顺序号不为0而服务器顺序号为0，立即发送 Change  
如果报文顺序号不为 change seq +1，忽略。   
如果携带了 peers 信息，存下来。  
- 如果这个路由器正在变更  
  seq 自增  
  退出正在变更状态

## 关于顺序号，断线、重启的一些解释：
### 客户端跟客户端之间
- 重启  
客户端收到跟之前差距较大的顺序号时，意味着客户端可能发生了重启或者断网一段时间，应当视为新上线的节点。  
客户端跟客户端之间的通讯不需要可靠，即使对方启动后不久又立刻重启，这会导致顺序号略微减少不触发重置，并且忽略掉报文视为丢包。但是这没关系，过几秒钟他就又跟上来了。  
- 断网  
超时收不到信息就标记为下线 (可靠性=0)

### 客户端跟服务器之间

服务器跟客户端之间的通讯比较需要可靠，因此客户端的seq=0服务器必须要回应，服务器的seq=0客户端也必须要回应，如果发生程序异常seq错乱的事情，会忽略掉所有不正确报文让他超时下限重置，然后从seq=0开始。
任何一个顺序号一定要确认过才会自增，不然会反复发送这一个：

- 客户端重启  
  客户端seq=0那个包服务器会立即回复一个change，如果丢包就会下个包再来
- 服务端重启  
  客户端seq!=0，服务器seq=0，服务器会回复一个seq=0的change，丢包一样
- 服务端断网  
  客户端没有收到任何新指令，继续维持现有路由表跑
- 客户端断网  
  服务器超时后把客户端标记为下线，其他人因为unreachable会进行路由表更新

