import {Component} from '@angular/core';
import {map, switchMap} from 'rxjs/operators';
import {ApiService, PeerQuality} from "../api.service";
import {ActivatedRoute} from "@angular/router";

@Component({
  selector: 'app-dashboard',
  templateUrl: './router.component.html',
  styleUrls: ['./router.component.scss']
})
export class RouterComponent {
  id = this.route.params.pipe(map(params => <number>params['id']));

  displayedColumns: string[] = ['id', 'delay', 'loss', 'loss2', 'jitter'];
  dataSource = this.id.pipe(
    switchMap(id => this.api.state().pipe(
      map(routers =>
        Object.entries(routers.find(r => r.id == id)!.peers).map(([id1, peer]) => {
          const peerId = parseInt(id1);
          const reverse = routers.find(r => r.id === peerId)?.peers?.[id];
          if (!reverse) return undefined;
          return this.displayQuality(peerId, peer, reverse)
        })
      ))));

  /** Based on the screen size, switch from standard to one column per row */


  constructor(private api: ApiService, private route: ActivatedRoute) {
  }

  displayQuality(id: number, inbound: PeerQuality, outbound: PeerQuality) {
    return {
      id,
      delay: inbound.delay + outbound.delay,
      loss: 1 - inbound.reliability,
      loss2: 1 - outbound.reliability,
      jitter: inbound.jitter + outbound.jitter
    };
  }

}
