import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { firstValueFrom, mergeMap, timer } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class ApiService {
  routers!: any[];
  connections!: Record<number, Record<number, Connection>>;

  constructor(private http: HttpClient) {
  }

  async init() {
    this.connections = await firstValueFrom(this.http.get<Record<number, Record<number, Connection>>>('http://10.198.0.7:500/api/connections'));
    this.routers = await firstValueFrom(this.http.get<RouterStatus[]>('http://10.198.0.7:500/api/routers'));


    console.log(
      this.routers
        .map((item) =>
          Object.entries({
            Host: item.name,
            HostName: item.host,
            User: item.user,
            Port: item.sshPort === 22 ? undefined : item.sshPort
          })
            .filter(([key, value]) => value)
            .map((line) => line.join(' '))
            .join('\n')
        )
        .join('\n\n')
    );
  }

  state() {
    return timer(0, 1000).pipe(
      mergeMap(() => this.http.get<RouterStatus[]>('http://10.198.0.7:500/api/state'))
      // map((routers) => routers.map(r => ));
    );
  }
}

export interface RouterStatus {
  id: number,
  peers: Record<number, PeerQuality>,
  via: Record<number, number>
}

export interface PeerQuality {
  delay: number;
  jitter: number;
  reliability: number;
}

export interface Router {
  id: number;
  name: string;
  location: string;
  host: string;
  port: number;
  user: string;
}

export interface Connection {
  metric: number;
  protocol: string;
}

// const connected: Record<number, Record<number, string>> = {};
// for (const from of data) {
//   if (!connected[from.id]) connected[from.id] = {}
//   for (const to of data) {
//     // @ts-ignore
//     if (from[to.name] !== "") {
//       const [min, max] = [from.id, to.id].sort();
//       // @ts-ignore
//       connected[min][max] = from[to.name];
//     }
//   }
// }

