import assert from 'assert';

export class Quality {
  static unreachable = new Quality(0, 0, 0, 0);

  constructor(public delay = 0, public jitter = 0, public reliability = 1, public cost = 0) {}

  concat(delay: number, jitter: number, reliability: number, cost: number) {
    this.delay += delay;
    this.jitter += jitter;
    this.reliability *= reliability;
    this.cost += cost;
    return this;
  }

  // 若 reliability = 0，metric 应为 +∞
  // 对于两条路线，同时连接任何一个相同的(reliability > 0的)线路，大小关系不变
  metric() {
    assert(this.jitter >= 0);
    assert(0 <= this.reliability && this.reliability <= 1);
    assert(this.cost >= 0);
    if (this.reliability === 0) {
      return Infinity;
    } else {
      // 公式
      return this.delay + (1 - this.reliability) * 1000 + this.cost * 0.1;
    }
  }
}
