import express from 'express';
import { Router } from './Router';
import routers from '../import/data/Router.json';
import _ from 'lodash';
import connections from '../import/connections.json';

export const api = express.Router();

api.get('/state', function (req, res, next) {
  const result = Router.all.map((from) => ({
    id: from.id,
    peers: from.peers,
    via: Object.fromEntries([...from.via.entries()].map(([to, via]) => [to.id, via.id])),
  }));

  res.json(result);
});

api.get('/routers', function (req, res, next) {
  res.json(routers.map((r) => _.pick(r, ['id', 'name', 'location', 'host', 'sshPort', 'user'])));
});
api.get('/connections', function (req, res, next) {
  res.json(connections);
});
