// Generated by CoffeeScript 1.9.3
(function() {
  var Quality, assert, dgram, gateway_metric, gateways, http, regions, reset_route, route_metric, route_quality, send_route, sequence, server, server_id, server_port, servers, socket, timeout, timeout_timer, update_route, updating,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  dgram = require('dgram');

  assert = require('assert');

  http = require('http');

  Quality = require('./quality');

  server_port = 495;

  timeout = 10;

  regions = [
    {
      id: 0,
      name: "default"
    }, {
      id: 1,
      name: "ap"
    }, {
      id: 2,
      name: "cn"
    }
  ];

  gateways = {
    2: {
      2: {
        server_id: 2,
        region_id: 2,
        delay: 0,
        jitter: 0,
        reliability: 1
      }
    },
    3: {
      0: {
        server_id: 3,
        region_id: 0,
        delay: 0.1,
        jitter: 0,
        reliability: 1
      },
      1: {
        server_id: 3,
        region_id: 1,
        delay: 0,
        jitter: 0,
        reliability: 1
      }
    },
    4: {
      0: {
        server_id: 4,
        region_id: 0,
        delay: 0,
        jitter: 0,
        reliability: 1
      }
    },
    6: {
      2: {
        server_id: 6,
        region_id: 2,
        delay: 0,
        jitter: 0,
        reliability: 1
      }
    },
    7: {
      0: {
        server_id: 7,
        region_id: 0,
        delay: 0.1,
        jitter: 0,
        reliability: 1
      },
      1: {
        server_id: 7,
        region_id: 1,
        delay: 0,
        jitter: 0,
        reliability: 1
      }
    }
  };

  servers = {
    2: {
      id: 2,
      inbound_cost: 0,
      outbound_cost: 0.8
    },
    3: {
      id: 3,
      inbound_cost: 0,
      outbound_cost: 0.05
    },
    4: {
      id: 4,
      inbound_cost: 0,
      outbound_cost: 0.03
    },
    6: {
      id: 6,
      inbound_cost: 0,
      outbound_cost: 0.8
    },
    7: {
      id: 7,
      inbound_cost: 0,
      outbound_cost: 1
    }
  };

  sequence = 0;

  updating = null;

  timeout_timer = null;

  socket = dgram.createSocket('udp4');

  route_quality = function(from, to, next_hop) {
    var current, next, quality, result, route;
    if (next_hop == null) {
      next_hop = servers[from].next_hop[to];
    }
    assert(next_hop != null);
    assert(from !== next_hop);
    assert(from !== to);
    result = new Quality();
    current = from;
    next = next_hop;
    route = [current, next];
    while (true) {
      quality = servers[next].quality[current];
      if (!quality || quality.reliability <= 0) {
        return Quality.unreachable;
      }
      result.concat(quality.delay, quality.jitter, quality.reliability, servers[current].outbound_cost + servers[next].inbound_cost);
      if (next === to) {
        return result;
      }
      current = next;
      next = servers[current].next_hop[to];
      assert(next);
      if (indexOf.call(route, next) >= 0) {
        return Quality.unreachable;
      } else {
        route.push(next);
      }
    }
  };

  route_metric = function(from, to, next_hop) {
    return route_quality(from, to, next_hop).metric();
  };

  gateway_metric = function(from, to, gateway) {
    var quality, result;
    quality = gateways[gateway][to];
    assert(quality);
    result = new Quality(quality.delay, quality.jitter, quality.reliability, servers[gateway].outbound_cost + servers[gateway].inbound_cost);
    if (from !== gateway) {
      result.concat(route_quality(from, gateway));
      result.concat(route_quality(gateway, from));
    }
    return result.metric();
  };

  update_route = function(server, to) {
    var best_metric, best_route, current_metric, current_route, index, metric, now, route_server, type;
    if (to.name != null) {
      type = 'gateway';
      current_route = server[type][to.id];
      if (current_route) {
        current_metric = gateway_metric(server.id, to.id, current_route);
      } else {
        current_metric = Number.POSITIVE_INFINITY;
      }
      best_route = current_route;
      best_metric = current_metric;
      for (index in servers) {
        route_server = servers[index];
        if (!(route_server.id !== current_route && (gateways[route_server.id] != null) && gateways[route_server.id][to.id])) {
          continue;
        }
        metric = gateway_metric(server.id, to.id, route_server.id);
        if (metric < best_metric) {
          best_route = route_server.id;
          best_metric = metric;
        }
      }
    } else {
      assert(to.inbound_cost != null);
      type = 'next_hop';
      current_route = server[type][to.id];
      assert(current_route);
      current_metric = route_metric(server.id, to.id, current_route);
      best_route = current_route;
      best_metric = current_metric;
      for (index in servers) {
        route_server = servers[index];
        if (!(route_server.id !== current_route && route_server.id !== server.id)) {
          continue;
        }
        metric = route_metric(server.id, to.id, route_server.id);
        if (metric < best_metric) {
          best_route = route_server.id;
          best_metric = metric;
        }
      }
    }
    now = new Date().getTime() / 1000;
    if (current_route !== best_route && (current_metric === Number.POSITIVE_INFINITY || (current_metric - best_metric - 0.01) * (now - server[type + '_updated_at'][to.id]) > 10)) {
      console.log(server[type + '_updated_at'][to.id], server[type + '_updated_at'], to.id);
      console.log("update #" + sequence + ": " + type + " server " + server.id + " to " + to.id + ": " + current_route + "(" + current_metric + ") -> " + best_route + "(" + best_metric + ") age " + (now - server[type + '_updated_at'][to.id]));
      server[type][to.id] = best_route;
      server[type + '_updated_at'][to.id] = now;
      updating = setInterval(function() {
        return send_route(server, to.id, best_route, type);
      }, 1000);
      send_route(server, to.id, best_route, type);
      timeout_timer = setTimeout(function() {
        delete server.address;
        delete server.port;
        clearInterval(updating);
        updating = null;
        return console.log("server" + server.id + " lost connection.");
      }, timeout * 1000);
      return true;
    }
    return false;
  };

  send_route = function(server, to, route, type) {
    var message;
    message = {
      sequence: sequence,
      to: to
    };
    message[type] = route;
    message = JSON.stringify(message);
    return socket.send(message, 0, message.length, server.port, server.address);
  };

  reset_route = function(server) {
    var i, now, region, region_id, results, s;
    now = new Date().getTime() / 1000;
    server.quality = {};
    server.next_hop = {};
    server.next_hop_updated_at = {};
    server.gateway = {};
    server.gateway_updated_at = {};
    for (i in servers) {
      s = servers[i];
      server.next_hop[s.id] = s.id;
      server.next_hop_updated_at[s.id] = now;
    }
    results = [];
    for (region_id in regions) {
      region = regions[region_id];
      if (!((gateways[server.id] != null) && (gateways[server.id][region_id] != null))) {
        continue;
      }
      server.gateway[region_id] = server.id;
      results.push(server.gateway_updated_at[region_id] = now);
    }
    return results;
  };

  socket.on('message', function(message, rinfo) {
    var i, j, server, to_region, to_server;
    message = JSON.parse(message);
    server = servers[message.server_id];
    if (server == null) {
      return;
    }
    if (server.address !== rinfo.address || server.port !== rinfo.port) {
      server.address = rinfo.address;
      server.port = rinfo.port;
      console.log("server " + server.id + " connected from " + server.address + ":" + server.port);
      reset_route(server);
    }
    server.quality = message.quality;
    if ((updating != null) && message.acknowledgement === sequence) {
      clearInterval(updating);
      clearTimeout(timeout_timer);
      updating = null;
      sequence += 1;
    }
    if (updating == null) {
      for (i in servers) {
        server = servers[i];
        if (!(server.address != null)) {
          continue;
        }
        for (j in servers) {
          to_server = servers[j];
          if (server.id !== to_server.id) {
            if (update_route(server, to_server)) {
              return;
            }
          }
        }
        for (j in regions) {
          to_region = regions[j];
          if (update_route(server, to_region)) {
            return;
          }
        }
      }
    }
  });

  for (server_id in servers) {
    server = servers[server_id];
    reset_route(server);
  }

  socket.bind(server_port);

  http.createServer(function(req, res) {
    res.writeHead(200, {
      'Content-Type': 'application/json'
    });
    return res.end(JSON.stringify(servers));
  }).listen(server_port);

}).call(this);

//# sourceMappingURL=main.js.map
