use crate::settings::ROUTE_PROTOCOL;
use crate::{connection::Connection, data, protocol::Change};
use futures::TryStreamExt;
use rtnetlink::RouteMessageBuilder;
use std::collections::BTreeMap;
use std::net::Ipv4Addr;

pub struct Server {
    pub(crate) ack: u8,
    pub(crate) handle: rtnetlink::Handle,
}

impl Server {
    pub fn new() -> Self {
        let (connection, handle, _) = rtnetlink::new_connection().unwrap();
        tokio::spawn(connection);
        Server { ack: 0, handle }
    }

    pub async fn on_message(
        &mut self,
        message: &Change,
        routers: &Vec<data::Router>,
        connections: &BTreeMap<u8, Connection>,
        // routers: &mut HashMap<u8, Router>,
        // self_peer: &Hello,
    ) {
        if message.rst {
            self.ack = message.seq;
            self.reset(routers, connections).await;
        }

        if self.ack != message.seq {
            println!("server seq={}, local ack={}", message.seq, self.ack);
            return;
        }

        // for (to, via) in message.via.iter() {
        // RouteWriter::set_via(*to, *via);
        // }

        // if let Some(plan) = message.plan.as_ref() {
        // for (group_id, to) in message.plan.iter() {
        // RouteWriter::set_plan(&GatewayGroup::all()[*group_id], *to);
        // }
        // }

        // RouteWriter::commit();
        self.ack += 1;
        // self.update(socket, routers, self_peer);
    }

    // pub fn update(&mut self, socket: &UdpSocket, routers: &mut HashMap<u8, Router>, hello: &Hello) {
    // }
    pub async fn reset(&self, routers: &Vec<data::Router>, connections: &BTreeMap<u8, Connection>) {
        let mut routes = self.handle.route().get(RouteMessageBuilder::<Ipv4Addr>::new().protocol(ROUTE_PROTOCOL).build()).execute();
        while let Some(route) = routes.try_next().await.unwrap() {
            self.handle.route().del(route).execute().await.unwrap();
        }
        // for router in routers.iter() {
        //     if()
        // }
    }
}
