import dgram from 'dgram';
import assert from 'assert';
import config from '../config/config.json';
import { Server } from './Server';
import { Router } from './Router';
import { Change, Hello } from '../protocol';

const self: Hello = { id: parseInt(process.env.RAILGUN_ID), seq: 0, time: 0 };
const server = new Server();

const socket = dgram
  .createSocket('udp4')
  .on('listening', () => {
    const address = socket.address();
    console.log(`listening ${address.address}:${address.port}`);
  })
  .on('message', (msg, rinfo) => {
    try {
      if (rinfo.address === config.server_address && rinfo.port === config.server_port) {
        // from server
        const message: Change = JSON.parse(msg.toString());
        server.onMessage(socket, message, self);
      } else {
        // from client
        const message: Hello = JSON.parse(msg.toString());
        assert(message.id);
        const peer = Router.all[message.id];
        assert(peer && rinfo.address === peer.linkAddress && rinfo.port === config.port);
        peer.onMessage(message);
      }
    } catch (e) {
      console.warn(e);
    }
  });

socket.bind(config.port);

setInterval(() => {
  self.time = Date.now();
  const message = JSON.stringify(self);
  for (const peer of Object.values(Router.all)) {
    socket.send(message, config.port, peer.linkAddress);
  }
  server.update(socket, self);
  self.seq++;
}, config.interval);
