import { Socket } from 'dgram';

import config from '../config/config.json';

import { RouteWriter } from './RouteWriter';
import { Router } from './Router';
import { Change, Hello, Report } from '../protocol';
import _ from 'lodash';
import { GatewayGroup } from './GatewayGroup';

export class Server {
  ack = 0;

  onMessage(socket: Socket, message: Change, self: Hello) {
    if (message.seq === 0) {
      this.ack = 0;
      RouteWriter.reset();
    }

    if (this.ack !== message.seq) {
      console.log(`seq mismatch rejected, server seq=${message.seq} local ack=${this.ack}`);
      return;
    }

    for (const [to, via] of Object.entries(message.via)) {
      RouteWriter.setVia(parseInt(to), via);
    }
    if (message.plan) {
      for (const [groupId, to] of Object.entries(message.plan)) {
        RouteWriter.setPlan(GatewayGroup.all[groupId], to);
      }
    }
    RouteWriter.commit();
    this.ack++;

    const response: Report = {
      id: self.id,
      ack: this.ack,
    };

    socket.send(JSON.stringify(response), config.server_port, config.server_address);
  }

  update(socket: Socket, self: Hello) {
    const message: Report = {
      id: self.id,
      ack: this.ack,
      peers: _.mapValues(Router.all, (peer) => peer.update(self.time)),
    };
    socket.send(JSON.stringify(message), config.server_port, config.server_address);
  }
}
