// 这个文件两端共用

export interface PeerQuality {
  delay: number;
  jitter: number;
  reliability: number;
}

// 路由器向中心服务器发送的消息
export interface Report {
  id: number;
  ack: number;
  peers?: Record<number, PeerQuality>;
}

// 中心服务器向路由器发送的消息
export interface Change {
  seq: number,
  via: Record<number, number>,
  plan: Record<number, number>
}

// 路由器向路由器发送的消息
export interface Hello {
  id: number; // 自己的id
  seq: number; // 这个报文的顺序号，每次发送自增
  time: number; // 自己的系统时间，EPOCH 以来的毫秒数
}
