use std::collections::{HashMap, HashSet};

use tokio::net::UdpSocket;

use crate::protocol::{Change, Hello, Report};
use crate::router::Router;

pub struct Server {
    pub(crate) ack: u8,
}

impl Server {
    pub fn new() -> Self {
        Server { ack: 0 }
    }

    pub fn on_message(
        &mut self,
        socket: &UdpSocket,
        message: &Change,
        routers: &mut HashMap<u8, Router>,
        self_peer: &Hello,
    ) {
        if message.seq == 0 {
            self.ack = 0;
            // RouteWriter::reset();
        }

        if self.ack != message.seq {
            println!(
                "seq mismatch rejected, server seq={}, local ack={}",
                message.seq, self.ack
            );
            return;
        }

        for (to, via) in message.via.iter() {
            // RouteWriter::set_via(*to, *via);
        }

        // if let Some(plan) = message.plan.as_ref() {
        for (group_id, to) in message.plan.iter() {
            // RouteWriter::set_plan(&GatewayGroup::all()[*group_id], *to);
        }
        // }

        // RouteWriter::commit();
        self.ack += 1;
        self.update(socket, routers, self_peer);
    }

    pub fn update(
        &mut self,
        socket: &UdpSocket,
        routers: &mut HashMap<u8, Router>,
        hello: &Hello,
    ) {

    }
}
