use std::collections::{HashMap, HashSet};

use crate::data::{GatewayGroup, Router};

impl GatewayGroup {
    pub fn routers(&self, groups: &[GatewayGroup], routers: &[Router]) -> HashSet<u8> {
        routers
            .iter()
            .filter(|r| self.include_routers.contains(&r.name))
            .chain(
                self.location_prefix
                    .iter()
                    .flat_map(|p| routers.iter().filter(move |r| r.location.starts_with(p))),
            )
            .filter(|r| !self.exclude_routers.contains(&r.name))
            .map(|r| r.id)
            .chain(
                groups
                    .iter()
                    .filter(|g| self.children.contains(&g.name))
                    .flat_map(|g1| g1.routers(groups, routers)),
            )
            .collect()
    }
}
