use serde::Deserialize;
use std::collections::HashSet;

#[derive(Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Router {
    pub id: u8,
    pub name: String,
    pub address: String,
    pub location: String,
    pub user: String,
    pub host: String,
    pub ssh_port: u16,
    pub ssh_system: Option<u16>,
    pub next_mark: u16,
    pub dest_mark: u16,
    pub port: u16,
    pub port2: u16,
    pub wg_private_key: Option<String>,
    pub masq_interfaces: Vec<String>,
    pub os: String,
    pub arch: String,
    pub ocserv_port: u16,
    pub offset: u16,
    pub offset2: u16,
}

#[derive(Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct GatewayGroup {
    pub id: u16,
    pub name: String,
    pub description: String,
    pub children: HashSet<String>,
    pub dest_mark: u16,
    pub location_prefix: Vec<String>,
    pub include_routers: HashSet<String>,
    pub exclude_routers: HashSet<String>,
}
