use std::collections::BTreeMap;
use bincode::{Decode, Encode};

#[derive(Encode, Decode)]
pub struct Hello {
    pub time: u16,
}

#[derive(Encode, Decode)]
pub struct Report {
    pub id: u8,
    pub ack: u8,
    pub syn: bool,
    pub peers: Vec<PeerQuality>,
}

#[derive(Encode, Decode, Copy, Clone)]
pub struct PeerQuality {
    pub delay: i16,
    pub reliability: u8,
    pub jitter: u8,
}

#[derive(Encode, Decode)]
pub struct Change {
    pub seq: u8,
    pub rst: bool,
    pub via: BTreeMap<u8, u8>,
    pub plan: BTreeMap<u8, BTreeMap<u8, u8>>,
}
