import dgram from 'dgram';
import assert from 'assert';
import config from '../config/config.json';
import routers from '../config/routers.json';
import { Server } from './Server';
import { Peer } from './Peer';
import { DownloadMessage, PeerMessage } from '../protocol';

const self: PeerMessage = { id: parseInt(process.env.RAILGUN_ID), seq: 0, time: 0 };
const server = new Server();
const peers = routers.filter(r => r.id !== self.id && r.interface).map(r => new Peer(r));

const socket = dgram
  .createSocket('udp4')
  .on('listening', () => {
    const address = socket.address();
    console.log(`listening ${address.address}:${address.port}`);
  })
  .on('message', (msg, rinfo) => {
    try {
      if (rinfo.address === config.server_address && rinfo.port === config.server_port) {
        // from server
        const message: DownloadMessage = JSON.parse(msg.toString());
        server.onMessage(socket, message, self);
      } else {
        // from client
        const message: PeerMessage = JSON.parse(msg.toString());
        assert(message.id);
        const peer = peers.find(p => p.id === message.id);
        assert(peer && rinfo.address === peer.address && rinfo.port === config.port);
        peer.onMessage(message);
      }
    } catch (e) {
      console.warn(e);
    }
  });

socket.bind(config.port, routers.find(r => r.id === self.id).address);

setInterval(() => {
  self.time = Date.now();
  const message = JSON.stringify(self);
  for (const peer of peers) {
    peer.update(self.time);
    socket.send(message, config.port, `10.200.${peer.id}.${self.id}`);
  }
  server.update(socket, self, peers);
  self.seq++;
}, config.interval);
