import config from '../config/config.json';
import routers from '../config/routers.json';
import plans from '../config/plans.json';
import child_process from 'child_process';

export class RouteWriter {
  static id = parseInt(process.env.RAILGUN_ID);
  static input: string[] = [];
  static via = new Map<number, number>();
  static plan = new Map<number, number>();

  static reset() {
    console.log("reset");
    this.input.push(`route flush table ${config.table} proto ${config.proto}`);
    for (const peer of routers.filter((r) => r.id !== this.id && r.interface)) {
      this.setVia(peer.id, peer.id);
    }
    for (const plan of plans.filter(plan => !plan.routers.includes(this.id))) {
      this.setPlan(plan.id, this.id);
    }
  }

  static setVia(toId: number, viaId: number) {
    this.via.set(toId, viaId);
    const to = routers.find(r => r.id === toId);
    const via = routers.find(r => r.id === viaId);
    for (const address of [to.address, ...to.subnets]) {
      this.input.push(`route replace ${address} dev ${via.interface} table ${config.table} proto ${config.proto}`);
    }
    for (const [table, to] of this.plan.entries()) {
      if (to === toId) {
        this.input.push(`route replace default dev ${via.interface} table ${table} proto ${config.proto}`);
      }
    }
  }

  static setPlan(table: number, toId: number) {
    this.plan.set(table, toId);

    if (toId === this.id) {
      this.input.push(`route flush table ${table} proto ${config.proto}`);
    } else {
      const viaId = this.via.get(toId);
      const via = routers.find(r => r.id === viaId);
      this.input.push(`route replace default dev ${via.interface} table ${table} proto ${config.proto}`);
    }
  }

  static commit() {
    if (!this.input.length) return;
    // 可能改成异步的会更好点?
    const input = this.input.join('\n');
    console.log(input);
    // child_process.execFileSync('ip', ['-batch', '-'], { input });
    this.input = [];
  }
}
