// 这个文件两端共用

export interface PeerQuality {
  delay: number;
  jitter: number;
  reliability: number;
}

// 路由器向中心服务器发送的消息
export interface UploadMessage {
  id: number; // router id
  ack: number;
  peers?: Record<number, PeerQuality>;
}

// 中心服务器向路由器发送的消息
export interface DownloadMessage {
  seq: number,
  via: Record<number, number>,
  plan: Record<number, number>
}

// 路由器向路由器发送的消息
export interface PeerMessage {
  id: number;
  seq: number;
  time: number;
}
