#!/bin/bash

# https://stackoverflow.com/a/55817495
cp /etc/resolv.conf /etc/resolv.conf.bak
umount /etc/resolv.conf
cp /etc/resolv.conf.bak /etc/resolv.conf

# anyconnect, don't touch my iptables
mv `which iptables` /

./vpnagentd
echo -e "${username}\n${password}" | ./vpn -s connect ${host}

address=$(./vpn stats | grep "Client Address (IPv4)" | grep -Po '[0-9.]{7,15}')
interface=$(ip --brief address | grep ${address} | cut -d ' ' -f 1)
# 改名字再alias回去 ?
echo $interface up
PATH=$PATH:/ iptables -V
#trap 等信号来了down

pid=0

run_stop() {
  signalCode=$1
  if [ -n "$DOWN_SCRIPT" ]; then
    eval "$DOWN_SCRIPT"
  fi
  if [ $pid -ne 0 ]; then
    kill "-$signalCode" "$pid"
    wait "$pid"
  fi
  exit $((128 + signalCode));
}

trap 'kill ${!}; run_stop 2' SIGTERM
trap 'kill ${!}; run_stop 15' SIGINT

sleep infinity &
pid="$!"

# wait forever
wait "$pid"
pid=0
run_stop 1
