#!/bin/sh

# https://linuxgeeks.github.io/2015/09/20/114131-shell%E5%AE%9E%E7%8E%B0netmask%E6%8E%A9%E7%A0%81%E5%92%8Ccidr%E6%8E%A9%E7%A0%81%E4%BD%8D%E8%BD%AC%E6%8D%A2/
cdr2mask ()
{
   # Number of args to shift, 255..255, first non-255 byte, zeroes
   set -- $(( 5 - ($1 / 8) )) 255 255 255 255 $(( (255 << (8 - ($1 % 8))) & 255 )) 0 0 0
   [ $1 -gt 1 ] && shift $1 || shift
   echo ${1-0}.${2-0}.${3-0}.${4-0}
}

# set container address to openwrt config
cidr=$(ip -o -f inet addr show dev eth0 | awk '/scope global/ {print $4}')

# TODO: if 没有预先分配过地址，就跳过这一段
ipaddr=$(echo $cidr | cut -d/ -f1)
prefixlen=$(echo $cidr | cut -d/ -f2)
gateway=$(/sbin/ip route | awk '/default/ { print $3 }')
uci set network.wan.proto=static
uci set network.wan.ipaddr=$ipaddr
uci set network.wan.netmask=$(cdr2mask $prefixlen)
uci set network.wan.gateway=$gateway
# 跳过到这里

#TODO: if没有配置frp，就跳过这一段
uci set frpc.common.server_addr=$frp_server_addr
uci set frpc.common.server_port=$frp_server_port
uci set frpc.common.token=$frp_token
uci set frpc.ssh.remote_port=$frp_port
# 跳过到这里

uci commit

exec /sbin/init
