#!/bin/bash

# ROUTE_PLANS
source /usr/src/app/route-plans

while read dst others
do
    if [[ "$dst" == "10.198.0."* ]] && [[ "$others" == *"proto $TARGET_PROTOCOL"* ]]
    then
        # 读 babeld 路由
        declare -A routes
        while read -r dst others
        do
            routes["$dst"]="$others"
        done < <( ip route show proto $TARGET_PROTOCOL root 10.198.0.0/24 )

        # 取最优路由并写进系统路由表
        # 这个循环内所有 echo 的东西都会打给 iproute2。打调试信息要用 stderr
        for table in "${!ROUTE_PLANS[@]}"; do
            best_dev=
            best_metric=65535
            for dst in ${ROUTE_PLANS["$table"]}
            do
                if [[ -v "routes[$dst]" ]]
                then
                    # 只需要 dev 和 metric，其余的丢弃，目前的体系全都是 L3 口，仅用 dev 就可以路由
                    # 这里假设了 dev 和 metric 的位置。babeld 生成的路由表是符合这个规律的
                    read _ _ _ dev _ metric _ <<< ${routes[$dst]}
                    if (( metric < best_metric )); then
                        best_metric="$metric"
                        best_dev="$dev"
                    fi
                fi
            done
            if [ -z "$best_dev" ]
            then
                echo "route flush table $table"
            else
                echo "route replace default dev $best_dev table $table"
            fi
        done # | ip -batch -
    fi
done < <( ip monitor route )
