package cache

import (
	"github.com/coredns/coredns/plugin"

	"github.com/prometheus/client_golang/prometheus"
	"github.com/prometheus/client_golang/prometheus/promauto"
)

var (
	// cacheSize is total elements in the cache by cache type.
	cacheSize = promauto.NewGaugeVec(prometheus.GaugeOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "entries",
		Help:      "The number of elements in the cache.",
	}, []string{"server", "type"})
	// cacheHits is counter of cache hits by cache type.
	cacheHits = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "hits_total",
		Help:      "The count of cache hits.",
	}, []string{"server", "type"})
	// cacheMisses is the counter of cache misses.
	cacheMisses = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "misses_total",
		Help:      "The count of cache misses.",
	}, []string{"server"})
	// cachePrefetches is the number of time the cache has prefetched a cached item.
	cachePrefetches = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "prefetch_total",
		Help:      "The number of times the cache has prefetched a cached item.",
	}, []string{"server"})
	// cacheDrops is the number responses that are not cached, because the reply is malformed.
	cacheDrops = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "drops_total",
		Help:      "The number responses that are not cached, because the reply is malformed.",
	}, []string{"server"})
	// servedStale is the number of requests served from stale cache entries.
	servedStale = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "served_stale_total",
		Help:      "The number of requests served from stale cache entries.",
	}, []string{"server"})
	// evictions is the counter of cache evictions.
	evictions = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "cache",
		Name:      "evictions_total",
		Help:      "The count of cache evictions.",
	}, []string{"server", "type"})
)
