/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package certificates

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/client-go/1.5/pkg/api"
	pkg1_unversioned "k8s.io/client-go/1.5/pkg/api/unversioned"
	pkg3_types "k8s.io/client-go/1.5/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *CertificateSigningRequest) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.ObjectMeta
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.Spec
					yy13.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy14 := &x.Spec
					yy14.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.Status
					yy16.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CertificateSigningRequest) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym18 := z.DecBinary()
	_ = yym18
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct19 := r.ContainerType()
		if yyct19 == codecSelferValueTypeMap1234 {
			yyl19 := r.ReadMapStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl19, d)
			}
		} else if yyct19 == codecSelferValueTypeArray1234 {
			yyl19 := r.ReadArrayStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl19, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CertificateSigningRequest) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys20Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys20Slc
	var yyhl20 bool = l >= 0
	for yyj20 := 0; ; yyj20++ {
		if yyhl20 {
			if yyj20 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys20Slc = r.DecodeBytes(yys20Slc, true, true)
		yys20 := string(yys20Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys20 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv23 := &x.ObjectMeta
				yyv23.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = CertificateSigningRequestSpec{}
			} else {
				yyv24 := &x.Spec
				yyv24.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = CertificateSigningRequestStatus{}
			} else {
				yyv25 := &x.Status
				yyv25.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys20)
		} // end switch yys20
	} // end for yyj20
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CertificateSigningRequest) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv29 := &x.ObjectMeta
		yyv29.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = CertificateSigningRequestSpec{}
	} else {
		yyv30 := &x.Spec
		yyv30.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = CertificateSigningRequestStatus{}
	} else {
		yyv31 := &x.Status
		yyv31.CodecDecodeSelf(d)
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CertificateSigningRequestSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym32 := z.EncBinary()
		_ = yym32
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep33 := !z.EncBinary()
			yy2arr33 := z.EncBasicHandle().StructToArray
			var yyq33 [4]bool
			_, _, _ = yysep33, yyq33, yy2arr33
			const yyr33 bool = false
			yyq33[1] = x.Username != ""
			yyq33[2] = x.UID != ""
			yyq33[3] = len(x.Groups) != 0
			var yynn33 int
			if yyr33 || yy2arr33 {
				r.EncodeArrayStart(4)
			} else {
				yynn33 = 1
				for _, b := range yyq33 {
					if b {
						yynn33++
					}
				}
				r.EncodeMapStart(yynn33)
				yynn33 = 0
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Request == nil {
					r.EncodeNil()
				} else {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Request))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("request"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Request == nil {
					r.EncodeNil()
				} else {
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Request))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[1] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Username))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("username"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Username))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[2] {
					yym41 := z.EncBinary()
					_ = yym41
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym42 := z.EncBinary()
					_ = yym42
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[3] {
					if x.Groups == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							z.F.EncSliceStringV(x.Groups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq33[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("groups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Groups == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							z.F.EncSliceStringV(x.Groups, false, e)
						}
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CertificateSigningRequestSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym46 := z.DecBinary()
	_ = yym46
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct47 := r.ContainerType()
		if yyct47 == codecSelferValueTypeMap1234 {
			yyl47 := r.ReadMapStart()
			if yyl47 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl47, d)
			}
		} else if yyct47 == codecSelferValueTypeArray1234 {
			yyl47 := r.ReadArrayStart()
			if yyl47 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl47, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CertificateSigningRequestSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys48Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys48Slc
	var yyhl48 bool = l >= 0
	for yyj48 := 0; ; yyj48++ {
		if yyhl48 {
			if yyj48 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys48Slc = r.DecodeBytes(yys48Slc, true, true)
		yys48 := string(yys48Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys48 {
		case "request":
			if r.TryDecodeAsNil() {
				x.Request = nil
			} else {
				yyv49 := &x.Request
				yym50 := z.DecBinary()
				_ = yym50
				if false {
				} else {
					*yyv49 = r.DecodeBytes(*(*[]byte)(yyv49), false, false)
				}
			}
		case "username":
			if r.TryDecodeAsNil() {
				x.Username = ""
			} else {
				x.Username = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = string(r.DecodeString())
			}
		case "groups":
			if r.TryDecodeAsNil() {
				x.Groups = nil
			} else {
				yyv53 := &x.Groups
				yym54 := z.DecBinary()
				_ = yym54
				if false {
				} else {
					z.F.DecSliceStringX(yyv53, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys48)
		} // end switch yys48
	} // end for yyj48
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CertificateSigningRequestSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj55 int
	var yyb55 bool
	var yyhl55 bool = l >= 0
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Request = nil
	} else {
		yyv56 := &x.Request
		yym57 := z.DecBinary()
		_ = yym57
		if false {
		} else {
			*yyv56 = r.DecodeBytes(*(*[]byte)(yyv56), false, false)
		}
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Username = ""
	} else {
		x.Username = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Groups = nil
	} else {
		yyv60 := &x.Groups
		yym61 := z.DecBinary()
		_ = yym61
		if false {
		} else {
			z.F.DecSliceStringX(yyv60, false, d)
		}
	}
	for {
		yyj55++
		if yyhl55 {
			yyb55 = yyj55 > l
		} else {
			yyb55 = r.CheckBreak()
		}
		if yyb55 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj55-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CertificateSigningRequestStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym62 := z.EncBinary()
		_ = yym62
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep63 := !z.EncBinary()
			yy2arr63 := z.EncBasicHandle().StructToArray
			var yyq63 [2]bool
			_, _, _ = yysep63, yyq63, yy2arr63
			const yyr63 bool = false
			yyq63[0] = len(x.Conditions) != 0
			yyq63[1] = len(x.Certificate) != 0
			var yynn63 int
			if yyr63 || yy2arr63 {
				r.EncodeArrayStart(2)
			} else {
				yynn63 = 0
				for _, b := range yyq63 {
					if b {
						yynn63++
					}
				}
				r.EncodeMapStart(yynn63)
				yynn63 = 0
			}
			if yyr63 || yy2arr63 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq63[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym65 := z.EncBinary()
						_ = yym65
						if false {
						} else {
							h.encSliceCertificateSigningRequestCondition(([]CertificateSigningRequestCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq63[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym66 := z.EncBinary()
						_ = yym66
						if false {
						} else {
							h.encSliceCertificateSigningRequestCondition(([]CertificateSigningRequestCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr63 || yy2arr63 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq63[1] {
					if x.Certificate == nil {
						r.EncodeNil()
					} else {
						yym68 := z.EncBinary()
						_ = yym68
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Certificate))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq63[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("certificate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Certificate == nil {
						r.EncodeNil()
					} else {
						yym69 := z.EncBinary()
						_ = yym69
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Certificate))
						}
					}
				}
			}
			if yyr63 || yy2arr63 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CertificateSigningRequestStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym70 := z.DecBinary()
	_ = yym70
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct71 := r.ContainerType()
		if yyct71 == codecSelferValueTypeMap1234 {
			yyl71 := r.ReadMapStart()
			if yyl71 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl71, d)
			}
		} else if yyct71 == codecSelferValueTypeArray1234 {
			yyl71 := r.ReadArrayStart()
			if yyl71 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl71, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CertificateSigningRequestStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys72Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys72Slc
	var yyhl72 bool = l >= 0
	for yyj72 := 0; ; yyj72++ {
		if yyhl72 {
			if yyj72 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys72Slc = r.DecodeBytes(yys72Slc, true, true)
		yys72 := string(yys72Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys72 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv73 := &x.Conditions
				yym74 := z.DecBinary()
				_ = yym74
				if false {
				} else {
					h.decSliceCertificateSigningRequestCondition((*[]CertificateSigningRequestCondition)(yyv73), d)
				}
			}
		case "certificate":
			if r.TryDecodeAsNil() {
				x.Certificate = nil
			} else {
				yyv75 := &x.Certificate
				yym76 := z.DecBinary()
				_ = yym76
				if false {
				} else {
					*yyv75 = r.DecodeBytes(*(*[]byte)(yyv75), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys72)
		} // end switch yys72
	} // end for yyj72
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CertificateSigningRequestStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj77 int
	var yyb77 bool
	var yyhl77 bool = l >= 0
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv78 := &x.Conditions
		yym79 := z.DecBinary()
		_ = yym79
		if false {
		} else {
			h.decSliceCertificateSigningRequestCondition((*[]CertificateSigningRequestCondition)(yyv78), d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Certificate = nil
	} else {
		yyv80 := &x.Certificate
		yym81 := z.DecBinary()
		_ = yym81
		if false {
		} else {
			*yyv80 = r.DecodeBytes(*(*[]byte)(yyv80), false, false)
		}
	}
	for {
		yyj77++
		if yyhl77 {
			yyb77 = yyj77 > l
		} else {
			yyb77 = r.CheckBreak()
		}
		if yyb77 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj77-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RequestConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym82 := z.EncBinary()
	_ = yym82
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RequestConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym83 := z.DecBinary()
	_ = yym83
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *CertificateSigningRequestCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym84 := z.EncBinary()
		_ = yym84
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep85 := !z.EncBinary()
			yy2arr85 := z.EncBasicHandle().StructToArray
			var yyq85 [4]bool
			_, _, _ = yysep85, yyq85, yy2arr85
			const yyr85 bool = false
			yyq85[1] = x.Reason != ""
			yyq85[2] = x.Message != ""
			yyq85[3] = true
			var yynn85 int
			if yyr85 || yy2arr85 {
				r.EncodeArrayStart(4)
			} else {
				yynn85 = 1
				for _, b := range yyq85 {
					if b {
						yynn85++
					}
				}
				r.EncodeMapStart(yynn85)
				yynn85 = 0
			}
			if yyr85 || yy2arr85 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr85 || yy2arr85 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq85[1] {
					yym88 := z.EncBinary()
					_ = yym88
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq85[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym89 := z.EncBinary()
					_ = yym89
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr85 || yy2arr85 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq85[2] {
					yym91 := z.EncBinary()
					_ = yym91
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq85[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym92 := z.EncBinary()
					_ = yym92
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr85 || yy2arr85 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq85[3] {
					yy94 := &x.LastUpdateTime
					yym95 := z.EncBinary()
					_ = yym95
					if false {
					} else if z.HasExtensions() && z.EncExt(yy94) {
					} else if yym95 {
						z.EncBinaryMarshal(yy94)
					} else if !yym95 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy94)
					} else {
						z.EncFallback(yy94)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq85[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastUpdateTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy96 := &x.LastUpdateTime
					yym97 := z.EncBinary()
					_ = yym97
					if false {
					} else if z.HasExtensions() && z.EncExt(yy96) {
					} else if yym97 {
						z.EncBinaryMarshal(yy96)
					} else if !yym97 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy96)
					} else {
						z.EncFallback(yy96)
					}
				}
			}
			if yyr85 || yy2arr85 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CertificateSigningRequestCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym98 := z.DecBinary()
	_ = yym98
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct99 := r.ContainerType()
		if yyct99 == codecSelferValueTypeMap1234 {
			yyl99 := r.ReadMapStart()
			if yyl99 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl99, d)
			}
		} else if yyct99 == codecSelferValueTypeArray1234 {
			yyl99 := r.ReadArrayStart()
			if yyl99 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl99, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CertificateSigningRequestCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys100Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys100Slc
	var yyhl100 bool = l >= 0
	for yyj100 := 0; ; yyj100++ {
		if yyhl100 {
			if yyj100 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys100Slc = r.DecodeBytes(yys100Slc, true, true)
		yys100 := string(yys100Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys100 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = RequestConditionType(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "lastUpdateTime":
			if r.TryDecodeAsNil() {
				x.LastUpdateTime = pkg1_unversioned.Time{}
			} else {
				yyv104 := &x.LastUpdateTime
				yym105 := z.DecBinary()
				_ = yym105
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv104) {
				} else if yym105 {
					z.DecBinaryUnmarshal(yyv104)
				} else if !yym105 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv104)
				} else {
					z.DecFallback(yyv104, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys100)
		} // end switch yys100
	} // end for yyj100
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CertificateSigningRequestCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj106 int
	var yyb106 bool
	var yyhl106 bool = l >= 0
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = RequestConditionType(r.DecodeString())
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastUpdateTime = pkg1_unversioned.Time{}
	} else {
		yyv110 := &x.LastUpdateTime
		yym111 := z.DecBinary()
		_ = yym111
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv110) {
		} else if yym111 {
			z.DecBinaryUnmarshal(yyv110)
		} else if !yym111 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv110)
		} else {
			z.DecFallback(yyv110, false)
		}
	}
	for {
		yyj106++
		if yyhl106 {
			yyb106 = yyj106 > l
		} else {
			yyb106 = r.CheckBreak()
		}
		if yyb106 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj106-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CertificateSigningRequestList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym112 := z.EncBinary()
		_ = yym112
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep113 := !z.EncBinary()
			yy2arr113 := z.EncBasicHandle().StructToArray
			var yyq113 [4]bool
			_, _, _ = yysep113, yyq113, yy2arr113
			const yyr113 bool = false
			yyq113[0] = x.Kind != ""
			yyq113[1] = x.APIVersion != ""
			yyq113[2] = true
			yyq113[3] = len(x.Items) != 0
			var yynn113 int
			if yyr113 || yy2arr113 {
				r.EncodeArrayStart(4)
			} else {
				yynn113 = 0
				for _, b := range yyq113 {
					if b {
						yynn113++
					}
				}
				r.EncodeMapStart(yynn113)
				yynn113 = 0
			}
			if yyr113 || yy2arr113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq113[0] {
					yym115 := z.EncBinary()
					_ = yym115
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq113[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym116 := z.EncBinary()
					_ = yym116
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr113 || yy2arr113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq113[1] {
					yym118 := z.EncBinary()
					_ = yym118
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq113[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym119 := z.EncBinary()
					_ = yym119
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr113 || yy2arr113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq113[2] {
					yy121 := &x.ListMeta
					yym122 := z.EncBinary()
					_ = yym122
					if false {
					} else if z.HasExtensions() && z.EncExt(yy121) {
					} else {
						z.EncFallback(yy121)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq113[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy123 := &x.ListMeta
					yym124 := z.EncBinary()
					_ = yym124
					if false {
					} else if z.HasExtensions() && z.EncExt(yy123) {
					} else {
						z.EncFallback(yy123)
					}
				}
			}
			if yyr113 || yy2arr113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq113[3] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym126 := z.EncBinary()
						_ = yym126
						if false {
						} else {
							h.encSliceCertificateSigningRequest(([]CertificateSigningRequest)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq113[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym127 := z.EncBinary()
						_ = yym127
						if false {
						} else {
							h.encSliceCertificateSigningRequest(([]CertificateSigningRequest)(x.Items), e)
						}
					}
				}
			}
			if yyr113 || yy2arr113 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CertificateSigningRequestList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct129 := r.ContainerType()
		if yyct129 == codecSelferValueTypeMap1234 {
			yyl129 := r.ReadMapStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl129, d)
			}
		} else if yyct129 == codecSelferValueTypeArray1234 {
			yyl129 := r.ReadArrayStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl129, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CertificateSigningRequestList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys130Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys130Slc
	var yyhl130 bool = l >= 0
	for yyj130 := 0; ; yyj130++ {
		if yyhl130 {
			if yyj130 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys130Slc = r.DecodeBytes(yys130Slc, true, true)
		yys130 := string(yys130Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys130 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv133 := &x.ListMeta
				yym134 := z.DecBinary()
				_ = yym134
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv133) {
				} else {
					z.DecFallback(yyv133, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv135 := &x.Items
				yym136 := z.DecBinary()
				_ = yym136
				if false {
				} else {
					h.decSliceCertificateSigningRequest((*[]CertificateSigningRequest)(yyv135), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys130)
		} // end switch yys130
	} // end for yyj130
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CertificateSigningRequestList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj137 int
	var yyb137 bool
	var yyhl137 bool = l >= 0
	yyj137++
	if yyhl137 {
		yyb137 = yyj137 > l
	} else {
		yyb137 = r.CheckBreak()
	}
	if yyb137 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj137++
	if yyhl137 {
		yyb137 = yyj137 > l
	} else {
		yyb137 = r.CheckBreak()
	}
	if yyb137 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj137++
	if yyhl137 {
		yyb137 = yyj137 > l
	} else {
		yyb137 = r.CheckBreak()
	}
	if yyb137 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv140 := &x.ListMeta
		yym141 := z.DecBinary()
		_ = yym141
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv140) {
		} else {
			z.DecFallback(yyv140, false)
		}
	}
	yyj137++
	if yyhl137 {
		yyb137 = yyj137 > l
	} else {
		yyb137 = r.CheckBreak()
	}
	if yyb137 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv142 := &x.Items
		yym143 := z.DecBinary()
		_ = yym143
		if false {
		} else {
			h.decSliceCertificateSigningRequest((*[]CertificateSigningRequest)(yyv142), d)
		}
	}
	for {
		yyj137++
		if yyhl137 {
			yyb137 = yyj137 > l
		} else {
			yyb137 = r.CheckBreak()
		}
		if yyb137 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj137-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceCertificateSigningRequestCondition(v []CertificateSigningRequestCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv144 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy145 := &yyv144
		yy145.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCertificateSigningRequestCondition(v *[]CertificateSigningRequestCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv146 := *v
	yyh146, yyl146 := z.DecSliceHelperStart()
	var yyc146 bool
	if yyl146 == 0 {
		if yyv146 == nil {
			yyv146 = []CertificateSigningRequestCondition{}
			yyc146 = true
		} else if len(yyv146) != 0 {
			yyv146 = yyv146[:0]
			yyc146 = true
		}
	} else if yyl146 > 0 {
		var yyrr146, yyrl146 int
		var yyrt146 bool
		if yyl146 > cap(yyv146) {

			yyrg146 := len(yyv146) > 0
			yyv2146 := yyv146
			yyrl146, yyrt146 = z.DecInferLen(yyl146, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt146 {
				if yyrl146 <= cap(yyv146) {
					yyv146 = yyv146[:yyrl146]
				} else {
					yyv146 = make([]CertificateSigningRequestCondition, yyrl146)
				}
			} else {
				yyv146 = make([]CertificateSigningRequestCondition, yyrl146)
			}
			yyc146 = true
			yyrr146 = len(yyv146)
			if yyrg146 {
				copy(yyv146, yyv2146)
			}
		} else if yyl146 != len(yyv146) {
			yyv146 = yyv146[:yyl146]
			yyc146 = true
		}
		yyj146 := 0
		for ; yyj146 < yyrr146; yyj146++ {
			yyh146.ElemContainerState(yyj146)
			if r.TryDecodeAsNil() {
				yyv146[yyj146] = CertificateSigningRequestCondition{}
			} else {
				yyv147 := &yyv146[yyj146]
				yyv147.CodecDecodeSelf(d)
			}

		}
		if yyrt146 {
			for ; yyj146 < yyl146; yyj146++ {
				yyv146 = append(yyv146, CertificateSigningRequestCondition{})
				yyh146.ElemContainerState(yyj146)
				if r.TryDecodeAsNil() {
					yyv146[yyj146] = CertificateSigningRequestCondition{}
				} else {
					yyv148 := &yyv146[yyj146]
					yyv148.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj146 := 0
		for ; !r.CheckBreak(); yyj146++ {

			if yyj146 >= len(yyv146) {
				yyv146 = append(yyv146, CertificateSigningRequestCondition{}) // var yyz146 CertificateSigningRequestCondition
				yyc146 = true
			}
			yyh146.ElemContainerState(yyj146)
			if yyj146 < len(yyv146) {
				if r.TryDecodeAsNil() {
					yyv146[yyj146] = CertificateSigningRequestCondition{}
				} else {
					yyv149 := &yyv146[yyj146]
					yyv149.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj146 < len(yyv146) {
			yyv146 = yyv146[:yyj146]
			yyc146 = true
		} else if yyj146 == 0 && yyv146 == nil {
			yyv146 = []CertificateSigningRequestCondition{}
			yyc146 = true
		}
	}
	yyh146.End()
	if yyc146 {
		*v = yyv146
	}
}

func (x codecSelfer1234) encSliceCertificateSigningRequest(v []CertificateSigningRequest, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv150 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy151 := &yyv150
		yy151.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCertificateSigningRequest(v *[]CertificateSigningRequest, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv152 := *v
	yyh152, yyl152 := z.DecSliceHelperStart()
	var yyc152 bool
	if yyl152 == 0 {
		if yyv152 == nil {
			yyv152 = []CertificateSigningRequest{}
			yyc152 = true
		} else if len(yyv152) != 0 {
			yyv152 = yyv152[:0]
			yyc152 = true
		}
	} else if yyl152 > 0 {
		var yyrr152, yyrl152 int
		var yyrt152 bool
		if yyl152 > cap(yyv152) {

			yyrg152 := len(yyv152) > 0
			yyv2152 := yyv152
			yyrl152, yyrt152 = z.DecInferLen(yyl152, z.DecBasicHandle().MaxInitLen, 384)
			if yyrt152 {
				if yyrl152 <= cap(yyv152) {
					yyv152 = yyv152[:yyrl152]
				} else {
					yyv152 = make([]CertificateSigningRequest, yyrl152)
				}
			} else {
				yyv152 = make([]CertificateSigningRequest, yyrl152)
			}
			yyc152 = true
			yyrr152 = len(yyv152)
			if yyrg152 {
				copy(yyv152, yyv2152)
			}
		} else if yyl152 != len(yyv152) {
			yyv152 = yyv152[:yyl152]
			yyc152 = true
		}
		yyj152 := 0
		for ; yyj152 < yyrr152; yyj152++ {
			yyh152.ElemContainerState(yyj152)
			if r.TryDecodeAsNil() {
				yyv152[yyj152] = CertificateSigningRequest{}
			} else {
				yyv153 := &yyv152[yyj152]
				yyv153.CodecDecodeSelf(d)
			}

		}
		if yyrt152 {
			for ; yyj152 < yyl152; yyj152++ {
				yyv152 = append(yyv152, CertificateSigningRequest{})
				yyh152.ElemContainerState(yyj152)
				if r.TryDecodeAsNil() {
					yyv152[yyj152] = CertificateSigningRequest{}
				} else {
					yyv154 := &yyv152[yyj152]
					yyv154.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj152 := 0
		for ; !r.CheckBreak(); yyj152++ {

			if yyj152 >= len(yyv152) {
				yyv152 = append(yyv152, CertificateSigningRequest{}) // var yyz152 CertificateSigningRequest
				yyc152 = true
			}
			yyh152.ElemContainerState(yyj152)
			if yyj152 < len(yyv152) {
				if r.TryDecodeAsNil() {
					yyv152[yyj152] = CertificateSigningRequest{}
				} else {
					yyv155 := &yyv152[yyj152]
					yyv155.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj152 < len(yyv152) {
			yyv152 = yyv152[:yyj152]
			yyc152 = true
		} else if yyj152 == 0 && yyv152 == nil {
			yyv152 = []CertificateSigningRequest{}
			yyc152 = true
		}
	}
	yyh152.End()
	if yyc152 {
		*v = yyv152
	}
}
