/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v2alpha1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg4_resource "k8s.io/client-go/1.5/pkg/api/resource"
	pkg1_unversioned "k8s.io/client-go/1.5/pkg/api/unversioned"
	pkg2_v1 "k8s.io/client-go/1.5/pkg/api/v1"
	pkg3_types "k8s.io/client-go/1.5/pkg/types"
	pkg5_intstr "k8s.io/client-go/1.5/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg4_resource.Quantity
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg2_v1.ObjectMeta
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.ObjectMeta
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.Spec
					yy13.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy14 := &x.Spec
					yy14.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.Status
					yy16.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym18 := z.DecBinary()
	_ = yym18
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct19 := r.ContainerType()
		if yyct19 == codecSelferValueTypeMap1234 {
			yyl19 := r.ReadMapStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl19, d)
			}
		} else if yyct19 == codecSelferValueTypeArray1234 {
			yyl19 := r.ReadArrayStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl19, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys20Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys20Slc
	var yyhl20 bool = l >= 0
	for yyj20 := 0; ; yyj20++ {
		if yyhl20 {
			if yyj20 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys20Slc = r.DecodeBytes(yys20Slc, true, true)
		yys20 := string(yys20Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys20 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv23 := &x.ObjectMeta
				yyv23.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv24 := &x.Spec
				yyv24.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv25 := &x.Status
				yyv25.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys20)
		} // end switch yys20
	} // end for yyj20
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv29 := &x.ObjectMeta
		yyv29.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv30 := &x.Spec
		yyv30.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv31 := &x.Status
		yyv31.CodecDecodeSelf(d)
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym32 := z.EncBinary()
		_ = yym32
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep33 := !z.EncBinary()
			yy2arr33 := z.EncBasicHandle().StructToArray
			var yyq33 [4]bool
			_, _, _ = yysep33, yyq33, yy2arr33
			const yyr33 bool = false
			yyq33[0] = x.Kind != ""
			yyq33[1] = x.APIVersion != ""
			yyq33[2] = true
			var yynn33 int
			if yyr33 || yy2arr33 {
				r.EncodeArrayStart(4)
			} else {
				yynn33 = 1
				for _, b := range yyq33 {
					if b {
						yynn33++
					}
				}
				r.EncodeMapStart(yynn33)
				yynn33 = 0
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[0] {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[1] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[2] {
					yy41 := &x.ListMeta
					yym42 := z.EncBinary()
					_ = yym42
					if false {
					} else if z.HasExtensions() && z.EncExt(yy41) {
					} else {
						z.EncFallback(yy41)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq33[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.ListMeta
					yym44 := z.EncBinary()
					_ = yym44
					if false {
					} else if z.HasExtensions() && z.EncExt(yy43) {
					} else {
						z.EncFallback(yy43)
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym46 := z.EncBinary()
					_ = yym46
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym48 := z.DecBinary()
	_ = yym48
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct49 := r.ContainerType()
		if yyct49 == codecSelferValueTypeMap1234 {
			yyl49 := r.ReadMapStart()
			if yyl49 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl49, d)
			}
		} else if yyct49 == codecSelferValueTypeArray1234 {
			yyl49 := r.ReadArrayStart()
			if yyl49 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl49, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys50Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys50Slc
	var yyhl50 bool = l >= 0
	for yyj50 := 0; ; yyj50++ {
		if yyhl50 {
			if yyj50 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys50Slc = r.DecodeBytes(yys50Slc, true, true)
		yys50 := string(yys50Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys50 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv53 := &x.ListMeta
				yym54 := z.DecBinary()
				_ = yym54
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv53) {
				} else {
					z.DecFallback(yyv53, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv55 := &x.Items
				yym56 := z.DecBinary()
				_ = yym56
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv55), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys50)
		} // end switch yys50
	} // end for yyj50
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj57 int
	var yyb57 bool
	var yyhl57 bool = l >= 0
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv60 := &x.ListMeta
		yym61 := z.DecBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv60) {
		} else {
			z.DecFallback(yyv60, false)
		}
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv62 := &x.Items
		yym63 := z.DecBinary()
		_ = yym63
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv62), d)
		}
	}
	for {
		yyj57++
		if yyhl57 {
			yyb57 = yyj57 > l
		} else {
			yyb57 = r.CheckBreak()
		}
		if yyb57 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj57-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym64 := z.EncBinary()
		_ = yym64
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep65 := !z.EncBinary()
			yy2arr65 := z.EncBasicHandle().StructToArray
			var yyq65 [4]bool
			_, _, _ = yysep65, yyq65, yy2arr65
			const yyr65 bool = false
			yyq65[0] = x.Kind != ""
			yyq65[1] = x.APIVersion != ""
			yyq65[2] = true
			yyq65[3] = true
			var yynn65 int
			if yyr65 || yy2arr65 {
				r.EncodeArrayStart(4)
			} else {
				yynn65 = 0
				for _, b := range yyq65 {
					if b {
						yynn65++
					}
				}
				r.EncodeMapStart(yynn65)
				yynn65 = 0
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[0] {
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq65[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[1] {
					yym70 := z.EncBinary()
					_ = yym70
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq65[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym71 := z.EncBinary()
					_ = yym71
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[2] {
					yy73 := &x.ObjectMeta
					yy73.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy74 := &x.ObjectMeta
					yy74.CodecEncodeSelf(e)
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[3] {
					yy76 := &x.Template
					yy76.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy77 := &x.Template
					yy77.CodecEncodeSelf(e)
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym78 := z.DecBinary()
	_ = yym78
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct79 := r.ContainerType()
		if yyct79 == codecSelferValueTypeMap1234 {
			yyl79 := r.ReadMapStart()
			if yyl79 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl79, d)
			}
		} else if yyct79 == codecSelferValueTypeArray1234 {
			yyl79 := r.ReadArrayStart()
			if yyl79 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl79, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys80Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys80Slc
	var yyhl80 bool = l >= 0
	for yyj80 := 0; ; yyj80++ {
		if yyhl80 {
			if yyj80 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys80Slc = r.DecodeBytes(yys80Slc, true, true)
		yys80 := string(yys80Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys80 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv83 := &x.ObjectMeta
				yyv83.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = JobTemplateSpec{}
			} else {
				yyv84 := &x.Template
				yyv84.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys80)
		} // end switch yys80
	} // end for yyj80
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj85 int
	var yyb85 bool
	var yyhl85 bool = l >= 0
	yyj85++
	if yyhl85 {
		yyb85 = yyj85 > l
	} else {
		yyb85 = r.CheckBreak()
	}
	if yyb85 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj85++
	if yyhl85 {
		yyb85 = yyj85 > l
	} else {
		yyb85 = r.CheckBreak()
	}
	if yyb85 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj85++
	if yyhl85 {
		yyb85 = yyj85 > l
	} else {
		yyb85 = r.CheckBreak()
	}
	if yyb85 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv88 := &x.ObjectMeta
		yyv88.CodecDecodeSelf(d)
	}
	yyj85++
	if yyhl85 {
		yyb85 = yyj85 > l
	} else {
		yyb85 = r.CheckBreak()
	}
	if yyb85 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = JobTemplateSpec{}
	} else {
		yyv89 := &x.Template
		yyv89.CodecDecodeSelf(d)
	}
	for {
		yyj85++
		if yyhl85 {
			yyb85 = yyj85 > l
		} else {
			yyb85 = r.CheckBreak()
		}
		if yyb85 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj85-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym90 := z.EncBinary()
		_ = yym90
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep91 := !z.EncBinary()
			yy2arr91 := z.EncBasicHandle().StructToArray
			var yyq91 [2]bool
			_, _, _ = yysep91, yyq91, yy2arr91
			const yyr91 bool = false
			yyq91[0] = true
			yyq91[1] = true
			var yynn91 int
			if yyr91 || yy2arr91 {
				r.EncodeArrayStart(2)
			} else {
				yynn91 = 0
				for _, b := range yyq91 {
					if b {
						yynn91++
					}
				}
				r.EncodeMapStart(yynn91)
				yynn91 = 0
			}
			if yyr91 || yy2arr91 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq91[0] {
					yy93 := &x.ObjectMeta
					yy93.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq91[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy94 := &x.ObjectMeta
					yy94.CodecEncodeSelf(e)
				}
			}
			if yyr91 || yy2arr91 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq91[1] {
					yy96 := &x.Spec
					yy96.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq91[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy97 := &x.Spec
					yy97.CodecEncodeSelf(e)
				}
			}
			if yyr91 || yy2arr91 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym98 := z.DecBinary()
	_ = yym98
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct99 := r.ContainerType()
		if yyct99 == codecSelferValueTypeMap1234 {
			yyl99 := r.ReadMapStart()
			if yyl99 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl99, d)
			}
		} else if yyct99 == codecSelferValueTypeArray1234 {
			yyl99 := r.ReadArrayStart()
			if yyl99 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl99, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys100Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys100Slc
	var yyhl100 bool = l >= 0
	for yyj100 := 0; ; yyj100++ {
		if yyhl100 {
			if yyj100 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys100Slc = r.DecodeBytes(yys100Slc, true, true)
		yys100 := string(yys100Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys100 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv101 := &x.ObjectMeta
				yyv101.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv102 := &x.Spec
				yyv102.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys100)
		} // end switch yys100
	} // end for yyj100
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj103 int
	var yyb103 bool
	var yyhl103 bool = l >= 0
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv104 := &x.ObjectMeta
		yyv104.CodecDecodeSelf(d)
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv105 := &x.Spec
		yyv105.CodecDecodeSelf(d)
	}
	for {
		yyj103++
		if yyhl103 {
			yyb103 = yyj103 > l
		} else {
			yyb103 = r.CheckBreak()
		}
		if yyb103 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj103-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym106 := z.EncBinary()
		_ = yym106
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep107 := !z.EncBinary()
			yy2arr107 := z.EncBasicHandle().StructToArray
			var yyq107 [6]bool
			_, _, _ = yysep107, yyq107, yy2arr107
			const yyr107 bool = false
			yyq107[0] = x.Parallelism != nil
			yyq107[1] = x.Completions != nil
			yyq107[2] = x.ActiveDeadlineSeconds != nil
			yyq107[3] = x.Selector != nil
			yyq107[4] = x.ManualSelector != nil
			var yynn107 int
			if yyr107 || yy2arr107 {
				r.EncodeArrayStart(6)
			} else {
				yynn107 = 1
				for _, b := range yyq107 {
					if b {
						yynn107++
					}
				}
				r.EncodeMapStart(yynn107)
				yynn107 = 0
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq107[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy109 := *x.Parallelism
						yym110 := z.EncBinary()
						_ = yym110
						if false {
						} else {
							r.EncodeInt(int64(yy109))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq107[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy111 := *x.Parallelism
						yym112 := z.EncBinary()
						_ = yym112
						if false {
						} else {
							r.EncodeInt(int64(yy111))
						}
					}
				}
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq107[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy114 := *x.Completions
						yym115 := z.EncBinary()
						_ = yym115
						if false {
						} else {
							r.EncodeInt(int64(yy114))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq107[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy116 := *x.Completions
						yym117 := z.EncBinary()
						_ = yym117
						if false {
						} else {
							r.EncodeInt(int64(yy116))
						}
					}
				}
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq107[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy119 := *x.ActiveDeadlineSeconds
						yym120 := z.EncBinary()
						_ = yym120
						if false {
						} else {
							r.EncodeInt(int64(yy119))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq107[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy121 := *x.ActiveDeadlineSeconds
						yym122 := z.EncBinary()
						_ = yym122
						if false {
						} else {
							r.EncodeInt(int64(yy121))
						}
					}
				}
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq107[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq107[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq107[4] {
					if x.ManualSelector == nil {
						r.EncodeNil()
					} else {
						yy125 := *x.ManualSelector
						yym126 := z.EncBinary()
						_ = yym126
						if false {
						} else {
							r.EncodeBool(bool(yy125))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq107[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("manualSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ManualSelector == nil {
						r.EncodeNil()
					} else {
						yy127 := *x.ManualSelector
						yym128 := z.EncBinary()
						_ = yym128
						if false {
						} else {
							r.EncodeBool(bool(yy127))
						}
					}
				}
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy130 := &x.Template
				yy130.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy131 := &x.Template
				yy131.CodecEncodeSelf(e)
			}
			if yyr107 || yy2arr107 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym132 := z.DecBinary()
	_ = yym132
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct133 := r.ContainerType()
		if yyct133 == codecSelferValueTypeMap1234 {
			yyl133 := r.ReadMapStart()
			if yyl133 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl133, d)
			}
		} else if yyct133 == codecSelferValueTypeArray1234 {
			yyl133 := r.ReadArrayStart()
			if yyl133 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl133, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys134Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys134Slc
	var yyhl134 bool = l >= 0
	for yyj134 := 0; ; yyj134++ {
		if yyhl134 {
			if yyj134 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys134Slc = r.DecodeBytes(yys134Slc, true, true)
		yys134 := string(yys134Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys134 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int32)
				}
				yym136 := z.DecBinary()
				_ = yym136
				if false {
				} else {
					*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int32)
				}
				yym138 := z.DecBinary()
				_ = yym138
				if false {
				} else {
					*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym140 := z.DecBinary()
				_ = yym140
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "manualSelector":
			if r.TryDecodeAsNil() {
				if x.ManualSelector != nil {
					x.ManualSelector = nil
				}
			} else {
				if x.ManualSelector == nil {
					x.ManualSelector = new(bool)
				}
				yym143 := z.DecBinary()
				_ = yym143
				if false {
				} else {
					*((*bool)(x.ManualSelector)) = r.DecodeBool()
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv144 := &x.Template
				yyv144.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys134)
		} // end switch yys134
	} // end for yyj134
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj145 int
	var yyb145 bool
	var yyhl145 bool = l >= 0
	yyj145++
	if yyhl145 {
		yyb145 = yyj145 > l
	} else {
		yyb145 = r.CheckBreak()
	}
	if yyb145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int32)
		}
		yym147 := z.DecBinary()
		_ = yym147
		if false {
		} else {
			*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
		}
	}
	yyj145++
	if yyhl145 {
		yyb145 = yyj145 > l
	} else {
		yyb145 = r.CheckBreak()
	}
	if yyb145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int32)
		}
		yym149 := z.DecBinary()
		_ = yym149
		if false {
		} else {
			*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
		}
	}
	yyj145++
	if yyhl145 {
		yyb145 = yyj145 > l
	} else {
		yyb145 = r.CheckBreak()
	}
	if yyb145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym151 := z.DecBinary()
		_ = yym151
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj145++
	if yyhl145 {
		yyb145 = yyj145 > l
	} else {
		yyb145 = r.CheckBreak()
	}
	if yyb145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj145++
	if yyhl145 {
		yyb145 = yyj145 > l
	} else {
		yyb145 = r.CheckBreak()
	}
	if yyb145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ManualSelector != nil {
			x.ManualSelector = nil
		}
	} else {
		if x.ManualSelector == nil {
			x.ManualSelector = new(bool)
		}
		yym154 := z.DecBinary()
		_ = yym154
		if false {
		} else {
			*((*bool)(x.ManualSelector)) = r.DecodeBool()
		}
	}
	yyj145++
	if yyhl145 {
		yyb145 = yyj145 > l
	} else {
		yyb145 = r.CheckBreak()
	}
	if yyb145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv155 := &x.Template
		yyv155.CodecDecodeSelf(d)
	}
	for {
		yyj145++
		if yyhl145 {
			yyb145 = yyj145 > l
		} else {
			yyb145 = r.CheckBreak()
		}
		if yyb145 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj145-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym156 := z.EncBinary()
		_ = yym156
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep157 := !z.EncBinary()
			yy2arr157 := z.EncBasicHandle().StructToArray
			var yyq157 [6]bool
			_, _, _ = yysep157, yyq157, yy2arr157
			const yyr157 bool = false
			yyq157[0] = len(x.Conditions) != 0
			yyq157[1] = x.StartTime != nil
			yyq157[2] = x.CompletionTime != nil
			yyq157[3] = x.Active != 0
			yyq157[4] = x.Succeeded != 0
			yyq157[5] = x.Failed != 0
			var yynn157 int
			if yyr157 || yy2arr157 {
				r.EncodeArrayStart(6)
			} else {
				yynn157 = 0
				for _, b := range yyq157 {
					if b {
						yynn157++
					}
				}
				r.EncodeMapStart(yynn157)
				yynn157 = 0
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq157[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym159 := z.EncBinary()
						_ = yym159
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq157[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym160 := z.EncBinary()
						_ = yym160
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq157[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym162 := z.EncBinary()
						_ = yym162
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym162 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym162 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq157[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym163 := z.EncBinary()
						_ = yym163
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym163 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym163 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq157[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym165 := z.EncBinary()
						_ = yym165
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym165 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym165 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq157[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym166 := z.EncBinary()
						_ = yym166
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym166 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym166 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq157[3] {
					yym168 := z.EncBinary()
					_ = yym168
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq157[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym169 := z.EncBinary()
					_ = yym169
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq157[4] {
					yym171 := z.EncBinary()
					_ = yym171
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq157[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym172 := z.EncBinary()
					_ = yym172
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq157[5] {
					yym174 := z.EncBinary()
					_ = yym174
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq157[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym175 := z.EncBinary()
					_ = yym175
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr157 || yy2arr157 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym176 := z.DecBinary()
	_ = yym176
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct177 := r.ContainerType()
		if yyct177 == codecSelferValueTypeMap1234 {
			yyl177 := r.ReadMapStart()
			if yyl177 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl177, d)
			}
		} else if yyct177 == codecSelferValueTypeArray1234 {
			yyl177 := r.ReadArrayStart()
			if yyl177 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl177, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys178Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys178Slc
	var yyhl178 bool = l >= 0
	for yyj178 := 0; ; yyj178++ {
		if yyhl178 {
			if yyj178 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys178Slc = r.DecodeBytes(yys178Slc, true, true)
		yys178 := string(yys178Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys178 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv179 := &x.Conditions
				yym180 := z.DecBinary()
				_ = yym180
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv179), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_unversioned.Time)
				}
				yym182 := z.DecBinary()
				_ = yym182
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym182 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym182 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_unversioned.Time)
				}
				yym184 := z.DecBinary()
				_ = yym184
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym184 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym184 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int32(r.DecodeInt(32))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int32(r.DecodeInt(32))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys178)
		} // end switch yys178
	} // end for yyj178
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj188 int
	var yyb188 bool
	var yyhl188 bool = l >= 0
	yyj188++
	if yyhl188 {
		yyb188 = yyj188 > l
	} else {
		yyb188 = r.CheckBreak()
	}
	if yyb188 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv189 := &x.Conditions
		yym190 := z.DecBinary()
		_ = yym190
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv189), d)
		}
	}
	yyj188++
	if yyhl188 {
		yyb188 = yyj188 > l
	} else {
		yyb188 = r.CheckBreak()
	}
	if yyb188 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_unversioned.Time)
		}
		yym192 := z.DecBinary()
		_ = yym192
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym192 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym192 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj188++
	if yyhl188 {
		yyb188 = yyj188 > l
	} else {
		yyb188 = r.CheckBreak()
	}
	if yyb188 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_unversioned.Time)
		}
		yym194 := z.DecBinary()
		_ = yym194
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym194 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym194 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj188++
	if yyhl188 {
		yyb188 = yyj188 > l
	} else {
		yyb188 = r.CheckBreak()
	}
	if yyb188 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int32(r.DecodeInt(32))
	}
	yyj188++
	if yyhl188 {
		yyb188 = yyj188 > l
	} else {
		yyb188 = r.CheckBreak()
	}
	if yyb188 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int32(r.DecodeInt(32))
	}
	yyj188++
	if yyhl188 {
		yyb188 = yyj188 > l
	} else {
		yyb188 = r.CheckBreak()
	}
	if yyb188 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int32(r.DecodeInt(32))
	}
	for {
		yyj188++
		if yyhl188 {
			yyb188 = yyj188 > l
		} else {
			yyb188 = r.CheckBreak()
		}
		if yyb188 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj188-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym198 := z.EncBinary()
	_ = yym198
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym199 := z.DecBinary()
	_ = yym199
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym200 := z.EncBinary()
		_ = yym200
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep201 := !z.EncBinary()
			yy2arr201 := z.EncBasicHandle().StructToArray
			var yyq201 [6]bool
			_, _, _ = yysep201, yyq201, yy2arr201
			const yyr201 bool = false
			yyq201[2] = true
			yyq201[3] = true
			yyq201[4] = x.Reason != ""
			yyq201[5] = x.Message != ""
			var yynn201 int
			if yyr201 || yy2arr201 {
				r.EncodeArrayStart(6)
			} else {
				yynn201 = 2
				for _, b := range yyq201 {
					if b {
						yynn201++
					}
				}
				r.EncodeMapStart(yynn201)
				yynn201 = 0
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym205 := z.EncBinary()
				_ = yym205
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[2] {
					yy207 := &x.LastProbeTime
					yym208 := z.EncBinary()
					_ = yym208
					if false {
					} else if z.HasExtensions() && z.EncExt(yy207) {
					} else if yym208 {
						z.EncBinaryMarshal(yy207)
					} else if !yym208 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy207)
					} else {
						z.EncFallback(yy207)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy209 := &x.LastProbeTime
					yym210 := z.EncBinary()
					_ = yym210
					if false {
					} else if z.HasExtensions() && z.EncExt(yy209) {
					} else if yym210 {
						z.EncBinaryMarshal(yy209)
					} else if !yym210 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy209)
					} else {
						z.EncFallback(yy209)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[3] {
					yy212 := &x.LastTransitionTime
					yym213 := z.EncBinary()
					_ = yym213
					if false {
					} else if z.HasExtensions() && z.EncExt(yy212) {
					} else if yym213 {
						z.EncBinaryMarshal(yy212)
					} else if !yym213 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy212)
					} else {
						z.EncFallback(yy212)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq201[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy214 := &x.LastTransitionTime
					yym215 := z.EncBinary()
					_ = yym215
					if false {
					} else if z.HasExtensions() && z.EncExt(yy214) {
					} else if yym215 {
						z.EncBinaryMarshal(yy214)
					} else if !yym215 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy214)
					} else {
						z.EncFallback(yy214)
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[4] {
					yym217 := z.EncBinary()
					_ = yym217
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq201[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym218 := z.EncBinary()
					_ = yym218
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq201[5] {
					yym220 := z.EncBinary()
					_ = yym220
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq201[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym221 := z.EncBinary()
					_ = yym221
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr201 || yy2arr201 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym222 := z.DecBinary()
	_ = yym222
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct223 := r.ContainerType()
		if yyct223 == codecSelferValueTypeMap1234 {
			yyl223 := r.ReadMapStart()
			if yyl223 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl223, d)
			}
		} else if yyct223 == codecSelferValueTypeArray1234 {
			yyl223 := r.ReadArrayStart()
			if yyl223 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl223, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys224Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys224Slc
	var yyhl224 bool = l >= 0
	for yyj224 := 0; ; yyj224++ {
		if yyhl224 {
			if yyj224 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys224Slc = r.DecodeBytes(yys224Slc, true, true)
		yys224 := string(yys224Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys224 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_unversioned.Time{}
			} else {
				yyv227 := &x.LastProbeTime
				yym228 := z.DecBinary()
				_ = yym228
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv227) {
				} else if yym228 {
					z.DecBinaryUnmarshal(yyv227)
				} else if !yym228 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv227)
				} else {
					z.DecFallback(yyv227, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv229 := &x.LastTransitionTime
				yym230 := z.DecBinary()
				_ = yym230
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv229) {
				} else if yym230 {
					z.DecBinaryUnmarshal(yyv229)
				} else if !yym230 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv229)
				} else {
					z.DecFallback(yyv229, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys224)
		} // end switch yys224
	} // end for yyj224
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj233 int
	var yyb233 bool
	var yyhl233 bool = l >= 0
	yyj233++
	if yyhl233 {
		yyb233 = yyj233 > l
	} else {
		yyb233 = r.CheckBreak()
	}
	if yyb233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj233++
	if yyhl233 {
		yyb233 = yyj233 > l
	} else {
		yyb233 = r.CheckBreak()
	}
	if yyb233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj233++
	if yyhl233 {
		yyb233 = yyj233 > l
	} else {
		yyb233 = r.CheckBreak()
	}
	if yyb233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_unversioned.Time{}
	} else {
		yyv236 := &x.LastProbeTime
		yym237 := z.DecBinary()
		_ = yym237
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv236) {
		} else if yym237 {
			z.DecBinaryUnmarshal(yyv236)
		} else if !yym237 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv236)
		} else {
			z.DecFallback(yyv236, false)
		}
	}
	yyj233++
	if yyhl233 {
		yyb233 = yyj233 > l
	} else {
		yyb233 = r.CheckBreak()
	}
	if yyb233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv238 := &x.LastTransitionTime
		yym239 := z.DecBinary()
		_ = yym239
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv238) {
		} else if yym239 {
			z.DecBinaryUnmarshal(yyv238)
		} else if !yym239 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv238)
		} else {
			z.DecFallback(yyv238, false)
		}
	}
	yyj233++
	if yyhl233 {
		yyb233 = yyj233 > l
	} else {
		yyb233 = r.CheckBreak()
	}
	if yyb233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj233++
	if yyhl233 {
		yyb233 = yyj233 > l
	} else {
		yyb233 = r.CheckBreak()
	}
	if yyb233 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj233++
		if yyhl233 {
			yyb233 = yyj233 > l
		} else {
			yyb233 = r.CheckBreak()
		}
		if yyb233 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj233-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScheduledJob) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym242 := z.EncBinary()
		_ = yym242
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep243 := !z.EncBinary()
			yy2arr243 := z.EncBasicHandle().StructToArray
			var yyq243 [5]bool
			_, _, _ = yysep243, yyq243, yy2arr243
			const yyr243 bool = false
			yyq243[0] = x.Kind != ""
			yyq243[1] = x.APIVersion != ""
			yyq243[2] = true
			yyq243[3] = true
			yyq243[4] = true
			var yynn243 int
			if yyr243 || yy2arr243 {
				r.EncodeArrayStart(5)
			} else {
				yynn243 = 0
				for _, b := range yyq243 {
					if b {
						yynn243++
					}
				}
				r.EncodeMapStart(yynn243)
				yynn243 = 0
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq243[0] {
					yym245 := z.EncBinary()
					_ = yym245
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq243[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym246 := z.EncBinary()
					_ = yym246
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq243[1] {
					yym248 := z.EncBinary()
					_ = yym248
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq243[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym249 := z.EncBinary()
					_ = yym249
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq243[2] {
					yy251 := &x.ObjectMeta
					yy251.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq243[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy252 := &x.ObjectMeta
					yy252.CodecEncodeSelf(e)
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq243[3] {
					yy254 := &x.Spec
					yy254.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq243[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy255 := &x.Spec
					yy255.CodecEncodeSelf(e)
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq243[4] {
					yy257 := &x.Status
					yy257.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq243[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy258 := &x.Status
					yy258.CodecEncodeSelf(e)
				}
			}
			if yyr243 || yy2arr243 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScheduledJob) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym259 := z.DecBinary()
	_ = yym259
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct260 := r.ContainerType()
		if yyct260 == codecSelferValueTypeMap1234 {
			yyl260 := r.ReadMapStart()
			if yyl260 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl260, d)
			}
		} else if yyct260 == codecSelferValueTypeArray1234 {
			yyl260 := r.ReadArrayStart()
			if yyl260 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl260, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScheduledJob) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys261Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys261Slc
	var yyhl261 bool = l >= 0
	for yyj261 := 0; ; yyj261++ {
		if yyhl261 {
			if yyj261 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys261Slc = r.DecodeBytes(yys261Slc, true, true)
		yys261 := string(yys261Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys261 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv264 := &x.ObjectMeta
				yyv264.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScheduledJobSpec{}
			} else {
				yyv265 := &x.Spec
				yyv265.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScheduledJobStatus{}
			} else {
				yyv266 := &x.Status
				yyv266.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys261)
		} // end switch yys261
	} // end for yyj261
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScheduledJob) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj267 int
	var yyb267 bool
	var yyhl267 bool = l >= 0
	yyj267++
	if yyhl267 {
		yyb267 = yyj267 > l
	} else {
		yyb267 = r.CheckBreak()
	}
	if yyb267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj267++
	if yyhl267 {
		yyb267 = yyj267 > l
	} else {
		yyb267 = r.CheckBreak()
	}
	if yyb267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj267++
	if yyhl267 {
		yyb267 = yyj267 > l
	} else {
		yyb267 = r.CheckBreak()
	}
	if yyb267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv270 := &x.ObjectMeta
		yyv270.CodecDecodeSelf(d)
	}
	yyj267++
	if yyhl267 {
		yyb267 = yyj267 > l
	} else {
		yyb267 = r.CheckBreak()
	}
	if yyb267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScheduledJobSpec{}
	} else {
		yyv271 := &x.Spec
		yyv271.CodecDecodeSelf(d)
	}
	yyj267++
	if yyhl267 {
		yyb267 = yyj267 > l
	} else {
		yyb267 = r.CheckBreak()
	}
	if yyb267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScheduledJobStatus{}
	} else {
		yyv272 := &x.Status
		yyv272.CodecDecodeSelf(d)
	}
	for {
		yyj267++
		if yyhl267 {
			yyb267 = yyj267 > l
		} else {
			yyb267 = r.CheckBreak()
		}
		if yyb267 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj267-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScheduledJobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym273 := z.EncBinary()
		_ = yym273
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep274 := !z.EncBinary()
			yy2arr274 := z.EncBasicHandle().StructToArray
			var yyq274 [4]bool
			_, _, _ = yysep274, yyq274, yy2arr274
			const yyr274 bool = false
			yyq274[0] = x.Kind != ""
			yyq274[1] = x.APIVersion != ""
			yyq274[2] = true
			var yynn274 int
			if yyr274 || yy2arr274 {
				r.EncodeArrayStart(4)
			} else {
				yynn274 = 1
				for _, b := range yyq274 {
					if b {
						yynn274++
					}
				}
				r.EncodeMapStart(yynn274)
				yynn274 = 0
			}
			if yyr274 || yy2arr274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq274[0] {
					yym276 := z.EncBinary()
					_ = yym276
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq274[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym277 := z.EncBinary()
					_ = yym277
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr274 || yy2arr274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq274[1] {
					yym279 := z.EncBinary()
					_ = yym279
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq274[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym280 := z.EncBinary()
					_ = yym280
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr274 || yy2arr274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq274[2] {
					yy282 := &x.ListMeta
					yym283 := z.EncBinary()
					_ = yym283
					if false {
					} else if z.HasExtensions() && z.EncExt(yy282) {
					} else {
						z.EncFallback(yy282)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq274[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy284 := &x.ListMeta
					yym285 := z.EncBinary()
					_ = yym285
					if false {
					} else if z.HasExtensions() && z.EncExt(yy284) {
					} else {
						z.EncFallback(yy284)
					}
				}
			}
			if yyr274 || yy2arr274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym287 := z.EncBinary()
					_ = yym287
					if false {
					} else {
						h.encSliceScheduledJob(([]ScheduledJob)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym288 := z.EncBinary()
					_ = yym288
					if false {
					} else {
						h.encSliceScheduledJob(([]ScheduledJob)(x.Items), e)
					}
				}
			}
			if yyr274 || yy2arr274 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScheduledJobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym289 := z.DecBinary()
	_ = yym289
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct290 := r.ContainerType()
		if yyct290 == codecSelferValueTypeMap1234 {
			yyl290 := r.ReadMapStart()
			if yyl290 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl290, d)
			}
		} else if yyct290 == codecSelferValueTypeArray1234 {
			yyl290 := r.ReadArrayStart()
			if yyl290 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl290, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScheduledJobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys291Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys291Slc
	var yyhl291 bool = l >= 0
	for yyj291 := 0; ; yyj291++ {
		if yyhl291 {
			if yyj291 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys291Slc = r.DecodeBytes(yys291Slc, true, true)
		yys291 := string(yys291Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys291 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv294 := &x.ListMeta
				yym295 := z.DecBinary()
				_ = yym295
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv294) {
				} else {
					z.DecFallback(yyv294, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv296 := &x.Items
				yym297 := z.DecBinary()
				_ = yym297
				if false {
				} else {
					h.decSliceScheduledJob((*[]ScheduledJob)(yyv296), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys291)
		} // end switch yys291
	} // end for yyj291
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScheduledJobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj298 int
	var yyb298 bool
	var yyhl298 bool = l >= 0
	yyj298++
	if yyhl298 {
		yyb298 = yyj298 > l
	} else {
		yyb298 = r.CheckBreak()
	}
	if yyb298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj298++
	if yyhl298 {
		yyb298 = yyj298 > l
	} else {
		yyb298 = r.CheckBreak()
	}
	if yyb298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj298++
	if yyhl298 {
		yyb298 = yyj298 > l
	} else {
		yyb298 = r.CheckBreak()
	}
	if yyb298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv301 := &x.ListMeta
		yym302 := z.DecBinary()
		_ = yym302
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv301) {
		} else {
			z.DecFallback(yyv301, false)
		}
	}
	yyj298++
	if yyhl298 {
		yyb298 = yyj298 > l
	} else {
		yyb298 = r.CheckBreak()
	}
	if yyb298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv303 := &x.Items
		yym304 := z.DecBinary()
		_ = yym304
		if false {
		} else {
			h.decSliceScheduledJob((*[]ScheduledJob)(yyv303), d)
		}
	}
	for {
		yyj298++
		if yyhl298 {
			yyb298 = yyj298 > l
		} else {
			yyb298 = r.CheckBreak()
		}
		if yyb298 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj298-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScheduledJobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym305 := z.EncBinary()
		_ = yym305
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep306 := !z.EncBinary()
			yy2arr306 := z.EncBasicHandle().StructToArray
			var yyq306 [5]bool
			_, _, _ = yysep306, yyq306, yy2arr306
			const yyr306 bool = false
			yyq306[1] = x.StartingDeadlineSeconds != nil
			yyq306[2] = x.ConcurrencyPolicy != ""
			yyq306[3] = x.Suspend != nil
			var yynn306 int
			if yyr306 || yy2arr306 {
				r.EncodeArrayStart(5)
			} else {
				yynn306 = 2
				for _, b := range yyq306 {
					if b {
						yynn306++
					}
				}
				r.EncodeMapStart(yynn306)
				yynn306 = 0
			}
			if yyr306 || yy2arr306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym308 := z.EncBinary()
				_ = yym308
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Schedule))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym309 := z.EncBinary()
				_ = yym309
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Schedule))
				}
			}
			if yyr306 || yy2arr306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq306[1] {
					if x.StartingDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy311 := *x.StartingDeadlineSeconds
						yym312 := z.EncBinary()
						_ = yym312
						if false {
						} else {
							r.EncodeInt(int64(yy311))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq306[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startingDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartingDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy313 := *x.StartingDeadlineSeconds
						yym314 := z.EncBinary()
						_ = yym314
						if false {
						} else {
							r.EncodeInt(int64(yy313))
						}
					}
				}
			}
			if yyr306 || yy2arr306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq306[2] {
					x.ConcurrencyPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq306[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("concurrencyPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.ConcurrencyPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr306 || yy2arr306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq306[3] {
					if x.Suspend == nil {
						r.EncodeNil()
					} else {
						yy317 := *x.Suspend
						yym318 := z.EncBinary()
						_ = yym318
						if false {
						} else {
							r.EncodeBool(bool(yy317))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq306[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("suspend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Suspend == nil {
						r.EncodeNil()
					} else {
						yy319 := *x.Suspend
						yym320 := z.EncBinary()
						_ = yym320
						if false {
						} else {
							r.EncodeBool(bool(yy319))
						}
					}
				}
			}
			if yyr306 || yy2arr306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy322 := &x.JobTemplate
				yy322.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("jobTemplate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy323 := &x.JobTemplate
				yy323.CodecEncodeSelf(e)
			}
			if yyr306 || yy2arr306 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScheduledJobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym324 := z.DecBinary()
	_ = yym324
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct325 := r.ContainerType()
		if yyct325 == codecSelferValueTypeMap1234 {
			yyl325 := r.ReadMapStart()
			if yyl325 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl325, d)
			}
		} else if yyct325 == codecSelferValueTypeArray1234 {
			yyl325 := r.ReadArrayStart()
			if yyl325 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl325, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScheduledJobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys326Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys326Slc
	var yyhl326 bool = l >= 0
	for yyj326 := 0; ; yyj326++ {
		if yyhl326 {
			if yyj326 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys326Slc = r.DecodeBytes(yys326Slc, true, true)
		yys326 := string(yys326Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys326 {
		case "schedule":
			if r.TryDecodeAsNil() {
				x.Schedule = ""
			} else {
				x.Schedule = string(r.DecodeString())
			}
		case "startingDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.StartingDeadlineSeconds != nil {
					x.StartingDeadlineSeconds = nil
				}
			} else {
				if x.StartingDeadlineSeconds == nil {
					x.StartingDeadlineSeconds = new(int64)
				}
				yym329 := z.DecBinary()
				_ = yym329
				if false {
				} else {
					*((*int64)(x.StartingDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "concurrencyPolicy":
			if r.TryDecodeAsNil() {
				x.ConcurrencyPolicy = ""
			} else {
				x.ConcurrencyPolicy = ConcurrencyPolicy(r.DecodeString())
			}
		case "suspend":
			if r.TryDecodeAsNil() {
				if x.Suspend != nil {
					x.Suspend = nil
				}
			} else {
				if x.Suspend == nil {
					x.Suspend = new(bool)
				}
				yym332 := z.DecBinary()
				_ = yym332
				if false {
				} else {
					*((*bool)(x.Suspend)) = r.DecodeBool()
				}
			}
		case "jobTemplate":
			if r.TryDecodeAsNil() {
				x.JobTemplate = JobTemplateSpec{}
			} else {
				yyv333 := &x.JobTemplate
				yyv333.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys326)
		} // end switch yys326
	} // end for yyj326
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScheduledJobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj334 int
	var yyb334 bool
	var yyhl334 bool = l >= 0
	yyj334++
	if yyhl334 {
		yyb334 = yyj334 > l
	} else {
		yyb334 = r.CheckBreak()
	}
	if yyb334 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Schedule = ""
	} else {
		x.Schedule = string(r.DecodeString())
	}
	yyj334++
	if yyhl334 {
		yyb334 = yyj334 > l
	} else {
		yyb334 = r.CheckBreak()
	}
	if yyb334 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartingDeadlineSeconds != nil {
			x.StartingDeadlineSeconds = nil
		}
	} else {
		if x.StartingDeadlineSeconds == nil {
			x.StartingDeadlineSeconds = new(int64)
		}
		yym337 := z.DecBinary()
		_ = yym337
		if false {
		} else {
			*((*int64)(x.StartingDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj334++
	if yyhl334 {
		yyb334 = yyj334 > l
	} else {
		yyb334 = r.CheckBreak()
	}
	if yyb334 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrencyPolicy = ""
	} else {
		x.ConcurrencyPolicy = ConcurrencyPolicy(r.DecodeString())
	}
	yyj334++
	if yyhl334 {
		yyb334 = yyj334 > l
	} else {
		yyb334 = r.CheckBreak()
	}
	if yyb334 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Suspend != nil {
			x.Suspend = nil
		}
	} else {
		if x.Suspend == nil {
			x.Suspend = new(bool)
		}
		yym340 := z.DecBinary()
		_ = yym340
		if false {
		} else {
			*((*bool)(x.Suspend)) = r.DecodeBool()
		}
	}
	yyj334++
	if yyhl334 {
		yyb334 = yyj334 > l
	} else {
		yyb334 = r.CheckBreak()
	}
	if yyb334 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.JobTemplate = JobTemplateSpec{}
	} else {
		yyv341 := &x.JobTemplate
		yyv341.CodecDecodeSelf(d)
	}
	for {
		yyj334++
		if yyhl334 {
			yyb334 = yyj334 > l
		} else {
			yyb334 = r.CheckBreak()
		}
		if yyb334 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj334-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConcurrencyPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym342 := z.EncBinary()
	_ = yym342
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConcurrencyPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym343 := z.DecBinary()
	_ = yym343
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ScheduledJobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym344 := z.EncBinary()
		_ = yym344
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep345 := !z.EncBinary()
			yy2arr345 := z.EncBasicHandle().StructToArray
			var yyq345 [2]bool
			_, _, _ = yysep345, yyq345, yy2arr345
			const yyr345 bool = false
			yyq345[0] = len(x.Active) != 0
			yyq345[1] = x.LastScheduleTime != nil
			var yynn345 int
			if yyr345 || yy2arr345 {
				r.EncodeArrayStart(2)
			} else {
				yynn345 = 0
				for _, b := range yyq345 {
					if b {
						yynn345++
					}
				}
				r.EncodeMapStart(yynn345)
				yynn345 = 0
			}
			if yyr345 || yy2arr345 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq345[0] {
					if x.Active == nil {
						r.EncodeNil()
					} else {
						yym347 := z.EncBinary()
						_ = yym347
						if false {
						} else {
							h.encSlicev1_ObjectReference(([]pkg2_v1.ObjectReference)(x.Active), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq345[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Active == nil {
						r.EncodeNil()
					} else {
						yym348 := z.EncBinary()
						_ = yym348
						if false {
						} else {
							h.encSlicev1_ObjectReference(([]pkg2_v1.ObjectReference)(x.Active), e)
						}
					}
				}
			}
			if yyr345 || yy2arr345 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq345[1] {
					if x.LastScheduleTime == nil {
						r.EncodeNil()
					} else {
						yym350 := z.EncBinary()
						_ = yym350
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScheduleTime) {
						} else if yym350 {
							z.EncBinaryMarshal(x.LastScheduleTime)
						} else if !yym350 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScheduleTime)
						} else {
							z.EncFallback(x.LastScheduleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq345[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScheduleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScheduleTime == nil {
						r.EncodeNil()
					} else {
						yym351 := z.EncBinary()
						_ = yym351
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScheduleTime) {
						} else if yym351 {
							z.EncBinaryMarshal(x.LastScheduleTime)
						} else if !yym351 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScheduleTime)
						} else {
							z.EncFallback(x.LastScheduleTime)
						}
					}
				}
			}
			if yyr345 || yy2arr345 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScheduledJobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym352 := z.DecBinary()
	_ = yym352
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct353 := r.ContainerType()
		if yyct353 == codecSelferValueTypeMap1234 {
			yyl353 := r.ReadMapStart()
			if yyl353 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl353, d)
			}
		} else if yyct353 == codecSelferValueTypeArray1234 {
			yyl353 := r.ReadArrayStart()
			if yyl353 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl353, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScheduledJobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys354Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys354Slc
	var yyhl354 bool = l >= 0
	for yyj354 := 0; ; yyj354++ {
		if yyhl354 {
			if yyj354 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys354Slc = r.DecodeBytes(yys354Slc, true, true)
		yys354 := string(yys354Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys354 {
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = nil
			} else {
				yyv355 := &x.Active
				yym356 := z.DecBinary()
				_ = yym356
				if false {
				} else {
					h.decSlicev1_ObjectReference((*[]pkg2_v1.ObjectReference)(yyv355), d)
				}
			}
		case "lastScheduleTime":
			if r.TryDecodeAsNil() {
				if x.LastScheduleTime != nil {
					x.LastScheduleTime = nil
				}
			} else {
				if x.LastScheduleTime == nil {
					x.LastScheduleTime = new(pkg1_unversioned.Time)
				}
				yym358 := z.DecBinary()
				_ = yym358
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScheduleTime) {
				} else if yym358 {
					z.DecBinaryUnmarshal(x.LastScheduleTime)
				} else if !yym358 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScheduleTime)
				} else {
					z.DecFallback(x.LastScheduleTime, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys354)
		} // end switch yys354
	} // end for yyj354
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScheduledJobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj359 int
	var yyb359 bool
	var yyhl359 bool = l >= 0
	yyj359++
	if yyhl359 {
		yyb359 = yyj359 > l
	} else {
		yyb359 = r.CheckBreak()
	}
	if yyb359 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = nil
	} else {
		yyv360 := &x.Active
		yym361 := z.DecBinary()
		_ = yym361
		if false {
		} else {
			h.decSlicev1_ObjectReference((*[]pkg2_v1.ObjectReference)(yyv360), d)
		}
	}
	yyj359++
	if yyhl359 {
		yyb359 = yyj359 > l
	} else {
		yyb359 = r.CheckBreak()
	}
	if yyb359 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScheduleTime != nil {
			x.LastScheduleTime = nil
		}
	} else {
		if x.LastScheduleTime == nil {
			x.LastScheduleTime = new(pkg1_unversioned.Time)
		}
		yym363 := z.DecBinary()
		_ = yym363
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScheduleTime) {
		} else if yym363 {
			z.DecBinaryUnmarshal(x.LastScheduleTime)
		} else if !yym363 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScheduleTime)
		} else {
			z.DecFallback(x.LastScheduleTime, false)
		}
	}
	for {
		yyj359++
		if yyhl359 {
			yyb359 = yyj359 > l
		} else {
			yyb359 = r.CheckBreak()
		}
		if yyb359 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj359-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym364 := z.EncBinary()
		_ = yym364
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep365 := !z.EncBinary()
			yy2arr365 := z.EncBasicHandle().StructToArray
			var yyq365 [2]bool
			_, _, _ = yysep365, yyq365, yy2arr365
			const yyr365 bool = false
			yyq365[0] = len(x.MatchLabels) != 0
			yyq365[1] = len(x.MatchExpressions) != 0
			var yynn365 int
			if yyr365 || yy2arr365 {
				r.EncodeArrayStart(2)
			} else {
				yynn365 = 0
				for _, b := range yyq365 {
					if b {
						yynn365++
					}
				}
				r.EncodeMapStart(yynn365)
				yynn365 = 0
			}
			if yyr365 || yy2arr365 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq365[0] {
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym367 := z.EncBinary()
						_ = yym367
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq365[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchLabels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym368 := z.EncBinary()
						_ = yym368
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				}
			}
			if yyr365 || yy2arr365 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq365[1] {
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym370 := z.EncBinary()
						_ = yym370
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq365[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym371 := z.EncBinary()
						_ = yym371
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				}
			}
			if yyr365 || yy2arr365 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym372 := z.DecBinary()
	_ = yym372
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct373 := r.ContainerType()
		if yyct373 == codecSelferValueTypeMap1234 {
			yyl373 := r.ReadMapStart()
			if yyl373 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl373, d)
			}
		} else if yyct373 == codecSelferValueTypeArray1234 {
			yyl373 := r.ReadArrayStart()
			if yyl373 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl373, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys374Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys374Slc
	var yyhl374 bool = l >= 0
	for yyj374 := 0; ; yyj374++ {
		if yyhl374 {
			if yyj374 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys374Slc = r.DecodeBytes(yys374Slc, true, true)
		yys374 := string(yys374Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys374 {
		case "matchLabels":
			if r.TryDecodeAsNil() {
				x.MatchLabels = nil
			} else {
				yyv375 := &x.MatchLabels
				yym376 := z.DecBinary()
				_ = yym376
				if false {
				} else {
					z.F.DecMapStringStringX(yyv375, false, d)
				}
			}
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv377 := &x.MatchExpressions
				yym378 := z.DecBinary()
				_ = yym378
				if false {
				} else {
					h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv377), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys374)
		} // end switch yys374
	} // end for yyj374
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj379 int
	var yyb379 bool
	var yyhl379 bool = l >= 0
	yyj379++
	if yyhl379 {
		yyb379 = yyj379 > l
	} else {
		yyb379 = r.CheckBreak()
	}
	if yyb379 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchLabels = nil
	} else {
		yyv380 := &x.MatchLabels
		yym381 := z.DecBinary()
		_ = yym381
		if false {
		} else {
			z.F.DecMapStringStringX(yyv380, false, d)
		}
	}
	yyj379++
	if yyhl379 {
		yyb379 = yyj379 > l
	} else {
		yyb379 = r.CheckBreak()
	}
	if yyb379 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv382 := &x.MatchExpressions
		yym383 := z.DecBinary()
		_ = yym383
		if false {
		} else {
			h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv382), d)
		}
	}
	for {
		yyj379++
		if yyhl379 {
			yyb379 = yyj379 > l
		} else {
			yyb379 = r.CheckBreak()
		}
		if yyb379 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj379-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym384 := z.EncBinary()
		_ = yym384
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep385 := !z.EncBinary()
			yy2arr385 := z.EncBasicHandle().StructToArray
			var yyq385 [3]bool
			_, _, _ = yysep385, yyq385, yy2arr385
			const yyr385 bool = false
			yyq385[2] = len(x.Values) != 0
			var yynn385 int
			if yyr385 || yy2arr385 {
				r.EncodeArrayStart(3)
			} else {
				yynn385 = 2
				for _, b := range yyq385 {
					if b {
						yynn385++
					}
				}
				r.EncodeMapStart(yynn385)
				yynn385 = 0
			}
			if yyr385 || yy2arr385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym387 := z.EncBinary()
				_ = yym387
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym388 := z.EncBinary()
				_ = yym388
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr385 || yy2arr385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr385 || yy2arr385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq385[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym391 := z.EncBinary()
						_ = yym391
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq385[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym392 := z.EncBinary()
						_ = yym392
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr385 || yy2arr385 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym393 := z.DecBinary()
	_ = yym393
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct394 := r.ContainerType()
		if yyct394 == codecSelferValueTypeMap1234 {
			yyl394 := r.ReadMapStart()
			if yyl394 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl394, d)
			}
		} else if yyct394 == codecSelferValueTypeArray1234 {
			yyl394 := r.ReadArrayStart()
			if yyl394 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl394, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys395Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys395Slc
	var yyhl395 bool = l >= 0
	for yyj395 := 0; ; yyj395++ {
		if yyhl395 {
			if yyj395 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys395Slc = r.DecodeBytes(yys395Slc, true, true)
		yys395 := string(yys395Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys395 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = LabelSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv398 := &x.Values
				yym399 := z.DecBinary()
				_ = yym399
				if false {
				} else {
					z.F.DecSliceStringX(yyv398, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys395)
		} // end switch yys395
	} // end for yyj395
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj400 int
	var yyb400 bool
	var yyhl400 bool = l >= 0
	yyj400++
	if yyhl400 {
		yyb400 = yyj400 > l
	} else {
		yyb400 = r.CheckBreak()
	}
	if yyb400 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj400++
	if yyhl400 {
		yyb400 = yyj400 > l
	} else {
		yyb400 = r.CheckBreak()
	}
	if yyb400 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = LabelSelectorOperator(r.DecodeString())
	}
	yyj400++
	if yyhl400 {
		yyb400 = yyj400 > l
	} else {
		yyb400 = r.CheckBreak()
	}
	if yyb400 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv403 := &x.Values
		yym404 := z.DecBinary()
		_ = yym404
		if false {
		} else {
			z.F.DecSliceStringX(yyv403, false, d)
		}
	}
	for {
		yyj400++
		if yyhl400 {
			yyb400 = yyj400 > l
		} else {
			yyb400 = r.CheckBreak()
		}
		if yyb400 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj400-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LabelSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym405 := z.EncBinary()
	_ = yym405
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LabelSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym406 := z.DecBinary()
	_ = yym406
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv407 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy408 := &yyv407
		yy408.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv409 := *v
	yyh409, yyl409 := z.DecSliceHelperStart()
	var yyc409 bool
	if yyl409 == 0 {
		if yyv409 == nil {
			yyv409 = []Job{}
			yyc409 = true
		} else if len(yyv409) != 0 {
			yyv409 = yyv409[:0]
			yyc409 = true
		}
	} else if yyl409 > 0 {
		var yyrr409, yyrl409 int
		var yyrt409 bool
		if yyl409 > cap(yyv409) {

			yyrg409 := len(yyv409) > 0
			yyv2409 := yyv409
			yyrl409, yyrt409 = z.DecInferLen(yyl409, z.DecBasicHandle().MaxInitLen, 824)
			if yyrt409 {
				if yyrl409 <= cap(yyv409) {
					yyv409 = yyv409[:yyrl409]
				} else {
					yyv409 = make([]Job, yyrl409)
				}
			} else {
				yyv409 = make([]Job, yyrl409)
			}
			yyc409 = true
			yyrr409 = len(yyv409)
			if yyrg409 {
				copy(yyv409, yyv2409)
			}
		} else if yyl409 != len(yyv409) {
			yyv409 = yyv409[:yyl409]
			yyc409 = true
		}
		yyj409 := 0
		for ; yyj409 < yyrr409; yyj409++ {
			yyh409.ElemContainerState(yyj409)
			if r.TryDecodeAsNil() {
				yyv409[yyj409] = Job{}
			} else {
				yyv410 := &yyv409[yyj409]
				yyv410.CodecDecodeSelf(d)
			}

		}
		if yyrt409 {
			for ; yyj409 < yyl409; yyj409++ {
				yyv409 = append(yyv409, Job{})
				yyh409.ElemContainerState(yyj409)
				if r.TryDecodeAsNil() {
					yyv409[yyj409] = Job{}
				} else {
					yyv411 := &yyv409[yyj409]
					yyv411.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj409 := 0
		for ; !r.CheckBreak(); yyj409++ {

			if yyj409 >= len(yyv409) {
				yyv409 = append(yyv409, Job{}) // var yyz409 Job
				yyc409 = true
			}
			yyh409.ElemContainerState(yyj409)
			if yyj409 < len(yyv409) {
				if r.TryDecodeAsNil() {
					yyv409[yyj409] = Job{}
				} else {
					yyv412 := &yyv409[yyj409]
					yyv412.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj409 < len(yyv409) {
			yyv409 = yyv409[:yyj409]
			yyc409 = true
		} else if yyj409 == 0 && yyv409 == nil {
			yyv409 = []Job{}
			yyc409 = true
		}
	}
	yyh409.End()
	if yyc409 {
		*v = yyv409
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv413 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy414 := &yyv413
		yy414.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv415 := *v
	yyh415, yyl415 := z.DecSliceHelperStart()
	var yyc415 bool
	if yyl415 == 0 {
		if yyv415 == nil {
			yyv415 = []JobCondition{}
			yyc415 = true
		} else if len(yyv415) != 0 {
			yyv415 = yyv415[:0]
			yyc415 = true
		}
	} else if yyl415 > 0 {
		var yyrr415, yyrl415 int
		var yyrt415 bool
		if yyl415 > cap(yyv415) {

			yyrg415 := len(yyv415) > 0
			yyv2415 := yyv415
			yyrl415, yyrt415 = z.DecInferLen(yyl415, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt415 {
				if yyrl415 <= cap(yyv415) {
					yyv415 = yyv415[:yyrl415]
				} else {
					yyv415 = make([]JobCondition, yyrl415)
				}
			} else {
				yyv415 = make([]JobCondition, yyrl415)
			}
			yyc415 = true
			yyrr415 = len(yyv415)
			if yyrg415 {
				copy(yyv415, yyv2415)
			}
		} else if yyl415 != len(yyv415) {
			yyv415 = yyv415[:yyl415]
			yyc415 = true
		}
		yyj415 := 0
		for ; yyj415 < yyrr415; yyj415++ {
			yyh415.ElemContainerState(yyj415)
			if r.TryDecodeAsNil() {
				yyv415[yyj415] = JobCondition{}
			} else {
				yyv416 := &yyv415[yyj415]
				yyv416.CodecDecodeSelf(d)
			}

		}
		if yyrt415 {
			for ; yyj415 < yyl415; yyj415++ {
				yyv415 = append(yyv415, JobCondition{})
				yyh415.ElemContainerState(yyj415)
				if r.TryDecodeAsNil() {
					yyv415[yyj415] = JobCondition{}
				} else {
					yyv417 := &yyv415[yyj415]
					yyv417.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj415 := 0
		for ; !r.CheckBreak(); yyj415++ {

			if yyj415 >= len(yyv415) {
				yyv415 = append(yyv415, JobCondition{}) // var yyz415 JobCondition
				yyc415 = true
			}
			yyh415.ElemContainerState(yyj415)
			if yyj415 < len(yyv415) {
				if r.TryDecodeAsNil() {
					yyv415[yyj415] = JobCondition{}
				} else {
					yyv418 := &yyv415[yyj415]
					yyv418.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj415 < len(yyv415) {
			yyv415 = yyv415[:yyj415]
			yyc415 = true
		} else if yyj415 == 0 && yyv415 == nil {
			yyv415 = []JobCondition{}
			yyc415 = true
		}
	}
	yyh415.End()
	if yyc415 {
		*v = yyv415
	}
}

func (x codecSelfer1234) encSliceScheduledJob(v []ScheduledJob, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv419 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy420 := &yyv419
		yy420.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceScheduledJob(v *[]ScheduledJob, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv421 := *v
	yyh421, yyl421 := z.DecSliceHelperStart()
	var yyc421 bool
	if yyl421 == 0 {
		if yyv421 == nil {
			yyv421 = []ScheduledJob{}
			yyc421 = true
		} else if len(yyv421) != 0 {
			yyv421 = yyv421[:0]
			yyc421 = true
		}
	} else if yyl421 > 0 {
		var yyrr421, yyrl421 int
		var yyrt421 bool
		if yyl421 > cap(yyv421) {

			yyrg421 := len(yyv421) > 0
			yyv2421 := yyv421
			yyrl421, yyrt421 = z.DecInferLen(yyl421, z.DecBasicHandle().MaxInitLen, 1072)
			if yyrt421 {
				if yyrl421 <= cap(yyv421) {
					yyv421 = yyv421[:yyrl421]
				} else {
					yyv421 = make([]ScheduledJob, yyrl421)
				}
			} else {
				yyv421 = make([]ScheduledJob, yyrl421)
			}
			yyc421 = true
			yyrr421 = len(yyv421)
			if yyrg421 {
				copy(yyv421, yyv2421)
			}
		} else if yyl421 != len(yyv421) {
			yyv421 = yyv421[:yyl421]
			yyc421 = true
		}
		yyj421 := 0
		for ; yyj421 < yyrr421; yyj421++ {
			yyh421.ElemContainerState(yyj421)
			if r.TryDecodeAsNil() {
				yyv421[yyj421] = ScheduledJob{}
			} else {
				yyv422 := &yyv421[yyj421]
				yyv422.CodecDecodeSelf(d)
			}

		}
		if yyrt421 {
			for ; yyj421 < yyl421; yyj421++ {
				yyv421 = append(yyv421, ScheduledJob{})
				yyh421.ElemContainerState(yyj421)
				if r.TryDecodeAsNil() {
					yyv421[yyj421] = ScheduledJob{}
				} else {
					yyv423 := &yyv421[yyj421]
					yyv423.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj421 := 0
		for ; !r.CheckBreak(); yyj421++ {

			if yyj421 >= len(yyv421) {
				yyv421 = append(yyv421, ScheduledJob{}) // var yyz421 ScheduledJob
				yyc421 = true
			}
			yyh421.ElemContainerState(yyj421)
			if yyj421 < len(yyv421) {
				if r.TryDecodeAsNil() {
					yyv421[yyj421] = ScheduledJob{}
				} else {
					yyv424 := &yyv421[yyj421]
					yyv424.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj421 < len(yyv421) {
			yyv421 = yyv421[:yyj421]
			yyc421 = true
		} else if yyj421 == 0 && yyv421 == nil {
			yyv421 = []ScheduledJob{}
			yyc421 = true
		}
	}
	yyh421.End()
	if yyc421 {
		*v = yyv421
	}
}

func (x codecSelfer1234) encSlicev1_ObjectReference(v []pkg2_v1.ObjectReference, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv425 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy426 := &yyv425
		yy426.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicev1_ObjectReference(v *[]pkg2_v1.ObjectReference, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv427 := *v
	yyh427, yyl427 := z.DecSliceHelperStart()
	var yyc427 bool
	if yyl427 == 0 {
		if yyv427 == nil {
			yyv427 = []pkg2_v1.ObjectReference{}
			yyc427 = true
		} else if len(yyv427) != 0 {
			yyv427 = yyv427[:0]
			yyc427 = true
		}
	} else if yyl427 > 0 {
		var yyrr427, yyrl427 int
		var yyrt427 bool
		if yyl427 > cap(yyv427) {

			yyrg427 := len(yyv427) > 0
			yyv2427 := yyv427
			yyrl427, yyrt427 = z.DecInferLen(yyl427, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt427 {
				if yyrl427 <= cap(yyv427) {
					yyv427 = yyv427[:yyrl427]
				} else {
					yyv427 = make([]pkg2_v1.ObjectReference, yyrl427)
				}
			} else {
				yyv427 = make([]pkg2_v1.ObjectReference, yyrl427)
			}
			yyc427 = true
			yyrr427 = len(yyv427)
			if yyrg427 {
				copy(yyv427, yyv2427)
			}
		} else if yyl427 != len(yyv427) {
			yyv427 = yyv427[:yyl427]
			yyc427 = true
		}
		yyj427 := 0
		for ; yyj427 < yyrr427; yyj427++ {
			yyh427.ElemContainerState(yyj427)
			if r.TryDecodeAsNil() {
				yyv427[yyj427] = pkg2_v1.ObjectReference{}
			} else {
				yyv428 := &yyv427[yyj427]
				yyv428.CodecDecodeSelf(d)
			}

		}
		if yyrt427 {
			for ; yyj427 < yyl427; yyj427++ {
				yyv427 = append(yyv427, pkg2_v1.ObjectReference{})
				yyh427.ElemContainerState(yyj427)
				if r.TryDecodeAsNil() {
					yyv427[yyj427] = pkg2_v1.ObjectReference{}
				} else {
					yyv429 := &yyv427[yyj427]
					yyv429.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj427 := 0
		for ; !r.CheckBreak(); yyj427++ {

			if yyj427 >= len(yyv427) {
				yyv427 = append(yyv427, pkg2_v1.ObjectReference{}) // var yyz427 pkg2_v1.ObjectReference
				yyc427 = true
			}
			yyh427.ElemContainerState(yyj427)
			if yyj427 < len(yyv427) {
				if r.TryDecodeAsNil() {
					yyv427[yyj427] = pkg2_v1.ObjectReference{}
				} else {
					yyv430 := &yyv427[yyj427]
					yyv430.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj427 < len(yyv427) {
			yyv427 = yyv427[:yyj427]
			yyc427 = true
		} else if yyj427 == 0 && yyv427 == nil {
			yyv427 = []pkg2_v1.ObjectReference{}
			yyc427 = true
		}
	}
	yyh427.End()
	if yyc427 {
		*v = yyv427
	}
}

func (x codecSelfer1234) encSliceLabelSelectorRequirement(v []LabelSelectorRequirement, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv431 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy432 := &yyv431
		yy432.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceLabelSelectorRequirement(v *[]LabelSelectorRequirement, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv433 := *v
	yyh433, yyl433 := z.DecSliceHelperStart()
	var yyc433 bool
	if yyl433 == 0 {
		if yyv433 == nil {
			yyv433 = []LabelSelectorRequirement{}
			yyc433 = true
		} else if len(yyv433) != 0 {
			yyv433 = yyv433[:0]
			yyc433 = true
		}
	} else if yyl433 > 0 {
		var yyrr433, yyrl433 int
		var yyrt433 bool
		if yyl433 > cap(yyv433) {

			yyrg433 := len(yyv433) > 0
			yyv2433 := yyv433
			yyrl433, yyrt433 = z.DecInferLen(yyl433, z.DecBasicHandle().MaxInitLen, 56)
			if yyrt433 {
				if yyrl433 <= cap(yyv433) {
					yyv433 = yyv433[:yyrl433]
				} else {
					yyv433 = make([]LabelSelectorRequirement, yyrl433)
				}
			} else {
				yyv433 = make([]LabelSelectorRequirement, yyrl433)
			}
			yyc433 = true
			yyrr433 = len(yyv433)
			if yyrg433 {
				copy(yyv433, yyv2433)
			}
		} else if yyl433 != len(yyv433) {
			yyv433 = yyv433[:yyl433]
			yyc433 = true
		}
		yyj433 := 0
		for ; yyj433 < yyrr433; yyj433++ {
			yyh433.ElemContainerState(yyj433)
			if r.TryDecodeAsNil() {
				yyv433[yyj433] = LabelSelectorRequirement{}
			} else {
				yyv434 := &yyv433[yyj433]
				yyv434.CodecDecodeSelf(d)
			}

		}
		if yyrt433 {
			for ; yyj433 < yyl433; yyj433++ {
				yyv433 = append(yyv433, LabelSelectorRequirement{})
				yyh433.ElemContainerState(yyj433)
				if r.TryDecodeAsNil() {
					yyv433[yyj433] = LabelSelectorRequirement{}
				} else {
					yyv435 := &yyv433[yyj433]
					yyv435.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj433 := 0
		for ; !r.CheckBreak(); yyj433++ {

			if yyj433 >= len(yyv433) {
				yyv433 = append(yyv433, LabelSelectorRequirement{}) // var yyz433 LabelSelectorRequirement
				yyc433 = true
			}
			yyh433.ElemContainerState(yyj433)
			if yyj433 < len(yyv433) {
				if r.TryDecodeAsNil() {
					yyv433[yyj433] = LabelSelectorRequirement{}
				} else {
					yyv436 := &yyv433[yyj433]
					yyv436.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj433 < len(yyv433) {
			yyv433 = yyv433[:yyj433]
			yyc433 = true
		} else if yyj433 == 0 && yyv433 == nil {
			yyv433 = []LabelSelectorRequirement{}
			yyc433 = true
		}
	}
	yyh433.End()
	if yyc433 {
		*v = yyv433
	}
}
