## Contributing to Caddy

Welcome! Our community focuses on helping others and making Caddy the best it
can be. We gladly accept contributions and encourage you to get involved!


### Join us in the forum

The [Caddy forum](https://forum.caddyserver.com) is the place for all discussion
that doesn't belong in issues or pull requests. Feel free to participate with us!

If you want to file a bug report or make an improvement to Caddy, however, you
should submit an issue or pull request.


### Bug reports

Please [search this repository](https://github.com/mholt/caddy/search?q=&type=Issues&utf8=%E2%9C%93)
with a variety of keywords to ensure your bug is not already reported.

If unique, [open an issue](https://github.com/mholt/caddy/issues) and answer the
questions so we can understand and reproduce the problematic behavior.

The burden is on you to convince us that it is actually a bug in Caddy. This is
easiest to do when you write clear, concise instructions so we can reproduce
the behavior (even if it seems obvious). The more detailed and specific you are,
the faster we will be able to help you. Check out
[How to Report Bugs Effectively](http://www.chiark.greenend.org.uk/~sgtatham/bugs.html).

Please be kind. :smile: Remember that Caddy comes at no cost to you, and you're
getting free help. If we helped you, please consider
[donating](https://caddyserver.com/donate) - it keeps us motivated!


### Minor improvements and new tests

Submit [pull requests](https://github.com/mholt/caddy/pulls) at any time for
minor changes or new tests. Make sure to write tests to assert your change is
working properly and is thoroughly covered. We'll ask most pull requests to be
[squashed](http://gitready.com/advanced/2009/02/10/squashing-commits-with-rebase.html),
especially with small commits.

Your pull request may be thoroughly reviewed. This is because if we accept the
PR, we also assume responsibility for it, although we would prefer you to
help maintain your code after it gets merged. 


### Proposals, suggestions, ideas, new features

First, please [search](https://github.com/mholt/caddy/search?q=&type=Issues&utf8=%E2%9C%93)
with a variety of keywords to ensure your suggestion/proposal is new.

If so, you may open either an issue or a pull request for discussion and
feedback.

The advantage of issues is that you don't have to spend time implementing your
idea, but you should still describe it thoroughly as if someone reading it would
implement the whole thing starting from scratch.

The advantage of pull requests is that we can immediately see the impact the
change will have on the project, what the code will look like, and how to
improve it. The disadvantage of pull requests is that they are unlikely to get
accepted without significant changes first, or it may be rejected entirely.
Don't worry, that won't happen without an open discussion first.

If you are going to spend significant time writing code for a new pull request,
best to open an issue to "claim" it and get feedback before you invest a lot of
time. Not all pull requests are merged, and that's okay,
[Read why.](https://github.com/turbolinks/turbolinks/pull/124#issuecomment-239826060)

Remember: pull requests should always be thoroughly documented both via godoc
and with at least a rough draft of documentation that might go on the website
for users to read.


### Collaborator status

If your pull request is merged, congratulations! You're technically a
collaborator. We may also grant you "Collaborator status" which means you can
push to the repository and merge other pull requests. We hope that you will
stay involved by reviewing pull requests, submitting more of your own, and
resolving issues as you are able to. Thanks for making Caddy amazing!

We ask that collaborators will conduct thorough code reviews and be nice to
new contributors. Before merging a PR, it's best to get the approval of
at least one or two other collaborators and/or the project owner. We prefer
squashed commits instead of many little, semantically-unimportant commits. Also,
CI and other post-commit hooks must pass before being merged except in certain
unusual circumstances.

Collaborator status may be removed for inactive users from time to time as
we see fit; this is not an insult, just a basic security precaution in case
the account becomes inactive or abandoned. Privileges can always be restored
later.

**Reviewing pull requests:** Please help submit and review pull requests as
you are able! We would ask that every pull request be reviewed by at least
one collaborator who did not open the pull request before merging. This will
help ensure high code quality as new collaborators are added to the project.

Read [CodeReviewComments](https://github.com/golang/go/wiki/CodeReviewComments)
on the Go wiki for an idea of what we look for in good, clean Go code, and
check out [what Linus suggests](https://gist.github.com/matthewhudson/1475276)
for good commit messages.



### Vulnerabilities

If you've found a vulnerability that is serious, please email me: Matthew dot 
Holt at Gmail. If it's not a big deal, a pull request will probably be faster.


## Thank you

Thanks for your help! Caddy would not be what it is today without your
contributions.
