﻿using YGOSharp.OCGWrapper.Enums;
using System.Collections.Generic;
using System.Linq;
using WindBot;
using WindBot.Game;
using WindBot.Game.AI;
using System;

namespace WindBot.Game.AI.Decks
{
    [Deck("MokeyMokey", "AI_MokeyMokey")]
    public class MokeyMokeyExecutor : DefaultExecutor
    {
        public class CardId
        {
            public const int 青眼白龙 = 120120000;
            public const int 破坏之剑士 = 120170000;
            public const int 黑魔术师 = 120130000;
            public const int 真红眼黑龙 = 120125001;
            public const int 恶魔召唤 = 120145000;
            public const int 人造人 = 120155000;
            public const int 连击龙 = 120110001;
            public const int 七星道魔术师 = 120105001;
            public const int 雅灭鲁拉 = 120120029;
            public const int 耳语妖精 = 120120018;
            public const int 神秘庄家 = 120105006;
            public const int 光芒巫师 = 120145001;
            public const int 暗黑巫师 = 120105005;
            public const int 火星心少女 = 120145014;
            public const int 斗牛士 = 120170035;
            public const int 凤凰龙 = 120110009;
            public const int 七星道法师 = 120130016;
            public const int sionmax = 120150007;
            public const int 对死者的供奉 = 120151023;
            public const int 落穴 = 120150019;
            public const int 暗黑释放 = 120105013;
        }

        public MokeyMokeyExecutor(GameAI ai, Duel duel)
            : base(ai, duel)
        {
            AddExecutor(ExecutorType.SpSummon);
            AddExecutor(ExecutorType.Repos, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Activate, CardId.七星道法师,七星道法师Effect);
            AddExecutor(ExecutorType.Activate, CardId.对死者的供奉, 死供Eff);
            AddExecutor(ExecutorType.SummonOrSet, CardId.青眼白龙, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.破坏之剑士, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.恶魔召唤, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.连击龙, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.雅灭鲁拉, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.黑魔术师, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.真红眼黑龙, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.七星道魔术师, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.人造人, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.神秘庄家);
            AddExecutor(ExecutorType.Activate, CardId.神秘庄家, draweffect);
            AddExecutor(ExecutorType.SpellSet, CardId.暗黑释放, 圣防Effect);
            AddExecutor(ExecutorType.SpellSet, CardId.落穴);
            AddExecutor(ExecutorType.Activate, CardId.落穴, 落穴Effect);
            AddExecutor(ExecutorType.Activate, CardId.对死者的供奉, 死供Effect);
            AddExecutor(ExecutorType.SpellSet, CardId.对死者的供奉);
            AddExecutor(ExecutorType.Activate, CardId.凤凰龙);
            AddExecutor(ExecutorType.Summon, CardId.凤凰龙, 凤凰龙summon);
            AddExecutor(ExecutorType.MonsterSet, CardId.凤凰龙);
            AddExecutor(ExecutorType.MonsterSet, CardId.火星心少女, Monsterset);
            AddExecutor(ExecutorType.MonsterSet, CardId.七星道法师, Monsterset);
            AddExecutor(ExecutorType.MonsterSet, CardId.耳语妖精, Monsterset);
            AddExecutor(ExecutorType.Summon, CardId.七星道法师);
            
            
            AddExecutor(ExecutorType.SummonOrSet, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Repos, CardId.青眼白龙, 圣防Repos);
            AddExecutor(ExecutorType.Repos, CardId.破坏之剑士, 圣防Repos);
            AddExecutor(ExecutorType.SpellSet);
            //AddExecutor(ExecutorType.Activate, CardId.sionmax, sionmaxEffect);
            AddExecutor(ExecutorType.Activate, CardId.耳语妖精, 耳语妖精Effect);
            AddExecutor(ExecutorType.Activate, CardId.火星心少女, 火星心少女Effect);
            AddExecutor(ExecutorType.Activate, CardId.连击龙);
            AddExecutor(ExecutorType.Activate, CardId.七星道魔术师);
            //AddExecutor(ExecutorType.Activate, CardId.斗牛士, 斗牛士Effect);
            
            AddExecutor(ExecutorType.Activate, DefaultDontChainMyself);

        }



        private List<int> HintMsgForEnemy = new List<int>
        {
            HintMsg.Release, HintMsg.Destroy, HintMsg.Remove, HintMsg.ToGrave, HintMsg.ReturnToHand, HintMsg.ToDeck,
            HintMsg.FusionMaterial, HintMsg.SynchroMaterial, HintMsg.XyzMaterial, HintMsg.LinkMaterial, HintMsg.Disable
        };
        private List<int> HintMsgForMaxSelect = new List<int>
        {
            HintMsg.SpSummon, HintMsg.ToGrave, HintMsg.AddToHand, HintMsg.ToDeck, HintMsg.Destroy
        };

        public override IList<ClientCard> OnSelectCard(IList<ClientCard> _cards, int min, int max, int hint, bool cancelable)
        {
            if (Duel.Phase == DuelPhase.BattleStart)
                return null;
            if (AI.HaveSelectedCards())
                return null;

            IList<ClientCard> selected = new List<ClientCard>();
            IList<ClientCard> cards = new List<ClientCard>(_cards);
            if (max > cards.Count)
                max = cards.Count;

            if (HintMsgForEnemy.Contains(hint))
            {
                IList<ClientCard> enemyCards = cards.Where(card => card.Controller == 1).ToList();

                // select enemy's card first
                while (enemyCards.Count > 0 && selected.Count < max)
                {
                    ClientCard card = enemyCards[Program.Rand.Next(enemyCards.Count)];
                    selected.Add(card);
                    enemyCards.Remove(card);
                    cards.Remove(card);
                }
            }

            if (HintMsgForMaxSelect.Contains(hint))
            {
                // select max cards
                while (selected.Count < max)
                {
                    ClientCard card = cards[Program.Rand.Next(cards.Count)];
                    selected.Add(card);
                    cards.Remove(card);
                }
            }

            return selected;
        }
        public override bool OnSelectHand()
        {
            // go first
            return true;
        }
        public bool Monsterset()
        {
            if (Duel.Turn == 1)
            {
                return true;
            }
            else if (Bot.HasInHandOrHasInMonstersZone(new[] {
                CardId.七星道魔术师,
                CardId.连击龙,
                CardId.青眼白龙,
                CardId.人造人,
                CardId.恶魔召唤,
                CardId.雅灭鲁拉,
                CardId.破坏之剑士,
                CardId.真红眼黑龙,
                CardId.黑魔术师
                }))
                return false;
            return true;
        }
        private bool 耳语妖精Effect()
        {

            IList<ClientCard> targets = new List<ClientCard>();
            foreach (ClientCard card in Enemy.GetGraveyardMonsters())
            {
                if (card.Level <= 4)
                    targets.Add(card);
            }
            return true;

        }
        private bool 圣防Effect()
        {
            if (Util.GetTotalAttackingMonsterAttack(1) > 1900)
                return true;
            return false;
        }
        private bool 落穴Effect()
        {           
                foreach (ClientCard n in Duel.LastSummonedCards)
                {
                    if (n.Attack >= 1900)
                        return true;
                }
            
            return false;
        }
        private bool 火星心少女Effect()
        {
            foreach (ClientCard m in Bot.Hand)
                AI.SelectCard(m);
            AI.SelectNextCard(Enemy.GetMonsters().GetHighestAttackMonster());
            AI.SelectYesNo(true);
            return true;
        }
        private bool 死供Effect()
        {
            if (Util.IsOneEnemyBetterThanValue(1900, false))
            {
                foreach (ClientCard m in Bot.Hand)
                    AI.SelectCard(m);
                foreach (ClientCard mon in Enemy.GetMonsters())
                    if (mon.Level >= 9)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 8)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 7)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 5)
                        AI.SelectNextCard(mon);
                return true;
            }
            return false;
        }
        private bool 死供Eff()
        {
            if (Util.IsOneEnemyBetterThanValue(2600, false))
            {
                foreach (ClientCard m in Bot.Hand)
                    AI.SelectCard(m);
                foreach (ClientCard mon in Enemy.GetMonsters())
                    if (mon.Level >= 8)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 7)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 5)
                        AI.SelectNextCard(mon);
                return true;
            }
            return false;
        }
        private bool 七星道法师Effect()
        {
            AI.SelectCard(Enemy.GetMonsters().GetHighestAttackMonster());
            return true;
        }
        private bool draweffect()
        {

            if ((Bot.MonsterZone.GetMatchingCardsCount(card => card.Level < 5) + Bot.Hand.GetMatchingCardsCount(card => card.Level < 5)) <= 2)
            {
                if ((Bot.MonsterZone.GetMatchingCardsCount(card => card.Level > 5) > 2) && Bot.HasInHand(CardId.七星道魔术师))
                    AI.SelectCard(CardId.七星道魔术师);
                else
                    return false;
            }
            else
                AI.SelectCard(CardId.七星道法师, CardId.火星心少女, CardId.耳语妖精, CardId.神秘庄家, CardId.光芒巫师, CardId.暗黑巫师);
            return true;
        }
        private bool 凤凰龙summon()
        {
            if (Bot.HasInGraveyard(new[] { CardId.连击龙, CardId.青眼白龙 }))
                return true;
            return false;
        }
        private bool 圣防Repos()
        {
            if (Enemy.Graveyard.GetMatchingCardsCount(card => (card.Race & (int)CardRace.SpellCaster) > 0) >= 4 && Enemy.GetSpellCountWithoutField() >= 1 && !Bot.HasInMonstersZone(CardId.人造人) && Enemy.Graveyard.GetMatchingCardsCount(card => card.IsCode(CardId.暗黑释放)) < 3)
            {
                if (Bot.MonsterZone.GetMatchingCardsCount(card => card.IsAttack() && card.Level >= 5) >= 2 && !Bot.HasDefendingMonster())
                    return true;
            }
            return false;
        }


    }
}





