﻿using YGOSharp.OCGWrapper.Enums;
using System.Collections.Generic;
using System.Linq;
using WindBot;
using WindBot.Game;
using WindBot.Game.AI;
using System;

namespace WindBot.Game.AI.Decks
{
    [Deck("Dragun", "AI_Dragun")]
    public class DragunExecutor : DefaultExecutor
    {
        public class CardId
        {
            public const int 青眼白龙 = 120120000;
            public const int 破坏之剑士 = 120170000;
            public const int 连击龙 = 120110001;
            public const int 人造人 = 120155000;
            public const int 千年盾 = 120194001;
            public const int 血腥魔兽人 = 120194002;
            public const int 圣精灵 = 120194003;

            public const int 成金恐龙王 = 120151010;       
            public const int 机器栗子 = 120120017;
            public const int 斗牛士 = 120170035;
            public const int 凤凰龙 = 120110009;
            public const int 死苏 = 120194004;            
            public const int 成金哥布林 = 120151018;
            public const int 强欲之壶 = 120181003;
            public const int 对死者的供奉 = 120151023;
            public const int 落穴 = 120150019;
            public const int 圣防 = 120198003;
            public const int 炸甲 = 120194005;
            public const int 暗黑释放 = 120105013;
        }

        public DragunExecutor(GameAI ai, Duel duel)
            : base(ai, duel)
        {
            AddExecutor(ExecutorType.SpSummon);
            AddExecutor(ExecutorType.Activate, CardId.强欲之壶);
            AddExecutor(ExecutorType.Activate, CardId.成金哥布林);
            AddExecutor(ExecutorType.Activate, CardId.成金恐龙王, 成金恐龙王Effect);
            AddExecutor(ExecutorType.Activate, CardId.机器栗子);
            AddExecutor(ExecutorType.Activate, CardId.连击龙);
            AddExecutor(ExecutorType.Activate, CardId.斗牛士, 斗牛士Effect);
            AddExecutor(ExecutorType.Repos, CardId.斗牛士, DefaultMonsterRepos);
            AddExecutor(ExecutorType.SummonOrSet, CardId.青眼白龙, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.破坏之剑士, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.连击龙, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.人造人, DefaultMonsterSummon);
            AddExecutor(ExecutorType.MonsterSet, CardId.千年盾, DefaultMonsterSummon);
            AddExecutor(ExecutorType.Summon, CardId.机器栗子, 栗子summon);
            AddExecutor(ExecutorType.Repos, CardId.机器栗子, 栗子summon2);
            //AddExecutor(ExecutorType.Activate, CardId.死苏, 死苏effect);
            AddExecutor(ExecutorType.Activate, CardId.死苏, 死苏effect2);
            AddExecutor(ExecutorType.MonsterSet, CardId.斗牛士, Monsterset);
            AddExecutor(ExecutorType.Summon, CardId.斗牛士);

            AddExecutor(ExecutorType.Activate, CardId.凤凰龙);
            AddExecutor(ExecutorType.Activate, CardId.对死者的供奉, 死供Effect);
            AddExecutor(ExecutorType.Repos, CardId.青眼白龙, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Repos, CardId.破坏之剑士, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Repos, CardId.连击龙, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Repos, CardId.人造人, DefaultMonsterRepos);
            AddExecutor(ExecutorType.Repos, CardId.成金恐龙王, 成金恐龙王Summon);
            AddExecutor(ExecutorType.Summon, CardId.成金恐龙王, 成金恐龙王Summon);
            AddExecutor(ExecutorType.SummonOrSet, CardId.血腥魔兽人);
            AddExecutor(ExecutorType.Summon, CardId.凤凰龙, 凤凰龙summon);
            AddExecutor(ExecutorType.SpellSet, CardId.圣防);
            AddExecutor(ExecutorType.SpellSet, CardId.落穴);
            AddExecutor(ExecutorType.Activate, CardId.落穴, 落穴Effect);
            AddExecutor(ExecutorType.Activate, CardId.圣防, 圣防Effect);
            AddExecutor(ExecutorType.Activate, CardId.炸甲, 炸甲Effect);

            AddExecutor(ExecutorType.SpellSet, CardId.对死者的供奉);
            AddExecutor(ExecutorType.MonsterSet, CardId.圣精灵);
            AddExecutor(ExecutorType.MonsterSet, CardId.凤凰龙);
            AddExecutor(ExecutorType.MonsterSet, CardId.成金恐龙王);
            AddExecutor(ExecutorType.MonsterSet, CardId.机器栗子);
            

            AddExecutor(ExecutorType.Activate, DefaultDontChainMyself);
            AddExecutor(ExecutorType.Repos, CardId.青眼白龙, 圣防Repos);
            AddExecutor(ExecutorType.Repos, CardId.破坏之剑士, 圣防Repos);
            AddExecutor(ExecutorType.SummonOrSet, DefaultMonsterSummon);
            AddExecutor(ExecutorType.SpellSet);
            //AddExecutor(ExecutorType.Activate, CardId.sionmax, sionmaxEffect);



        }



        private List<int> HintMsgForEnemy = new List<int>
        {
            HintMsg.Release, HintMsg.Destroy, HintMsg.Remove, HintMsg.ToGrave, HintMsg.ReturnToHand, HintMsg.ToDeck,
            HintMsg.FusionMaterial, HintMsg.SynchroMaterial, HintMsg.XyzMaterial, HintMsg.LinkMaterial, HintMsg.Disable
        };
        private List<int> HintMsgForMaxSelect = new List<int>
        {
            HintMsg.SpSummon, HintMsg.ToGrave, HintMsg.AddToHand, HintMsg.ToDeck, HintMsg.Destroy
        };

        public override IList<ClientCard> OnSelectCard(IList<ClientCard> _cards, int min, int max, int hint, bool cancelable)
        {
            if (Duel.Phase == DuelPhase.BattleStart)
                return null;
            if (AI.HaveSelectedCards())
                return null;

            IList<ClientCard> selected = new List<ClientCard>();
            IList<ClientCard> cards = new List<ClientCard>(_cards);
            if (max > cards.Count)
                max = cards.Count;

            if (HintMsgForEnemy.Contains(hint))
            {
                IList<ClientCard> enemyCards = cards.Where(card => card.Controller == 1).ToList();

                // select enemy's card first
                while (enemyCards.Count > 0 && selected.Count < max)
                {
                    ClientCard card = enemyCards[Program.Rand.Next(enemyCards.Count)];
                    selected.Add(card);
                    enemyCards.Remove(card);
                    cards.Remove(card);
                }
            }

            if (HintMsgForMaxSelect.Contains(hint))
            {
                // select max cards
                while (selected.Count < max)
                {
                    ClientCard card = cards[Program.Rand.Next(cards.Count)];
                    selected.Add(card);
                    cards.Remove(card);
                }
            }

            return selected;
        }
        public override bool OnSelectHand()
        {
            // go first
            return true;
        }
        public bool Monsterset()
        {
            if (Duel.Turn == 1)
            {
                return true;
            }
            else if (Bot.HasInHand(new[] {

                CardId.连击龙,
                CardId.青眼白龙,
                CardId.人造人,
                CardId.破坏之剑士,

                }))
                return false;
            return true;
        }

        private bool 落穴Effect()
        {
            foreach (ClientCard n in Duel.LastSummonedCards)
            {
                if (n.Attack >= 1900)
                    return true;
            }

            return false;
        }
        private bool 圣防Effect()
        {
            if (Util.GetTotalAttackingMonsterAttack(1) > 1900)
                return true;
            return false;
        }
        private bool 炸甲Effect()
        {
            if (Enemy.BattlingMonster.Attack > 1500) return true;
            if (Bot.LifePoints <= Enemy.BattlingMonster.Attack) return true;
            if (!Util.IsOneEnemyBetterThanValue(1500, true) && Bot.GetSpellCountWithoutField() == 3) return true;
            return false;
        }
        private bool 死苏effect()
        {
            IList<int> targets = new[] {
                    CardId.青眼白龙,
                    CardId.破坏之剑士,
                    CardId.连击龙,
                    CardId.人造人,
                };
            if (!Bot.HasInGraveyard(targets) && !Enemy.HasInGraveyard(targets))
            {
                return false; 
            }
            AI.SelectCard(targets);
            return true;
        }
        private bool 死苏effect2()
        {
            List<ClientCard> cards = new List<ClientCard>(Bot.Graveyard.GetMatchingCards(card => card.IsCanRevive()));
            cards.Sort(CardContainer.CompareCardAttack);
            ClientCard selectedCard = null;
            for (int i = cards.Count - 1; i >= 0; --i)
            {
                ClientCard card = cards[i];
                if (card.Attack < 2000)
                    break;
                if (card.IsMonster())
                {
                    selectedCard = card;
                    break;
                }
            }
            cards = new List<ClientCard>(Enemy.Graveyard.GetMatchingCards(card => card.IsCanRevive()));
            cards.Sort(CardContainer.CompareCardAttack);
            for (int i = cards.Count - 1; i >= 0; --i)
            {
                ClientCard card = cards[i];
                if (card.Attack < 2000)
                    break;
                if (card.IsMonster() && card.HasType(CardType.Normal) && (selectedCard == null || card.Attack > selectedCard.Attack))
                {
                    selectedCard = card;
                    break;
                }
            }
            if (selectedCard != null)
            {
                AI.SelectCard(selectedCard);
                return true;
            }
            return false;
        }
        private bool 成金恐龙王Effect()
        {
            AI.SelectCard(CardId.成金哥布林);
            return true;
        }
        private bool 成金恐龙王Summon()
        {
            if (Enemy.GetHandCount() < 1) return true;
            return false;
        }
        private bool 栗子summon()
        {
            if (Bot.HasInGraveyard(CardId.机器栗子) && Bot.GetMonstersInMainZone().Count == 0)
                return true;
            return false;
        }
        private bool 栗子summon2()
        {
            if (Bot.HasInGraveyard(CardId.机器栗子) && Bot.GetMonstersInMainZone().Count == 1)
                return true;
            return false;
        }
        private bool 凤凰龙summon()
        {
            if (Bot.HasInGraveyard(new[] { CardId.连击龙, CardId.青眼白龙 }))
                return true;
            return false;
        }

        private bool 死供Effect()
        {
            if (Util.IsOneEnemyBetterThanValue(1900, false))
            {
                foreach (ClientCard m in Bot.Hand)
                    AI.SelectCard(m);
                foreach (ClientCard mon in Enemy.GetMonsters())
                    if (mon.Level >= 9)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 8)
                        AI.SelectNextCard(mon);
                    else if (mon.Level >= 7)
                        AI.SelectNextCard(mon);
                return true;
            }
            return false;
        }
        private bool 斗牛士Effect()
        {

            //if (Util.IsOneEnemyBetterThanValue(1900, false))
            {
                foreach (ClientCard o in Bot.Graveyard)
                    AI.SelectCard(o);
                if (Enemy.GetMonsters().GetHighestAttackMonster() == null)
                    AI.SelectNextCard(Enemy.MonsterZone.GetHighestAttackMonster());
                return true;
            }
            // return false;
        }
        private bool 圣防Repos()
        {
            if (Enemy.Graveyard.GetMatchingCardsCount(card => (card.Race & (int)CardRace.SpellCaster) > 0) >= 4 && Enemy.GetSpellCountWithoutField() >= 1 && !Bot.HasInMonstersZone(CardId.人造人) && Enemy.Graveyard.GetMatchingCardsCount(card => card.IsCode(CardId.暗黑释放)) < 3)
            {
                if (Bot.MonsterZone.GetMatchingCardsCount(card => card.IsAttack() && card.Level >= 5) >= 2 && !Bot.HasDefendingMonster())
                    return true;
            }
            return false;
        }
    }
}





