﻿using YGOSharp.OCGWrapper.Enums;
using System.Collections.Generic;
using WindBot;
using WindBot.Game;
using WindBot.Game.AI;

namespace WindBot.Game.AI.Decks
{
    [Deck("Yosenju", "AI_Yosenju")]
    public class YosenjuExecutor : DefaultExecutor
    {
        public class CardId
        {
            public static int YosenjuKama1 = 65247798;
            public static int YosenjuKama2 = 92246806;
            public static int YosenjuKama3 = 28630501;
            public static int YosenjuTsujik = 25244515;

            public static int HarpiesFeatherDuster = 18144507;
            public static int DarkHole = 53129443;
            public static int CardOfDemise = 59750328;
            public static int PotOfDuality = 98645731;
            public static int CosmicCyclone = 8267140;
            public static int QuakingMirrorForce = 40838625;
            public static int DrowningMirrorForce = 47475363;
            public static int StarlightRoad = 58120309;
            public static int VanitysEmptiness = 5851097;
            public static int MacroCosmos = 30241314;
            public static int SolemnStrike = 40605147;
            public static int SolemnWarning = 84749824;
            public static int SolemnJudgment = 41420027;
            public static int MagicDrain = 59344077;

            public static int StardustDragon = 44508094;
            public static int NumberS39UtopiatheLightning = 56832966;
            public static int NumberS39UtopiaOne = 86532744;
            public static int DarkRebellionXyzDragon = 16195942;
            public static int Number39Utopia = 84013237;
            public static int Number103Ragnazero = 94380860;
            public static int BrotherhoodOfTheFireFistTigerKing = 96381979;
            public static int Number106GiantHand = 63746411;
            public static int CastelTheSkyblasterMusketeer = 82633039;
            public static int DiamondDireWolf = 95169481;
            public static int LightningChidori = 22653490;
            public static int EvilswarmExcitonKnight = 46772449;
            public static int AbyssDweller = 21044178;
            public static int GagagaCowboy = 12014404;
        }

        bool CardOfDemiseUsed = false;

        public YosenjuExecutor(GameAI ai, Duel duel)
            : base(ai, duel)
        {
            // do the end phase effect of Card Of Demise before Yosenjus return to hand
            AddExecutor(ExecutorType.Activate, CardId.CardOfDemise, CardOfDemiseEPEffect);

            // burn if enemy's LP is below 800
            AddExecutor(ExecutorType.SpSummon, CardId.GagagaCowboy, GagagaCowboySummon);
            AddExecutor(ExecutorType.Activate, CardId.GagagaCowboy);

            AddExecutor(ExecutorType.Activate, CardId.HarpiesFeatherDuster, DefaultHarpiesFeatherDusterFirst);
            AddExecutor(ExecutorType.Activate, CardId.CosmicCyclone, DefaultCosmicCyclone);
            AddExecutor(ExecutorType.Activate, CardId.HarpiesFeatherDuster);
            AddExecutor(ExecutorType.Activate, CardId.DarkHole, DefaultDarkHole);

            AddExecutor(ExecutorType.Activate, CardId.PotOfDuality, PotOfDualityEffect);

            AddExecutor(ExecutorType.Summon, CardId.YosenjuKama1, HaveAnotherYosenjuWithSameNameInHand);
            AddExecutor(ExecutorType.Summon, CardId.YosenjuKama2, HaveAnotherYosenjuWithSameNameInHand);
            AddExecutor(ExecutorType.Summon, CardId.YosenjuKama3, HaveAnotherYosenjuWithSameNameInHand);
            AddExecutor(ExecutorType.Summon, CardId.YosenjuKama1);
            AddExecutor(ExecutorType.Summon, CardId.YosenjuKama2);
            AddExecutor(ExecutorType.Summon, CardId.YosenjuKama3);
            AddExecutor(ExecutorType.Summon, CardId.YosenjuTsujik);

            AddExecutor(ExecutorType.Activate, CardId.YosenjuKama1, YosenjuEffect);
            AddExecutor(ExecutorType.Activate, CardId.YosenjuKama2, YosenjuEffect);
            AddExecutor(ExecutorType.Activate, CardId.YosenjuKama3, YosenjuEffect);
            AddExecutor(ExecutorType.Activate, CardId.YosenjuTsujik, YosenjuEffect);

            AddExecutor(ExecutorType.SpellSet, CardId.SolemnJudgment, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.SolemnStrike, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.SolemnWarning, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.MacroCosmos, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.VanitysEmptiness, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.MagicDrain, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.DrowningMirrorForce, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.QuakingMirrorForce, TrapSetUnique);
            AddExecutor(ExecutorType.SpellSet, CardId.StarlightRoad, TrapSetUnique);

            AddExecutor(ExecutorType.SpellSet, CardId.SolemnJudgment, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.SolemnStrike, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.SolemnWarning, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.MacroCosmos, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.VanitysEmptiness, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.MagicDrain, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.DrowningMirrorForce, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.QuakingMirrorForce, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.StarlightRoad, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.HarpiesFeatherDuster, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.DarkHole, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.PotOfDuality, TrapSetWhenZoneFree);
            AddExecutor(ExecutorType.SpellSet, CardId.CosmicCyclone, TrapSetWhenZoneFree);

            AddExecutor(ExecutorType.SpellSet, CardId.CardOfDemise);
            AddExecutor(ExecutorType.Activate, CardId.CardOfDemise, CardOfDemiseEffect);

            AddExecutor(ExecutorType.SpellSet, CardId.SolemnJudgment, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.SolemnStrike, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.SolemnWarning, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.MacroCosmos, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.VanitysEmptiness, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.MagicDrain, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.DrowningMirrorForce, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.QuakingMirrorForce, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.StarlightRoad, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.HarpiesFeatherDuster, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.DarkHole, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.PotOfDuality, CardOfDemiseAcivated);
            AddExecutor(ExecutorType.SpellSet, CardId.CosmicCyclone, CardOfDemiseAcivated);

            AddExecutor(ExecutorType.SpSummon, CardId.EvilswarmExcitonKnight, DefaultEvilswarmExcitonKnightSummon);
            AddExecutor(ExecutorType.Activate, CardId.EvilswarmExcitonKnight, DefaultEvilswarmExcitonKnightEffect);

            AddExecutor(ExecutorType.SpSummon, CardId.DarkRebellionXyzDragon, DarkRebellionXyzDragonSummon);
            AddExecutor(ExecutorType.Activate, CardId.DarkRebellionXyzDragon, DarkRebellionXyzDragonEffect);

            AddExecutor(ExecutorType.SpSummon, CardId.Number39Utopia, DefaultNumberS39UtopiaTheLightningSummon);
            AddExecutor(ExecutorType.SpSummon, CardId.NumberS39UtopiaOne);
            AddExecutor(ExecutorType.SpSummon, CardId.NumberS39UtopiatheLightning);
            AddExecutor(ExecutorType.Activate, CardId.NumberS39UtopiatheLightning);

            AddExecutor(ExecutorType.Activate, CardId.StardustDragon, DefaultStardustDragonEffect);

            AddExecutor(ExecutorType.Activate, CardId.StarlightRoad, DefaultTrap);
            AddExecutor(ExecutorType.Activate, CardId.MagicDrain);
            AddExecutor(ExecutorType.Activate, CardId.SolemnWarning, DefaultSolemnWarning);
            AddExecutor(ExecutorType.Activate, CardId.SolemnStrike, DefaultSolemnStrike);
            AddExecutor(ExecutorType.Activate, CardId.SolemnJudgment, DefaultSolemnJudgment);
            AddExecutor(ExecutorType.Activate, CardId.MacroCosmos, DefaultUniqueTrap);
            AddExecutor(ExecutorType.Activate, CardId.VanitysEmptiness, DefaultUniqueTrap);
            AddExecutor(ExecutorType.Activate, CardId.DrowningMirrorForce, DefaultUniqueTrap);
            AddExecutor(ExecutorType.Activate, CardId.QuakingMirrorForce, DefaultUniqueTrap);

            AddExecutor(ExecutorType.Repos, DefaultMonsterRepos);
        }

        public override bool OnSelectHand()
        {
            // go first
            return true;
        }

        public override void OnNewTurn()
        {
            CardOfDemiseUsed = false;
        }

        public override bool OnSelectYesNo(int desc)
        {
            // Yosenju Kama 2 shouldn't attack directly at most times
            if (Card == null)
                return true;
            // Logger.DebugWriteLine(Card.Name);
            if (Card.Id == CardId.YosenjuKama2)
                return Card.ShouldDirectAttack;
            else
                return true;
        }

        public override bool OnPreBattleBetween(ClientCard attacker, ClientCard defender)
        {
            if (!defender.IsMonsterHasPreventActivationEffectInBattle())
            {
                if (attacker.Attribute == (int)CardAttribute.Wind && Bot.HasInHand(CardId.YosenjuTsujik))
                    attacker.RealPower = attacker.RealPower + 1000;
            }
            return base.OnPreBattleBetween(attacker, defender);
        }

        private bool PotOfDualityEffect()
        {
            if (CardOfDemiseUsed)
            {
                AI.SelectCard(new[]
                    {
                    CardId.StarlightRoad,
                    CardId.MagicDrain,
                    CardId.SolemnJudgment,
                    CardId.VanitysEmptiness,
                    CardId.HarpiesFeatherDuster,
                    CardId.DrowningMirrorForce,
                    CardId.QuakingMirrorForce,
                    CardId.SolemnStrike,
                    CardId.SolemnWarning,
                    CardId.MacroCosmos,
                    CardId.CardOfDemise
                });
            }
            else
            {
                AI.SelectCard(new[]
                    {
                    CardId.YosenjuKama3,
                    CardId.YosenjuKama1,
                    CardId.YosenjuKama2,
                    CardId.StarlightRoad,
                    CardId.MagicDrain,
                    CardId.VanitysEmptiness,
                    CardId.HarpiesFeatherDuster,
                    CardId.DrowningMirrorForce,
                    CardId.QuakingMirrorForce,
                    CardId.SolemnStrike,
                    CardId.SolemnJudgment,
                    CardId.SolemnWarning,
                    CardId.MacroCosmos,
                    CardId.CardOfDemise,
                });
            }
            return true;
        }

        private bool CardOfDemiseEffect()
        {
            if (AI.Utils.IsTurn1OrMain2())
            {
                CardOfDemiseUsed = true;
                return true;
            }
            return false;
        }

        private bool HaveAnotherYosenjuWithSameNameInHand()
        {
            foreach (ClientCard card in Bot.Hand)
            {
                if (card != null && !card.Equals(Card) && card.Id == Card.Id)
                    return true;
            }
            return false;
        }

        private bool TrapSetUnique()
        {
            foreach (ClientCard card in Bot.SpellZone)
            {
                if (card != null && card.Id == Card.Id)
                    return false;
            }
            return TrapSetWhenZoneFree();
        }

        private bool TrapSetWhenZoneFree()
        {
            return Bot.GetSpellCountWithoutField() < 4;
        }

        private bool CardOfDemiseAcivated()
        {
            return CardOfDemiseUsed;
        }

        private bool YosenjuEffect()
        {
            // Don't activate the return to hand effect first
            if (Duel.Phase == DuelPhase.End)
                return false;
            AI.SelectCard(new[]
                {
                    CardId.YosenjuKama1,
                    CardId.YosenjuKama2,
                    CardId.YosenjuKama3
                });
            return true;
        }

        private bool CardOfDemiseEPEffect()
        {
            // do the end phase effect of Card Of Demise before Yosenjus return to hand
            return Duel.Phase == DuelPhase.End;
        }

        private bool GagagaCowboySummon()
        {
            if (Duel.LifePoints[1] <= 800 || (Bot.GetMonsterCount()>=4 && Duel.LifePoints[1] <= 1600))
            {
                AI.SelectPosition(CardPosition.FaceUpDefence);
                return true;
            }
            return false;
        }

        private bool DarkRebellionXyzDragonSummon()
        {
            int selfBestAttack = AI.Utils.GetBestAttack(Bot);
            int oppoBestAttack = AI.Utils.GetBestAttack(Enemy);
            return selfBestAttack <= oppoBestAttack;
        }

        private bool DarkRebellionXyzDragonEffect()
        {
            int oppoBestAttack = AI.Utils.GetBestAttack(Enemy);
            ClientCard target = AI.Utils.GetOneEnemyBetterThanValue(oppoBestAttack, true);
            if (target != null)
            {
                AI.SelectNextCard(target);
            }
            return true;
        }

        private bool NumberS39UtopiatheLightningSummon()
        {
            int selfBestAttack = AI.Utils.GetBestAttack(Bot);
            int oppoBestAttack = AI.Utils.GetBestPower(Enemy);
            return selfBestAttack <= oppoBestAttack;
        }
    }
}