module.exports = {
    env: {
        browser: true,
        es2021: true,
    },
    extends: "eslint:recommended",
    parserOptions: {
        ecmaVersion: "latest",
    },
    rules: {
        "arrow-spacing": "error",
        "block-spacing": "error",
        "brace-style": "error",
        "comma-dangle": ["error", "only-multiline"],
        "comma-spacing": "error",
        "comma-style": ["error", "last"],
        "curly": ["error", "multi-line", "consistent"],
        "eol-last": "error",
        "func-call-spacing": "error",
        "function-call-argument-newline": ["error", "consistent"],
        "function-paren-newline": ["error", "consistent"],
        "indent": ["error", 4],
        "key-spacing": "error",
        "keyword-spacing": "error",
        "linebreak-style": ["error", "unix"],
        "no-extra-semi": "error",
        "no-mixed-spaces-and-tabs": "error",
        "no-trailing-spaces": "error",
        "no-whitespace-before-property": "error",
        "object-curly-newline": ["error", {consistent: true, multiline: true}],
        "quote-props": ["error", "consistent-as-needed"],
        "semi": ["error", "always"],
        "semi-spacing": "error",
        "semi-style": ["error", "last"],
        "space-before-blocks": "error",
        "space-before-function-paren": ["error", "never"],
        "space-in-parens": ["error", "never"],
        "space-infix-ops": "error",
        "space-unary-ops": "error",
        "switch-colon-spacing": "error",
        "template-curly-spacing": ["error", "never"],
        "unicode-bom": "error",
        "no-multi-spaces": "error",
        "object-curly-spacing": ["error", "never"],
        "operator-linebreak": ["error", "after"],
        "no-unused-vars": "off",
        "no-redeclare": "off",
    },
    globals: {
        // this file
        module: "writable",
        //script.js
        gradioApp: "writable",
        onUiLoaded: "writable",
        onUiUpdate: "writable",
        onOptionsChanged: "writable",
        uiCurrentTab: "writable",
        uiElementIsVisible: "writable",
        uiElementInSight: "writable",
        executeCallbacks: "writable",
        //ui.js
        opts: "writable",
        all_gallery_buttons: "writable",
        selected_gallery_button: "writable",
        selected_gallery_index: "writable",
        args_to_array: "writable",
        switch_to_txt2img: "writable",
        switch_to_img2img_tab: "writable",
        switch_to_img2img: "writable",
        switch_to_sketch: "writable",
        switch_to_inpaint: "writable",
        switch_to_inpaint_sketch: "writable",
        switch_to_extras: "writable",
        get_tab_index: "writable",
        create_submit_args: "writable",
        restart_reload: "writable",
        updateInput: "writable",
        //extraNetworks.js
        requestGet: "writable",
        popup: "writable",
        // from python
        localization: "writable",
        // progrssbar.js
        randomId: "writable",
        requestProgress: "writable",
        // imageviewer.js
        modalPrevImage: "writable",
        modalNextImage: "writable",
    }
};
