import { test, expect } from '@jest/globals'

import { Story } from '../story/story'

test('Step Trim test 1', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.trimBeforeStep()
    expect(story.datablocks.length).toStrictEqual(3)
})

test('Step Trim test 2', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.append('ai' as any, '3')
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.append('ai' as any, '7')
    story.undo()
    story.append('ai' as any, '8')
    story.undo()
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.undo()
    story.append('ai' as any, '11')
    story.undo()
    story.append('ai' as any, '12')
    story.undo()
    story.append('ai' as any, '13')
    story.undo()
    story.append('ai' as any, '14')
    story.trimBeforeStep()
    expect(story.datablocks.length).toStrictEqual(8)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('2')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('3')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('14')
})

test('Step Trim test 3', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()

    story.trimBeforeStep(3)
    expect(story.datablocks.length).toStrictEqual(5)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
})

test('Step Trim test 4', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()

    story.trimBeforeStep(2)
    expect(story.datablocks.length).toStrictEqual(5)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
})

test('Step Trim test 5', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()

    story.trimBeforeStep(-1)
    expect(story.datablocks.length).toStrictEqual(5)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
})

test('Step Trim test 6', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()

    story.trimBeforeStep(3)
    expect(story.datablocks.length).toStrictEqual(9)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('9')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('10')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('11')
})

test('Step Trim test 7', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()

    story.trimBeforeStep(3)
    expect(story.datablocks.length).toStrictEqual(12)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[9].dataFragment.data).toStrictEqual('9')
    expect(story.datablocks[10].dataFragment.data).toStrictEqual('10')
    expect(story.datablocks[11].dataFragment.data).toStrictEqual('11')
})

test('Step Trim test 8', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()
    story.trimBeforeStep(3)
    expect(story.datablocks.length).toStrictEqual(9)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('9')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('10')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('11')
})

test('Step Trim test 9', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '2')
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()
    story.trimBeforeStep(3)
    expect(story.datablocks.length).toStrictEqual(13)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('2')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[9].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[10].dataFragment.data).toStrictEqual('9')
    expect(story.datablocks[11].dataFragment.data).toStrictEqual('10')
    expect(story.datablocks[12].dataFragment.data).toStrictEqual('11')
})

test('Step Trim test 10', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()

    story.trimBeforeStep(3)
    expect(story.datablocks.length).toStrictEqual(12)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[9].dataFragment.data).toStrictEqual('9')
    expect(story.datablocks[10].dataFragment.data).toStrictEqual('10')
    expect(story.datablocks[11].dataFragment.data).toStrictEqual('11')
})

test('Trim test 1', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(3)
})

test('Trim test 2', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.append('ai' as any, '3')
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.append('ai' as any, '7')
    story.undo()
    story.append('ai' as any, '8')
    story.undo()
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.undo()
    story.append('ai' as any, '11')
    story.undo()
    story.append('ai' as any, '12')
    story.undo()
    story.append('ai' as any, '13')
    story.undo()
    story.append('ai' as any, '14')
    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(8)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('2')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('3')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('6')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('14')
})

test('Trim test 3', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()

    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(4)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
})

test('Trim test 4', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()
    story.undo()
    story.undo()

    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(4)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
})

test('Trim test 5', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()

    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(9)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('10')
})

test('Trim test 6', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()
    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(6)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('10')
})

test('Trim test 7', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '2')
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()
    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(10)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('e')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('2')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[7].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[8].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[9].dataFragment.data).toStrictEqual('10')
})

test('Trim test 8', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.insert('edit' as any, 'e', story.getText().length, story.getText().length, true)
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')

    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(7)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
    expect(story.datablocks[1].dataFragment.data).toStrictEqual('1')
    expect(story.datablocks[2].dataFragment.data).toStrictEqual('4')
    expect(story.datablocks[3].dataFragment.data).toStrictEqual('5')
    expect(story.datablocks[4].dataFragment.data).toStrictEqual('8')
    expect(story.datablocks[5].dataFragment.data).toStrictEqual('10')
    expect(story.datablocks[6].dataFragment.data).toStrictEqual('11')
})

test('Trim test 9', async () => {
    const story = new Story()
    story.append('ai' as any, '1')
    story.append('ai' as any, '2')
    story.undo()
    story.append('ai' as any, '3')
    story.undo()
    story.append('ai' as any, '4')
    story.append('ai' as any, '5')
    story.append('ai' as any, '6')
    story.undo()
    story.append('ai' as any, '8')
    story.append('ai' as any, '9')
    story.undo()
    story.append('ai' as any, '10')
    story.append('ai' as any, '11')
    story.undo()
    story.undo()
    story.undo()
    story.undo()
    story.undo()
    story.undo()

    story.trimBranches()
    expect(story.datablocks.length).toStrictEqual(1)
    expect(story.datablocks[0].dataFragment.data).toStrictEqual('')
})
