from dotmap import DotMap

v1pp_defaults = {
    'steps': 50,
    'plms': True,
    'fixed_code': False,
    'ddim_eta': 0.0,
    'height': 512,
    'width': 512,
    'latent_channels': 4,
    'downsampling_factor': 8,
    'scale': 7.0,
    'dynamic_threshold': None,
    'seed': None,
}

v1pp_forced_defaults = {
    'latent_channels': 4,
    'downsampling_factor': 8,
}

defaults = {
    'v1pp': (v1pp_defaults, v1pp_forced_defaults),
}

def sanitize_input(request):
    """
    Sanitize the input data and set defaults
    """
    request = DotMap(request)
    default, forced_default = v1pp_defaults, v1pp_forced_defaults
    for k, v in default.items():
        if k not in request:
            request[k] = v

    for k, v in forced_default.items():
        request[k] = v

    if request.width * request.height == 0:
        return False, "width and height must be non-zero"

    if request.width <= 0:
        return False, "width must be positive"
    
    if request.height <= 0:
        return False, "height must be positive"
    
    if request.steps <= 0:
        return False, "steps must be positive"
    
    if request.ddim_eta < 0:
        return False, "ddim_eta shouldn't be negative"

    if request.scale < 1.0:
        return False, "scale should be at least 1.0"
    
    if request.dynamic_threshold is not None and request.dynamic_threshold < 0:
        return False, "dynamic_threshold shouldn't be negative"

    if request.width * request.height >= 2048*512:
        return False, "width and height must be less than 2048*512"

    return True, request

    



    