from fastapi import FastAPI
from pydantic import BaseModel
from fastapi.responses import HTMLResponse
from sentry_sdk import capture_exception
from sentry_sdk import capture_message
from sentry_sdk import start_transaction
from hydra_node.config import init_config_model
app = FastAPI()

@app.on_event("startup")
async def startup_event():
    print("Startup")
    #model, config = init_config()

@app.on_event("shutdown")
async def shutdown_event():
    print('Shutdown')

@app.get("/", response_class=HTMLResponse)
def root():
    return "OK"

class GenerationRequest(BaseModel):
    prompt: str
    n_samples: int = 1
    steps: int = 50

class GenerationOutput(BaseModel):
    generation: str
    version: int = 1

@app.post('/generate', response_model=GenerationOutput)
def generate(request: GenerationRequest):
    return {"generation": "Hello World"}