from novelutils.novelfra import *
from pyfra import *
import sys
import argparse

# run bash: -b
# run command: default
# kill

name = 'pyfra-basedformer'
dry = False
bash = False

config_obj = KubeConfig()
config_obj.set_name(name)
config_obj.set_gpu(gpu_name=GPU.A100_PCIE_40GB, amount=1)
config_obj.set_ram(16)
config_obj.set_cpu(4)
config_obj.dry_run(dry)
config_obj.print_information()
config_obj.create_deployment(overwrite=True)
config_obj.create_service(overwrite=True)

remote = config_obj.get_pyfra_remote()
env1 = remote.env('noname', python_version=None)

path = env1.path('/home/xuser/diffusionstorage/workspace/kuru/basedformer')
env1.sh('pip install /home/xuser/hugessd/pytorch/torch-1.10.1+cu113-cp38-cp38-linux_x86_64.whl')
env1.sh('pip install einops numpy')
env1.sh('pip install tqdm')
env1.sh('pip install /home/xuser/diffusionstorage/workspace/finetune/pokepls/transformers-repo')
env1.sh('pip3 install einops==0.4.1 pyyaml wandb')
env1.sh('wandb login 21a9442d42a35e15ce421f2b702ec58508b9adc4')
env1.sh('pip3 install dotmap')
with always_rerun():
    if bash:
        path.sh("bash")
    else:
        print(f"Running {sys.argv[1]}")
        path.sh(f'python3 {sys.argv[1]}')
    