import torch.nn as nn
from dotmap import DotMap

class BaseVisionModel(nn.Module):
    def __init__(self, user_config, **kwargs):
        super().__init__()
        self.user_config = user_config
        self.config = self.configure_model()

    def configure_model(self):
        full_config = {}
        if not hasattr(self, 'default_config'):
            raise ValueError("No default config found, add one for the model to function")
        
        #apply defaults
        for k, v in self.default_config.items():
            full_config[k] = v

        #apply user defined config if provided
        for k, v in self.user_config.items():
            full_config[k] = v

        full_config = DotMap(full_config)
        return full_config
