from novelutils.novelfra import *
from pyfra import *
import argparse
import sys


parser = argparse.ArgumentParser(description='Novelfra utility tool for launching pods and deployments on kubernetes with pyfra.')
parser.add_argument('name', nargs="?", type=str, help='Deployment name')
#TODO: Make the default the last one we used.
parser.add_argument('--service', action="store_true", help="""Create a service with the deployment. If a service is not 
created you won't be able to access the pod outside from the kube network.""")
parser.add_argument('-b', '--bash', action="store_true", help='Run bash instead of python3.')
parser.add_argument('-k', '--kill', action="store_true", help='Kill a pod given the name.')
parser.add_argument('-s', '--start', action="store_true", help='Start a pod given the name.')
parser.add_argument('-g', '--gpu', default="RTX_A4000", type=str, help='Use a gpu.')
parser.add_argument('-n', '--amount', type=int, default=1, help='Amount of gpus to use.')
parser.add_argument('-c', '--cpu', type=int, default=4, help='Amount of cpu cores to use.')
parser.add_argument('-r', '--ram', type=int, default=8, help='Amount of ram to use.')
parser.add_argument('-i', '--image', type=str, default='novelai/kube-ssh:13', help='Docker image to use.')
parser.add_argument(type=str, nargs="*", dest="command", default="bash", help='Commands to run.')

args = parser.parse_args()
print(args)
name = args.name
dry = False
bash = args.bash

config_obj = KubeConfig()
config_obj.set_name(name)
if args.start:
    
    config_obj.set_gpu(gpu_name=args.gpu, amount=args.amount)
    config_obj.set_ram(args.ram)
    config_obj.set_cpu(args.cpu)
    config_obj.dry_run(dry)
    config_obj.print_information()

    config_obj.create_deployment(overwrite=False)
    if args.service:
        config_obj.create_service(overwrite=False)

if args.kill:
    config_obj.kill_deployment()
    config_obj.kill_service()
    sys.exit(0)

remote = config_obj.get_pyfra_remote()
env1 = remote.env('noname', python_version=None)

path = env1.path('/home/xuser/diffusionstorage/workspace/kuru/basedformer')
#env1.sh('pip3 install git+https://github.com/pytorch/fairseq')
env1.sh('pip3 install /home/xuser/hugessd/pytorch/torch-1.10.1+cu113-cp38-cp38-linux_x86_64.whl')

#with always_rerun():
    #env1.sh('pip uninstall transformers')
    #env1.sh('pip install /home/xuser/diffusionstorage/workspace/finetune/pokepls/transformers-repo')
    

with always_rerun():
    if args.bash:
        path.sh("bash")
    else:
        if args.command:
            path.sh(" ".join(args.command))
        else:
            print("No command given.")
            sys.exit(0)
    