/*
 * Decompiled with CFR 0.152.
 */
package syi.png;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import syi.util.ByteStream;

public class SPngEncoder {
    private final String STR_C = "(C)shi-chan 2001-2003";
    private OutputStream OUT;
    private int width;
    private int height;
    private int[] i_off;
    private CRC32 crc = new CRC32();
    private Deflater deflater;
    private byte[] b;
    private byte[] bGet = new byte[1025];
    private int seek = 0;
    private int[] iF = new int[3];
    private int[] iFNow = new int[3];
    private int[] iFLOld = new int[3];
    private int[] iFL;
    private ByteStream work;
    private int image_type = 2;
    private byte image_filter;
    private boolean isProgress = false;

    public SPngEncoder(ByteStream byteStream, ByteStream byteStream2, Deflater deflater) {
        System.out.println("(C)shi-chan 2001-2003");
        this.work = byteStream;
        this.b = byteStream2.getBuffer();
        this.deflater = deflater;
    }

    private void bFilter() throws IOException {
        this.bW(this.image_filter);
        this.zero(this.iF);
    }

    private void bW(byte by) throws IOException {
        this.b[this.seek++] = by;
        if (this.seek >= this.b.length) {
            this.wCompress();
        }
    }

    public void encode(OutputStream outputStream, int[] nArray, int n, int n2, int n3) {
        try {
            this.OUT = outputStream;
            this.width = n;
            this.height = n2;
            this.i_off = nArray;
            this.image_filter = (byte)n3;
            if (this.image_filter > 1) {
                if (this.iFL == null || this.iFL.length < this.width) {
                    this.iFL = new int[this.width];
                }
                this.zero(this.iFL);
                this.zero(this.iFLOld);
            }
            outputStream.write(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10});
            this.mIHDR();
            this.mEXt("Title", "Shi-Tools Oekaki Data");
            this.mEXt("Copyright", "(C)shi-chan 2001-2003");
            this.mEXt("Software", "Shi-Tools");
            this.mIDAT();
            this.mIEND();
            outputStream.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void fencode(ByteStream byteStream, int[] nArray, int n, int n2) {
        byteStream.reset();
        int[] nArray2 = new int[4];
        int n3 = 0;
        while (n3 < 4) {
            byteStream.reset();
            this.encode(byteStream, nArray, n, n2, n3);
            nArray2[n3] = byteStream.size();
            ++n3;
        }
        n3 = 0;
        while (n3 < 4) {
            int n4 = n3 + 1;
            while (n4 < 4) {
                if (nArray2[n3] > nArray2[n4]) break;
                ++n4;
            }
            if (n4 >= 4) break;
            ++n3;
        }
        if (n3 != 3) {
            byteStream.reset();
            this.encode(byteStream, nArray, n, n2, n3);
        }
    }

    private void getFPic(int n, int n2) {
        int n3 = 0;
        while (n3 < 3) {
            this.iFNow[n3] = n >>> (n3 << 3) & 0xFF;
            ++n3;
        }
        switch (this.image_filter) {
            case 0: {
                return;
            }
            case 1: {
                n3 = 0;
                while (n3 < 3) {
                    this.iF[n3] = this.iFNow[n3] - this.iF[n3];
                    ++n3;
                }
                break;
            }
            case 2: {
                n3 = 0;
                while (n3 < 3) {
                    this.iF[n3] = this.iFNow[n3] - (this.iFL[n2] >>> (n3 << 3) & 0xFF);
                    ++n3;
                }
                this.iFL[n2] = n;
                break;
            }
            case 3: {
                n3 = 0;
                while (n3 < 3) {
                    this.iF[n3] = this.iFNow[n3] - (this.iF[n3] + (this.iFL[n2] >>> (n3 << 3) & 0xFF) >>> 1);
                    ++n3;
                }
                this.iFL[n2] = n;
                break;
            }
        }
        int[] nArray = this.iF;
        this.iF = this.iFNow;
        this.iFNow = nArray;
    }

    private void mEXt(String string, String string2) throws IOException {
        int n = 1950701684;
        this.wCh(n);
        this.wArray(string.getBytes());
        this.w(0);
        this.wArray(string2.getBytes());
        this.wChA();
    }

    private void mIDAT() throws IOException {
        int n = 1229209940;
        this.wCh(n);
        this.wImage();
        this.wChA();
    }

    private void mIEND() throws IOException {
        int n = 1229278788;
        this.wCh(n);
        this.wChA();
    }

    private void mIHDR() throws IOException {
        int n = 1229472850;
        this.wCh(n);
        this.wInt(this.width);
        this.wInt(this.height);
        this.w(8);
        this.w(2);
        this.w(0);
        this.w(0);
        this.w(this.isProgress ? 1 : 0);
        this.wChA();
    }

    public void setInterlace(boolean bl) {
        this.isProgress = bl;
    }

    private void w(int n) throws IOException {
        this.work.write(n);
    }

    private void wArray(byte[] byArray) throws IOException {
        this.wArray(byArray, byArray.length);
    }

    private void wArray(byte[] byArray, int n) throws IOException {
        if (n > 0) {
            this.work.write(byArray, 0, n);
        }
    }

    private void wCh(int n) throws IOException {
        this.work.reset();
        this.wInt(n);
    }

    private void wChA() throws IOException {
        int n = this.work.size();
        this.crc.reset();
        this.crc.update(this.work.getBuffer(), 0, n);
        this.wInt((int)this.crc.getValue());
        n -= 4;
        int n2 = 24;
        while (n2 >= 0) {
            this.OUT.write(n >>> n2 & 0xFF);
            n2 -= 8;
        }
        this.work.writeTo(this.OUT);
    }

    private void wCompress() throws IOException {
        if (this.seek == 0) {
            return;
        }
        this.deflater.setInput(this.b, 0, this.seek);
        this.seek = 0;
        while (!this.deflater.needsInput()) {
            int n = this.deflater.deflate(this.bGet, 0, this.bGet.length - 1);
            if (n == 0) continue;
            this.wArray(this.bGet, n);
        }
    }

    private void wImage() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        this.deflater.reset();
        this.seek = 0;
        if (!this.isProgress) {
            n3 = 0;
            while (n3 < this.height) {
                this.bFilter();
                n2 = 0;
                while (n2 < this.width) {
                    this.getFPic(this.i_off[n4++], n2);
                    n = 2;
                    while (n >= 0) {
                        this.bW((byte)this.iFNow[n]);
                        --n;
                    }
                    ++n2;
                }
                ++n3;
            }
        } else {
            byte by = 0;
            byte[][][] byArrayArray = new byte[][][]{new byte[][]{new byte[1]}, new byte[][]{{4}}, new byte[][]{{32, 36}}, new byte[][]{{2, 6}, {34, 38}}, new byte[][]{{16, 18, 20, 22}, {48, 50, 52, 54}}, new byte[][]{{1, 3, 5, 7}, {17, 19, 21, 23}, {33, 35, 37, 39}, {49, 51, 53, 55}}, new byte[][]{{8, 9, 10, 11, 12, 13, 14, 15}, {24, 25, 26, 27, 28, 29, 30, 31}, {40, 41, 42, 43, 44, 45, 46, 47}, {56, 57, 58, 59, 60, 61, 62, 63}}};
            int n5 = 0;
            while (n5 < byArrayArray.length) {
                this.zero(this.iFL);
                this.zero(this.iF);
                n3 = 0;
                while (n3 < this.height) {
                    int n6 = 0;
                    while (n6 < byArrayArray[n5].length) {
                        boolean bl = false;
                        n2 = 0;
                        while (n2 < this.width) {
                            int n7 = 0;
                            while (n7 < byArrayArray[n5][n6].length) {
                                by = byArrayArray[n5][n6][n7];
                                int n8 = n2 + by % 8;
                                int n9 = n3 + by / 8;
                                if (n8 < this.width && n9 < this.height) {
                                    if (!bl) {
                                        this.bFilter();
                                        bl = true;
                                    }
                                    this.getFPic(this.i_off[this.width * n9 + n8], n8);
                                    n = 2;
                                    while (n >= 0) {
                                        this.bW((byte)this.iFNow[n]);
                                        --n;
                                    }
                                }
                                ++n7;
                            }
                            n2 += 8;
                        }
                        ++n6;
                    }
                    n3 += 8;
                }
                ++n5;
            }
        }
        this.wCompress();
        this.deflater.finish();
        while (!this.deflater.finished()) {
            n4 = this.deflater.deflate(this.bGet, 0, this.bGet.length - 1);
            this.wArray(this.bGet, n4);
        }
    }

    private void wInt(int n) throws IOException {
        int n2 = 24;
        while (n2 >= 0) {
            this.w(n >>> n2 & 0xFF);
            n2 -= 8;
        }
    }

    private void zero(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = 0;
            ++n;
        }
    }
}

