/*
 * Decompiled with CFR 0.152.
 */
package syi.jpeg;

import java.io.IOException;
import java.io.OutputStream;

public class SJpegEncoder {
    OutputStream OUT;
    private int[] i_off;
    private int width;
    private int height;
    private int HV;
    private double[][] mCosT;
    private int[] mOldDC;
    private double kSqrt2;
    private double kDisSqrt2;
    private double kPaiDiv16;
    private int bitSeek = 7;
    private int bitValue = 0;
    private int[] kYQuantumT = new int[64];
    private int[] kCQuantumT = new int[64];
    private final byte[] kYDcSizeT = new byte[]{2, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8, 9};
    private final short[] kYDcCodeT;
    private final byte[] kCDcSizeT;
    private final short[] kCDcCodeT;
    private final byte[] kYAcSizeT;
    private final short[] kYAcCodeT;
    private int kYEOBidx;
    private int kYZRLidx;
    private final byte[] kCAcSizeT;
    private final short[] kCAcCodeT;
    private int kCEOBidx;
    private int kCZRLidx;
    private final byte[] kZigzag;

    public SJpegEncoder() {
        short[] sArray = new short[12];
        sArray[1] = 2;
        sArray[2] = 3;
        sArray[3] = 4;
        sArray[4] = 5;
        sArray[5] = 6;
        sArray[6] = 14;
        sArray[7] = 30;
        sArray[8] = 62;
        sArray[9] = 126;
        sArray[10] = 254;
        sArray[11] = 510;
        this.kYDcCodeT = sArray;
        this.kCDcSizeT = new byte[]{2, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        short[] sArray2 = new short[12];
        sArray2[1] = 1;
        sArray2[2] = 2;
        sArray2[3] = 6;
        sArray2[4] = 14;
        sArray2[5] = 30;
        sArray2[6] = 62;
        sArray2[7] = 126;
        sArray2[8] = 254;
        sArray2[9] = 510;
        sArray2[10] = 1022;
        sArray2[11] = 2046;
        this.kCDcCodeT = sArray2;
        this.kYAcSizeT = new byte[]{4, 2, 2, 3, 4, 5, 7, 8, 10, 16, 16, 4, 5, 7, 9, 11, 16, 16, 16, 16, 16, 5, 8, 10, 12, 16, 16, 16, 16, 16, 16, 6, 9, 12, 16, 16, 16, 16, 16, 16, 16, 6, 10, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 7, 12, 16, 16, 16, 16, 16, 16, 16, 16, 8, 12, 16, 16, 16, 16, 16, 16, 16, 16, 9, 15, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        short[] sArray3 = new short[162];
        sArray3[0] = 10;
        sArray3[2] = 1;
        sArray3[3] = 4;
        sArray3[4] = 11;
        sArray3[5] = 26;
        sArray3[6] = 120;
        sArray3[7] = 248;
        sArray3[8] = 1014;
        sArray3[9] = -126;
        sArray3[10] = -125;
        sArray3[11] = 12;
        sArray3[12] = 27;
        sArray3[13] = 121;
        sArray3[14] = 502;
        sArray3[15] = 2038;
        sArray3[16] = -124;
        sArray3[17] = -123;
        sArray3[18] = -122;
        sArray3[19] = -121;
        sArray3[20] = -120;
        sArray3[21] = 28;
        sArray3[22] = 249;
        sArray3[23] = 1015;
        sArray3[24] = 4084;
        sArray3[25] = -119;
        sArray3[26] = -118;
        sArray3[27] = -117;
        sArray3[28] = -116;
        sArray3[29] = -115;
        sArray3[30] = -114;
        sArray3[31] = 58;
        sArray3[32] = 503;
        sArray3[33] = 4085;
        sArray3[34] = -113;
        sArray3[35] = -112;
        sArray3[36] = -111;
        sArray3[37] = -110;
        sArray3[38] = -109;
        sArray3[39] = -108;
        sArray3[40] = -107;
        sArray3[41] = 59;
        sArray3[42] = 1016;
        sArray3[43] = -106;
        sArray3[44] = -105;
        sArray3[45] = -104;
        sArray3[46] = -103;
        sArray3[47] = -102;
        sArray3[48] = -101;
        sArray3[49] = -100;
        sArray3[50] = -99;
        sArray3[51] = 122;
        sArray3[52] = 2039;
        sArray3[53] = -98;
        sArray3[54] = -97;
        sArray3[55] = -96;
        sArray3[56] = -95;
        sArray3[57] = -94;
        sArray3[58] = -93;
        sArray3[59] = -92;
        sArray3[60] = -91;
        sArray3[61] = 123;
        sArray3[62] = 4086;
        sArray3[63] = -90;
        sArray3[64] = -89;
        sArray3[65] = -88;
        sArray3[66] = -87;
        sArray3[67] = -86;
        sArray3[68] = -85;
        sArray3[69] = -84;
        sArray3[70] = -83;
        sArray3[71] = 250;
        sArray3[72] = 4087;
        sArray3[73] = -82;
        sArray3[74] = -81;
        sArray3[75] = -80;
        sArray3[76] = -79;
        sArray3[77] = -78;
        sArray3[78] = -77;
        sArray3[79] = -76;
        sArray3[80] = -75;
        sArray3[81] = 504;
        sArray3[82] = 32704;
        sArray3[83] = -74;
        sArray3[84] = -73;
        sArray3[85] = -72;
        sArray3[86] = -71;
        sArray3[87] = -70;
        sArray3[88] = -69;
        sArray3[89] = -68;
        sArray3[90] = -67;
        sArray3[91] = 505;
        sArray3[92] = -66;
        sArray3[93] = -65;
        sArray3[94] = -64;
        sArray3[95] = -63;
        sArray3[96] = -62;
        sArray3[97] = -61;
        sArray3[98] = -60;
        sArray3[99] = -59;
        sArray3[100] = -58;
        sArray3[101] = 506;
        sArray3[102] = -57;
        sArray3[103] = -56;
        sArray3[104] = -55;
        sArray3[105] = -54;
        sArray3[106] = -53;
        sArray3[107] = -52;
        sArray3[108] = -51;
        sArray3[109] = -50;
        sArray3[110] = -49;
        sArray3[111] = 1017;
        sArray3[112] = -48;
        sArray3[113] = -47;
        sArray3[114] = -46;
        sArray3[115] = -45;
        sArray3[116] = -44;
        sArray3[117] = -43;
        sArray3[118] = -42;
        sArray3[119] = -41;
        sArray3[120] = -40;
        sArray3[121] = 1018;
        sArray3[122] = -39;
        sArray3[123] = -38;
        sArray3[124] = -37;
        sArray3[125] = -36;
        sArray3[126] = -35;
        sArray3[127] = -34;
        sArray3[128] = -33;
        sArray3[129] = -32;
        sArray3[130] = -31;
        sArray3[131] = 2040;
        sArray3[132] = -30;
        sArray3[133] = -29;
        sArray3[134] = -28;
        sArray3[135] = -27;
        sArray3[136] = -26;
        sArray3[137] = -25;
        sArray3[138] = -24;
        sArray3[139] = -23;
        sArray3[140] = -22;
        sArray3[141] = -21;
        sArray3[142] = -20;
        sArray3[143] = -19;
        sArray3[144] = -18;
        sArray3[145] = -17;
        sArray3[146] = -16;
        sArray3[147] = -15;
        sArray3[148] = -14;
        sArray3[149] = -13;
        sArray3[150] = -12;
        sArray3[151] = 2041;
        sArray3[152] = -11;
        sArray3[153] = -10;
        sArray3[154] = -9;
        sArray3[155] = -8;
        sArray3[156] = -7;
        sArray3[157] = -6;
        sArray3[158] = -5;
        sArray3[159] = -4;
        sArray3[160] = -3;
        sArray3[161] = -2;
        this.kYAcCodeT = sArray3;
        this.kYEOBidx = 0;
        this.kYZRLidx = 151;
        this.kCAcSizeT = new byte[]{2, 2, 3, 4, 5, 5, 6, 7, 9, 10, 12, 4, 6, 8, 9, 11, 12, 16, 16, 16, 16, 5, 8, 10, 12, 15, 16, 16, 16, 16, 16, 5, 8, 10, 12, 16, 16, 16, 16, 16, 16, 6, 9, 16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        short[] sArray4 = new short[162];
        sArray4[1] = 1;
        sArray4[2] = 4;
        sArray4[3] = 10;
        sArray4[4] = 24;
        sArray4[5] = 25;
        sArray4[6] = 56;
        sArray4[7] = 120;
        sArray4[8] = 500;
        sArray4[9] = 1014;
        sArray4[10] = 4084;
        sArray4[11] = 11;
        sArray4[12] = 57;
        sArray4[13] = 246;
        sArray4[14] = 501;
        sArray4[15] = 2038;
        sArray4[16] = 4085;
        sArray4[17] = -120;
        sArray4[18] = -119;
        sArray4[19] = -118;
        sArray4[20] = -117;
        sArray4[21] = 26;
        sArray4[22] = 247;
        sArray4[23] = 1015;
        sArray4[24] = 4086;
        sArray4[25] = 32706;
        sArray4[26] = -116;
        sArray4[27] = -115;
        sArray4[28] = -114;
        sArray4[29] = -113;
        sArray4[30] = -112;
        sArray4[31] = 27;
        sArray4[32] = 248;
        sArray4[33] = 1016;
        sArray4[34] = 4087;
        sArray4[35] = -111;
        sArray4[36] = -110;
        sArray4[37] = -109;
        sArray4[38] = -108;
        sArray4[39] = -107;
        sArray4[40] = -106;
        sArray4[41] = 58;
        sArray4[42] = 502;
        sArray4[43] = -105;
        sArray4[44] = -104;
        sArray4[45] = -103;
        sArray4[46] = -102;
        sArray4[47] = -101;
        sArray4[48] = -100;
        sArray4[49] = -99;
        sArray4[50] = -98;
        sArray4[51] = 59;
        sArray4[52] = 1017;
        sArray4[53] = -97;
        sArray4[54] = -96;
        sArray4[55] = -95;
        sArray4[56] = -94;
        sArray4[57] = -93;
        sArray4[58] = -92;
        sArray4[59] = -91;
        sArray4[60] = -90;
        sArray4[61] = 121;
        sArray4[62] = 2039;
        sArray4[63] = -89;
        sArray4[64] = -88;
        sArray4[65] = -87;
        sArray4[66] = -86;
        sArray4[67] = -85;
        sArray4[68] = -84;
        sArray4[69] = -83;
        sArray4[70] = -82;
        sArray4[71] = 122;
        sArray4[72] = 2040;
        sArray4[73] = -81;
        sArray4[74] = -80;
        sArray4[75] = -79;
        sArray4[76] = -78;
        sArray4[77] = -77;
        sArray4[78] = -76;
        sArray4[79] = -75;
        sArray4[80] = -74;
        sArray4[81] = 249;
        sArray4[82] = -73;
        sArray4[83] = -72;
        sArray4[84] = -71;
        sArray4[85] = -70;
        sArray4[86] = -69;
        sArray4[87] = -68;
        sArray4[88] = -67;
        sArray4[89] = -66;
        sArray4[90] = -65;
        sArray4[91] = 503;
        sArray4[92] = -64;
        sArray4[93] = -63;
        sArray4[94] = -62;
        sArray4[95] = -61;
        sArray4[96] = -60;
        sArray4[97] = -59;
        sArray4[98] = -58;
        sArray4[99] = -57;
        sArray4[100] = -56;
        sArray4[101] = 504;
        sArray4[102] = -55;
        sArray4[103] = -54;
        sArray4[104] = -53;
        sArray4[105] = -52;
        sArray4[106] = -51;
        sArray4[107] = -50;
        sArray4[108] = -49;
        sArray4[109] = -48;
        sArray4[110] = -47;
        sArray4[111] = 505;
        sArray4[112] = -46;
        sArray4[113] = -45;
        sArray4[114] = -44;
        sArray4[115] = -43;
        sArray4[116] = -42;
        sArray4[117] = -41;
        sArray4[118] = -40;
        sArray4[119] = -39;
        sArray4[120] = -38;
        sArray4[121] = 506;
        sArray4[122] = -37;
        sArray4[123] = -36;
        sArray4[124] = -35;
        sArray4[125] = -34;
        sArray4[126] = -33;
        sArray4[127] = -32;
        sArray4[128] = -31;
        sArray4[129] = -30;
        sArray4[130] = -29;
        sArray4[131] = 2041;
        sArray4[132] = -28;
        sArray4[133] = -27;
        sArray4[134] = -26;
        sArray4[135] = -25;
        sArray4[136] = -24;
        sArray4[137] = -23;
        sArray4[138] = -22;
        sArray4[139] = -21;
        sArray4[140] = -20;
        sArray4[141] = 16352;
        sArray4[142] = -19;
        sArray4[143] = -18;
        sArray4[144] = -17;
        sArray4[145] = -16;
        sArray4[146] = -15;
        sArray4[147] = -14;
        sArray4[148] = -13;
        sArray4[149] = -12;
        sArray4[150] = -11;
        sArray4[151] = 1018;
        sArray4[152] = 32707;
        sArray4[153] = -10;
        sArray4[154] = -9;
        sArray4[155] = -8;
        sArray4[156] = -7;
        sArray4[157] = -6;
        sArray4[158] = -5;
        sArray4[159] = -4;
        sArray4[160] = -3;
        sArray4[161] = -2;
        this.kCAcCodeT = sArray4;
        this.kCEOBidx = 0;
        this.kCZRLidx = 151;
        byte[] byArray = new byte[64];
        byArray[1] = 1;
        byArray[2] = 8;
        byArray[3] = 16;
        byArray[4] = 9;
        byArray[5] = 2;
        byArray[6] = 3;
        byArray[7] = 10;
        byArray[8] = 17;
        byArray[9] = 24;
        byArray[10] = 32;
        byArray[11] = 25;
        byArray[12] = 18;
        byArray[13] = 11;
        byArray[14] = 4;
        byArray[15] = 5;
        byArray[16] = 12;
        byArray[17] = 19;
        byArray[18] = 26;
        byArray[19] = 33;
        byArray[20] = 40;
        byArray[21] = 48;
        byArray[22] = 41;
        byArray[23] = 34;
        byArray[24] = 27;
        byArray[25] = 20;
        byArray[26] = 13;
        byArray[27] = 6;
        byArray[28] = 7;
        byArray[29] = 14;
        byArray[30] = 21;
        byArray[31] = 28;
        byArray[32] = 35;
        byArray[33] = 42;
        byArray[34] = 49;
        byArray[35] = 56;
        byArray[36] = 57;
        byArray[37] = 50;
        byArray[38] = 43;
        byArray[39] = 36;
        byArray[40] = 29;
        byArray[41] = 22;
        byArray[42] = 15;
        byArray[43] = 23;
        byArray[44] = 30;
        byArray[45] = 37;
        byArray[46] = 44;
        byArray[47] = 51;
        byArray[48] = 58;
        byArray[49] = 59;
        byArray[50] = 52;
        byArray[51] = 45;
        byArray[52] = 38;
        byArray[53] = 31;
        byArray[54] = 39;
        byArray[55] = 46;
        byArray[56] = 53;
        byArray[57] = 60;
        byArray[58] = 61;
        byArray[59] = 54;
        byArray[60] = 47;
        byArray[61] = 55;
        byArray[62] = 62;
        byArray[63] = 63;
        this.kZigzag = byArray;
        this.kSqrt2 = 1.41421356;
        this.kDisSqrt2 = 1.0 / this.kSqrt2;
        this.kPaiDiv16 = 0.19634954084936207;
        this.mCosT = new double[8][8];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                this.mCosT[n][n2] = Math.cos((double)((2 * n2 + 1) * n) * this.kPaiDiv16);
                ++n2;
            }
            ++n;
        }
    }

    public void encode(OutputStream outputStream, int[] nArray, int n, int n2, int n3) {
        try {
            int n4 = 65496;
            int n5 = 65497;
            this.OUT = outputStream;
            this.mOldDC = new int[3];
            this.q(n3);
            this.i_off = nArray;
            this.width = n;
            this.height = n2;
            this.wShort(n4);
            this.mAPP0();
            this.mComment();
            this.mDQT();
            this.mDHT();
            this.mSOF();
            this.mSOS();
            this.mMCU();
            this.wShort(n5);
            this.OUT.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void getYCC(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = n3 * 8;
        int n10 = n4 * 8;
        int n11 = n + n9;
        int n12 = n2 + n10;
        int[] nArray3 = new int[3];
        int n13 = n2;
        while (n13 < n12) {
            int n14;
            if (n13 >= this.height) {
                try {
                    n14 = n7;
                    while (n14 < nArray2.length) {
                        nArray2[n14] = nArray2[n14 - n9];
                        ++n14;
                    }
                }
                catch (RuntimeException runtimeException) {}
                break;
            }
            int n15 = n13 * this.width + n;
            n14 = n;
            while (n14 < n11) {
                n8 = n6 = n14 >= this.width ? n8 : this.i_off[n15];
                nArray2[n7++] = n6;
                ++n15;
                ++n14;
            }
            ++n13;
        }
        int[] nArray4 = new int[3];
        n7 = 0;
        int n16 = 0;
        while (n16 < n10) {
            int n17 = 0;
            while (n17 < n9) {
                n13 = 0;
                nArray4[0] = 0;
                nArray4[1] = 0;
                nArray4[2] = 0;
                int n18 = 0;
                while (n18 < n4) {
                    int n19 = 0;
                    while (n19 < n3) {
                        n6 = nArray2[(n16 + n18) * n9 + (n17 + n19)];
                        int n20 = 0;
                        while (n20 < 3) {
                            int n21 = n20;
                            nArray4[n21] = nArray4[n21] + (n6 >> n20 * 8 & 0xFF);
                            ++n20;
                        }
                        ++n13;
                        ++n19;
                    }
                    ++n18;
                }
                n18 = 0;
                while (n18 < 3) {
                    nArray4[n18] = Math.min(Math.max(nArray4[n18] / n13, 0), 255);
                    ++n18;
                }
                nArray[n7++] = nArray4[2] << 16 | nArray4[1] << 8 | nArray4[0];
                n17 += n3;
            }
            n16 += n4;
        }
        n16 = 0;
        while (n16 < 64) {
            this.ycc(nArray3, nArray[n16]);
            nArray[n16] = nArray3[n5];
            ++n16;
        }
    }

    private void mAPP0() throws IOException {
        int n = 65504;
        byte[] byArray = "JFIF\u0000".getBytes();
        this.wShort(n);
        this.wShort(byArray.length + 11);
        this.wArray(byArray);
        this.w(1);
        this.w(2);
        this.w(1);
        this.wShort(72);
        this.wShort(72);
        this.w(0);
        this.w(0);
    }

    private final void mComment() throws IOException {
        int n = 65534;
        String string = "(C)shi-chan 2001";
        byte[] byArray = (String.valueOf(string) + '\u0000').getBytes();
        this.wShort(n);
        this.wShort(byArray.length + 2);
        this.wArray(byArray);
        System.out.println(string);
    }

    private void mDHT() throws IOException {
        int n = 65476;
        byte[] byArray = new byte[29];
        byArray[2] = 1;
        byArray[3] = 5;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[18] = 1;
        byArray[19] = 2;
        byArray[20] = 3;
        byArray[21] = 4;
        byArray[22] = 5;
        byArray[23] = 6;
        byArray[24] = 7;
        byArray[25] = 8;
        byArray[26] = 9;
        byArray[27] = 10;
        byArray[28] = 11;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[29];
        byArray3[0] = 1;
        byArray3[2] = 3;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArray3[7] = 1;
        byArray3[8] = 1;
        byArray3[9] = 1;
        byArray3[10] = 1;
        byArray3[11] = 1;
        byArray3[18] = 1;
        byArray3[19] = 2;
        byArray3[20] = 3;
        byArray3[21] = 4;
        byArray3[22] = 5;
        byArray3[23] = 6;
        byArray3[24] = 7;
        byArray3[25] = 8;
        byArray3[26] = 9;
        byArray3[27] = 10;
        byArray3[28] = 11;
        byte[] byArray4 = byArray3;
        byte[] byArray5 = new byte[179];
        byArray5[0] = 16;
        byArray5[2] = 2;
        byArray5[3] = 1;
        byArray5[4] = 3;
        byArray5[5] = 3;
        byArray5[6] = 2;
        byArray5[7] = 4;
        byArray5[8] = 3;
        byArray5[9] = 5;
        byArray5[10] = 5;
        byArray5[11] = 4;
        byArray5[12] = 4;
        byArray5[15] = 1;
        byArray5[16] = 125;
        byArray5[17] = 1;
        byArray5[18] = 2;
        byArray5[19] = 3;
        byArray5[21] = 4;
        byArray5[22] = 17;
        byArray5[23] = 5;
        byArray5[24] = 18;
        byArray5[25] = 33;
        byArray5[26] = 49;
        byArray5[27] = 65;
        byArray5[28] = 6;
        byArray5[29] = 19;
        byArray5[30] = 81;
        byArray5[31] = 97;
        byArray5[32] = 7;
        byArray5[33] = 34;
        byArray5[34] = 113;
        byArray5[35] = 20;
        byArray5[36] = 50;
        byArray5[37] = -127;
        byArray5[38] = -111;
        byArray5[39] = -95;
        byArray5[40] = 8;
        byArray5[41] = 35;
        byArray5[42] = 66;
        byArray5[43] = -79;
        byArray5[44] = -63;
        byArray5[45] = 21;
        byArray5[46] = 82;
        byArray5[47] = -47;
        byArray5[48] = -16;
        byArray5[49] = 36;
        byArray5[50] = 51;
        byArray5[51] = 98;
        byArray5[52] = 114;
        byArray5[53] = -126;
        byArray5[54] = 9;
        byArray5[55] = 10;
        byArray5[56] = 22;
        byArray5[57] = 23;
        byArray5[58] = 24;
        byArray5[59] = 25;
        byArray5[60] = 26;
        byArray5[61] = 37;
        byArray5[62] = 38;
        byArray5[63] = 39;
        byArray5[64] = 40;
        byArray5[65] = 41;
        byArray5[66] = 42;
        byArray5[67] = 52;
        byArray5[68] = 53;
        byArray5[69] = 54;
        byArray5[70] = 55;
        byArray5[71] = 56;
        byArray5[72] = 57;
        byArray5[73] = 58;
        byArray5[74] = 67;
        byArray5[75] = 68;
        byArray5[76] = 69;
        byArray5[77] = 70;
        byArray5[78] = 71;
        byArray5[79] = 72;
        byArray5[80] = 73;
        byArray5[81] = 74;
        byArray5[82] = 83;
        byArray5[83] = 84;
        byArray5[84] = 85;
        byArray5[85] = 86;
        byArray5[86] = 87;
        byArray5[87] = 88;
        byArray5[88] = 89;
        byArray5[89] = 90;
        byArray5[90] = 99;
        byArray5[91] = 100;
        byArray5[92] = 101;
        byArray5[93] = 102;
        byArray5[94] = 103;
        byArray5[95] = 104;
        byArray5[96] = 105;
        byArray5[97] = 106;
        byArray5[98] = 115;
        byArray5[99] = 116;
        byArray5[100] = 117;
        byArray5[101] = 118;
        byArray5[102] = 119;
        byArray5[103] = 120;
        byArray5[104] = 121;
        byArray5[105] = 122;
        byArray5[106] = -125;
        byArray5[107] = -124;
        byArray5[108] = -123;
        byArray5[109] = -122;
        byArray5[110] = -121;
        byArray5[111] = -120;
        byArray5[112] = -119;
        byArray5[113] = -118;
        byArray5[114] = -110;
        byArray5[115] = -109;
        byArray5[116] = -108;
        byArray5[117] = -107;
        byArray5[118] = -106;
        byArray5[119] = -105;
        byArray5[120] = -104;
        byArray5[121] = -103;
        byArray5[122] = -102;
        byArray5[123] = -94;
        byArray5[124] = -93;
        byArray5[125] = -92;
        byArray5[126] = -91;
        byArray5[127] = -90;
        byArray5[128] = -89;
        byArray5[129] = -88;
        byArray5[130] = -87;
        byArray5[131] = -86;
        byArray5[132] = -78;
        byArray5[133] = -77;
        byArray5[134] = -76;
        byArray5[135] = -75;
        byArray5[136] = -74;
        byArray5[137] = -73;
        byArray5[138] = -72;
        byArray5[139] = -71;
        byArray5[140] = -70;
        byArray5[141] = -62;
        byArray5[142] = -61;
        byArray5[143] = -60;
        byArray5[144] = -59;
        byArray5[145] = -58;
        byArray5[146] = -57;
        byArray5[147] = -56;
        byArray5[148] = -55;
        byArray5[149] = -54;
        byArray5[150] = -46;
        byArray5[151] = -45;
        byArray5[152] = -44;
        byArray5[153] = -43;
        byArray5[154] = -42;
        byArray5[155] = -41;
        byArray5[156] = -40;
        byArray5[157] = -39;
        byArray5[158] = -38;
        byArray5[159] = -31;
        byArray5[160] = -30;
        byArray5[161] = -29;
        byArray5[162] = -28;
        byArray5[163] = -27;
        byArray5[164] = -26;
        byArray5[165] = -25;
        byArray5[166] = -24;
        byArray5[167] = -23;
        byArray5[168] = -22;
        byArray5[169] = -15;
        byArray5[170] = -14;
        byArray5[171] = -13;
        byArray5[172] = -12;
        byArray5[173] = -11;
        byArray5[174] = -10;
        byArray5[175] = -9;
        byArray5[176] = -8;
        byArray5[177] = -7;
        byArray5[178] = -6;
        byte[] byArray6 = byArray5;
        byte[] byArray7 = new byte[179];
        byArray7[0] = 17;
        byArray7[2] = 2;
        byArray7[3] = 1;
        byArray7[4] = 2;
        byArray7[5] = 4;
        byArray7[6] = 4;
        byArray7[7] = 3;
        byArray7[8] = 4;
        byArray7[9] = 7;
        byArray7[10] = 5;
        byArray7[11] = 4;
        byArray7[12] = 4;
        byArray7[14] = 1;
        byArray7[15] = 2;
        byArray7[16] = 119;
        byArray7[18] = 1;
        byArray7[19] = 2;
        byArray7[20] = 3;
        byArray7[21] = 17;
        byArray7[22] = 4;
        byArray7[23] = 5;
        byArray7[24] = 33;
        byArray7[25] = 49;
        byArray7[26] = 6;
        byArray7[27] = 18;
        byArray7[28] = 65;
        byArray7[29] = 81;
        byArray7[30] = 7;
        byArray7[31] = 97;
        byArray7[32] = 113;
        byArray7[33] = 19;
        byArray7[34] = 34;
        byArray7[35] = 50;
        byArray7[36] = -127;
        byArray7[37] = 8;
        byArray7[38] = 20;
        byArray7[39] = 66;
        byArray7[40] = -111;
        byArray7[41] = -95;
        byArray7[42] = -79;
        byArray7[43] = -63;
        byArray7[44] = 9;
        byArray7[45] = 35;
        byArray7[46] = 51;
        byArray7[47] = 82;
        byArray7[48] = -16;
        byArray7[49] = 21;
        byArray7[50] = 98;
        byArray7[51] = 114;
        byArray7[52] = -47;
        byArray7[53] = 10;
        byArray7[54] = 22;
        byArray7[55] = 36;
        byArray7[56] = 52;
        byArray7[57] = -31;
        byArray7[58] = 37;
        byArray7[59] = -15;
        byArray7[60] = 23;
        byArray7[61] = 24;
        byArray7[62] = 25;
        byArray7[63] = 26;
        byArray7[64] = 38;
        byArray7[65] = 39;
        byArray7[66] = 40;
        byArray7[67] = 41;
        byArray7[68] = 42;
        byArray7[69] = 53;
        byArray7[70] = 54;
        byArray7[71] = 55;
        byArray7[72] = 56;
        byArray7[73] = 57;
        byArray7[74] = 58;
        byArray7[75] = 67;
        byArray7[76] = 68;
        byArray7[77] = 69;
        byArray7[78] = 70;
        byArray7[79] = 71;
        byArray7[80] = 72;
        byArray7[81] = 73;
        byArray7[82] = 74;
        byArray7[83] = 83;
        byArray7[84] = 84;
        byArray7[85] = 85;
        byArray7[86] = 86;
        byArray7[87] = 87;
        byArray7[88] = 88;
        byArray7[89] = 89;
        byArray7[90] = 90;
        byArray7[91] = 99;
        byArray7[92] = 100;
        byArray7[93] = 101;
        byArray7[94] = 102;
        byArray7[95] = 103;
        byArray7[96] = 104;
        byArray7[97] = 105;
        byArray7[98] = 106;
        byArray7[99] = 115;
        byArray7[100] = 116;
        byArray7[101] = 117;
        byArray7[102] = 118;
        byArray7[103] = 119;
        byArray7[104] = 120;
        byArray7[105] = 121;
        byArray7[106] = 122;
        byArray7[107] = -126;
        byArray7[108] = -125;
        byArray7[109] = -124;
        byArray7[110] = -123;
        byArray7[111] = -122;
        byArray7[112] = -121;
        byArray7[113] = -120;
        byArray7[114] = -119;
        byArray7[115] = -118;
        byArray7[116] = -110;
        byArray7[117] = -109;
        byArray7[118] = -108;
        byArray7[119] = -107;
        byArray7[120] = -106;
        byArray7[121] = -105;
        byArray7[122] = -104;
        byArray7[123] = -103;
        byArray7[124] = -102;
        byArray7[125] = -94;
        byArray7[126] = -93;
        byArray7[127] = -92;
        byArray7[128] = -91;
        byArray7[129] = -90;
        byArray7[130] = -89;
        byArray7[131] = -88;
        byArray7[132] = -87;
        byArray7[133] = -86;
        byArray7[134] = -78;
        byArray7[135] = -77;
        byArray7[136] = -76;
        byArray7[137] = -75;
        byArray7[138] = -74;
        byArray7[139] = -73;
        byArray7[140] = -72;
        byArray7[141] = -71;
        byArray7[142] = -70;
        byArray7[143] = -62;
        byArray7[144] = -61;
        byArray7[145] = -60;
        byArray7[146] = -59;
        byArray7[147] = -58;
        byArray7[148] = -57;
        byArray7[149] = -56;
        byArray7[150] = -55;
        byArray7[151] = -54;
        byArray7[152] = -46;
        byArray7[153] = -45;
        byArray7[154] = -44;
        byArray7[155] = -43;
        byArray7[156] = -42;
        byArray7[157] = -41;
        byArray7[158] = -40;
        byArray7[159] = -39;
        byArray7[160] = -38;
        byArray7[161] = -30;
        byArray7[162] = -29;
        byArray7[163] = -28;
        byArray7[164] = -27;
        byArray7[165] = -26;
        byArray7[166] = -25;
        byArray7[167] = -24;
        byArray7[168] = -23;
        byArray7[169] = -22;
        byArray7[170] = -14;
        byArray7[171] = -13;
        byArray7[172] = -12;
        byArray7[173] = -11;
        byArray7[174] = -10;
        byArray7[175] = -9;
        byArray7[176] = -8;
        byArray7[177] = -7;
        byArray7[178] = -6;
        byte[] byArray8 = byArray7;
        this.wShort(n);
        this.wShort(byArray2.length + byArray6.length + byArray4.length + byArray8.length + 2);
        this.wArray(byArray2);
        this.wArray(byArray6);
        this.wArray(byArray4);
        this.wArray(byArray8);
    }

    private void mDQT() throws IOException {
        int n = 65499;
        this.wShort(n);
        this.wShort(132);
        this.w(0);
        int n2 = 0;
        while (n2 < 64) {
            this.w(this.kYQuantumT[this.kZigzag[n2]] & 0xFF);
            ++n2;
        }
        this.w(1);
        n2 = 0;
        while (n2 < 64) {
            this.w(this.kCQuantumT[this.kZigzag[n2]] & 0xFF);
            ++n2;
        }
    }

    private void mMCU() throws IOException {
        try {
            int n = this.HV;
            int n2 = 8 * n;
            int[] nArray = new int[64];
            int[] nArray2 = new int[64];
            int[] nArray3 = new int[n2 * n2];
            int n3 = 0;
            while (n3 < this.height) {
                int n4 = 0;
                while (n4 < this.width) {
                    int n5 = 0;
                    while (n5 < n) {
                        int n6 = 0;
                        while (n6 < n) {
                            this.getYCC(nArray, nArray3, n4 + 8 * n6, n3 + 8 * n5, 1, 1, 0);
                            this.tDCT(nArray, nArray2);
                            this.tQuantization(nArray2, 0);
                            this.tHuffman(nArray2, 0);
                            ++n6;
                        }
                        ++n5;
                    }
                    this.getYCC(nArray, nArray3, n4, n3, this.HV, this.HV, 1);
                    this.tDCT(nArray, nArray2);
                    this.tQuantization(nArray2, 1);
                    this.tHuffman(nArray2, 1);
                    this.getYCC(nArray, nArray3, n4, n3, this.HV, this.HV, 2);
                    this.tDCT(nArray, nArray2);
                    this.tQuantization(nArray2, 2);
                    this.tHuffman(nArray2, 2);
                    n4 += n2;
                }
                n3 += n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void mSOF() throws IOException {
        int n = 65472;
        this.wShort(n);
        this.wShort(17);
        this.w(8);
        this.wShort(this.height);
        this.wShort(this.width);
        this.w(3);
        int n2 = 0;
        while (n2 < 3) {
            this.w(n2);
            int n3 = n2 == 0 ? this.HV : 1;
            this.w(n3 << 4 | n3);
            this.w(n2 == 0 ? 0 : 1);
            ++n2;
        }
    }

    private void mSOS() throws IOException {
        int n = 65498;
        this.wShort(n);
        this.wShort(12);
        this.w(3);
        int n2 = 0;
        while (n2 < 3) {
            this.w(n2);
            this.w(n2 == 0 ? 0 : 17);
            ++n2;
        }
        this.w(0);
        this.w(63);
        this.w(0);
    }

    private void q(int n) {
        byte[] byArray = new byte[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
        byte[] byArray2 = new byte[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        n = n < 1 ? 1 : (n > 100 ? 100 : n);
        this.HV = 1;
        if (n >= 25) {
            this.HV = 2;
        }
        float f = (float)n / 50.0f;
        float f2 = (float)n / 50.0f;
        int n2 = 0;
        while (n2 < 64) {
            this.kYQuantumT[n2] = Math.min(Math.max((int)((float)byArray[n2] * f), 1), 127);
            this.kCQuantumT[n2] = Math.min(Math.max((int)((float)byArray2[n2] * f2), 1), 127);
            ++n2;
        }
    }

    private void tDCT(int[] nArray, int[] nArray2) {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < 8) {
                double d = n3 > 0 ? 1.0 : this.kDisSqrt2;
                int n4 = 0;
                while (n4 < 8) {
                    double d2 = n4 > 0 ? 1.0 : this.kDisSqrt2;
                    double d3 = 0.0;
                    n2 = 0;
                    int n5 = 0;
                    while (n5 < 8) {
                        int n6 = 0;
                        while (n6 < 8) {
                            d3 += (double)nArray[n2++] * this.mCosT[n4][n6] * this.mCosT[n3][n5];
                            ++n6;
                        }
                        ++n5;
                    }
                    nArray2[n++] = (int)(d3 * d2 * d / 4.0);
                    ++n4;
                }
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tHuffman(int[] var1_1, int var2_2) throws IOException {
        try {
            if (var2_2 == 0) {
                var4_3 = this.kYAcSizeT;
                var6_4 = this.kYAcCodeT;
                var3_5 = this.kYDcSizeT;
                var5_7 = this.kYDcCodeT;
                var7_8 = this.kYEOBidx;
                var8_9 = this.kYZRLidx;
            } else {
                var4_3 = this.kCAcSizeT;
                var6_4 = this.kCAcCodeT;
                var3_5 = this.kCDcSizeT;
                var5_7 = this.kCDcCodeT;
                var7_8 = this.kCEOBidx;
                var8_9 = this.kCZRLidx;
            }
            var9_10 = var1_1[0] - this.mOldDC[var2_2];
            this.mOldDC[var2_2] = var1_1[0];
            var10_11 = Math.abs(var9_10);
            var11_12 = 0;
            while (var10_11 > 0) {
                var10_11 >>= 1;
                var11_12 = (byte)(var11_12 + 1);
            }
            this.wBit(var5_7[var11_12], var3_5[var11_12]);
            if (var11_12 != 0) {
                if (var9_10 < 0) {
                    --var9_10;
                }
                this.wBit(var9_10, var11_12);
            }
            var12_13 = 0;
            var13_14 = 1;
            while (var13_14 < 64) {
                block12: {
                    var10_11 = Math.abs(var1_1[this.kZigzag[var13_14]]);
                    if (var10_11 != 0) ** GOTO lbl38
                    ++var12_13;
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        this.wBit(var6_4[var8_9], var4_3[var8_9]);
                        var12_13 -= 16;
lbl38:
                        // 2 sources

                        ** while (var12_13 > 15)
                    }
lbl39:
                    // 1 sources

                    var11_12 = 0;
                    while (var10_11 > 0) {
                        var10_11 >>= 1;
                        var11_12 = (byte)(var11_12 + 1);
                    }
                    var14_15 = var12_13 * 10 + var11_12 + (var12_13 == 15 ? 1 : 0);
                    this.wBit(var6_4[var14_15], var4_3[var14_15]);
                    var9_10 = var1_1[this.kZigzag[var13_14]];
                    if (var9_10 < 0) {
                        --var9_10;
                    }
                    this.wBit(var9_10, var11_12);
                    var12_13 = 0;
                }
                ++var13_14;
            }
            if (var12_13 > 0) {
                this.wBit(var6_4[var7_8], var4_3[var7_8]);
            }
        }
        catch (Throwable var3_6) {
            var3_6.printStackTrace();
        }
    }

    private void tQuantization(int[] nArray, int n) {
        int[] nArray2 = n == 0 ? this.kYQuantumT : this.kCQuantumT;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2;
            nArray[n3] = nArray[n3] / nArray2[n2];
            ++n2;
        }
    }

    private void w(int n) throws IOException {
        this.wFullBit();
        this.OUT.write(n);
    }

    private void wArray(byte[] byArray) throws IOException {
        this.wFullBit();
        int n = 0;
        while (n < byArray.length) {
            this.w(byArray[n] & 0xFF);
            ++n;
        }
    }

    private void wArray(int[] nArray) throws IOException {
        this.wFullBit();
        int n = 0;
        while (n < nArray.length) {
            this.w(nArray[n] & 0xFF);
            ++n;
        }
    }

    private void wBit(int n, byte by) throws IOException {
        byte by2 = by = (byte)(by - 1);
        while (by2 >= 0) {
            int n2 = n >>> by2 & 1;
            this.bitValue |= n2 << this.bitSeek;
            if (--this.bitSeek <= -1) {
                this.OUT.write(this.bitValue);
                if (this.bitValue == 255) {
                    this.OUT.write(0);
                }
                this.bitValue = 0;
                this.bitSeek = 7;
            }
            by2 = (byte)(by2 - 1);
        }
    }

    private void wFullBit() throws IOException {
        if (this.bitSeek != 7) {
            this.wBit(255, (byte)(this.bitSeek + 1));
            this.bitValue = 0;
            this.bitSeek = 7;
        }
    }

    private void wShort(int n) throws IOException {
        this.wFullBit();
        this.OUT.write(n >>> 8 & 0xFF);
        this.OUT.write(n & 0xFF);
    }

    private void ycc(int[] nArray, int n) {
        int n2 = n >>> 16 & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n & 0xFF;
        nArray[0] = (int)(0.299f * (float)n2 + 0.587f * (float)n3 + 0.114f * (float)n4 - 128.0f);
        nArray[1] = (int)(-(0.1687f * (float)n2) - 0.3313f * (float)n3 + 0.5f * (float)n4);
        nArray[2] = (int)(0.5f * (float)n2 - 0.4187f * (float)n3 - 0.0813f * (float)n4);
    }
}

