/*
 * Decompiled with CFR 0.152.
 */
package syi.awt;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import syi.awt.Awt;

public abstract class LComponent
extends Canvas {
    protected static boolean isWin;
    private String title = null;
    public boolean isUpDown = false;
    public boolean isGUI = true;
    public boolean isHide = true;
    public boolean isEscape = false;
    public boolean isBar = false;
    protected boolean isFrame = true;
    protected boolean isPaint = true;
    protected boolean isRepaint = true;
    private Rectangle rEscape = null;
    private Dimension dSize = null;
    private Dimension dVisit = null;
    private Dimension dS = null;
    private Dimension dM = null;
    private Dimension dL = null;
    private Point pLocation = null;
    private boolean isMove = false;
    private boolean isResize = false;
    private int oldX = 0;
    private int oldY = 0;
    private int countResize = 0;
    public Color clFrame;
    public Color clLBar;
    public Color clBar;
    public Color clBarT;
    protected int iBSize;
    protected int iGap;
    private static Font fontBar;
    public static float Q;

    static {
        fontBar = null;
    }

    public LComponent() {
        if (Q == 0.0f) {
            this.setup();
        }
        this.iGap = Math.max((int)(4.0f * Q), 1);
        this.iBSize = Math.max((int)(12.0f * Q), 7);
        this.isRepaint = !isWin;
        Awt.getDef(this);
        this.clFrame = Awt.cF;
        this.enableEvents(57L);
    }

    public void escape(boolean bl) {
        if (this.isEscape == bl) {
            return;
        }
        this.isEscape = bl;
        if (bl) {
            this.rEscape = new Rectangle(this.getBounds());
            this.setBounds(0, 0, 1, 1);
        } else if (this.rEscape != null) {
            this.setBounds(this.rEscape);
            this.rEscape = null;
        }
    }

    private Cursor getCur(int n, int n2) {
        int n3;
        switch (this.inCorner(n, n2)) {
            case 1: {
                n3 = 6;
                break;
            }
            case 2: {
                n3 = 7;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 4: {
                n3 = 5;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return Cursor.getPredefinedCursor(n3);
    }

    public Graphics getG() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return null;
        }
        graphics.translate(this.getGapX(), this.getGapY());
        Dimension dimension = this.getSize();
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        return graphics;
    }

    public int getGapH() {
        return this.getGapY() + this.iGap;
    }

    public int getGapW() {
        return this.iGap * 2;
    }

    public int getGapX() {
        return this.iGap;
    }

    public int getGapY() {
        return this.iGap + (this.isGUI ? this.iBSize : 0);
    }

    public Point getLocation() {
        if (this.pLocation == null) {
            this.pLocation = super.getLocation();
        }
        return this.pLocation;
    }

    public Dimension getMaximumSize() {
        return this.dL == null ? this.getSize() : this.dL;
    }

    public Dimension getMinimumSize() {
        return this.dS == null ? this.getSize() : this.dS;
    }

    public Dimension getPreferredSize() {
        return this.dM == null ? this.getSize() : this.dM;
    }

    public Dimension getSize() {
        if (this.dVisit == null) {
            this.dVisit = new Dimension();
        }
        this.dVisit.setSize(this.getSizeW());
        this.dVisit.width -= this.getGapW();
        this.dVisit.height -= this.getGapH();
        return this.dVisit;
    }

    public Dimension getSizeW() {
        if (this.dSize == null) {
            this.dSize = super.getSize();
        }
        return this.dSize;
    }

    private int inCorner(int n, int n2) {
        Dimension dimension = this.getSizeW();
        int n3 = 0;
        int n4 = this.iGap;
        if (n2 <= n4) {
            if (n <= n4) {
                n3 = 1;
            }
            if (n >= dimension.width - n4 - 1) {
                n3 = 2;
            }
        } else if (n2 >= dimension.height - n4 - 1) {
            if (n <= n4) {
                n3 = 3;
            }
            if (n >= dimension.width - n4 - 1) {
                n3 = 4;
            }
        }
        return n3;
    }

    public void inParent() {
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        Point point = this.getLocation();
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.getSizeW();
        this.getMinimumSize();
        int n = point.x;
        int n2 = point.y;
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        if (dimension.width <= 10 || dimension.height <= 10) {
            return;
        }
        n = n <= 0 ? 0 : (n + n3 >= dimension.width ? dimension.width - n3 : n);
        int n5 = n = n <= 0 ? 0 : n;
        n2 = n2 <= 0 ? 0 : (n2 + n4 >= dimension.height ? dimension.height - n4 : n2);
        int n6 = n2 = n2 <= 0 ? 0 : n2;
        if (n != point.x || n2 != point.y) {
            this.setLocation(n, n2);
        }
        n3 = Math.min(n3, dimension.width);
        n4 = Math.min(n4, dimension.height);
        if (n3 != dimension2.width || n4 != dimension2.height) {
            this.setSize(n3 - this.getGapW(), n4 - this.getGapH());
        }
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Dimension dimension = this.getSizeW();
        if (!this.isPaint && this.isMove) {
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            return;
        }
        int n = this.iBSize;
        int n2 = this.iGap;
        int cfr_ignored_0 = n2 * 2;
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (this.isFrame) {
            graphics.setColor(this.clFrame);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
        }
        if (this.isGUI) {
            graphics.fillRect(1, n, n3 - 2, 1);
            graphics.fillRect(n3 - n - 1, 1, 1, n - 1);
            graphics.setColor(this.clLBar);
            graphics.fillRect(1, 1, n3 - 2, 1);
            graphics.setColor(this.clBar);
            graphics.fillRect(1, 2, n3 - 2 - this.iBSize, this.iBSize - 2);
            graphics.drawLine(n3 - n + 1, 2, n3 - 2, n - 1);
            graphics.drawLine(n3 - n + 1, n - 1, n3 - 2, 1);
            if (this.title != null && this.title.length() > 0) {
                graphics.setClip(1, 1, n3 - 1 - this.iBSize, this.iBSize - 1);
                graphics.setFont(fontBar);
                graphics.setColor(this.clBarT);
                graphics.drawString(this.title, n2, n - 1);
                graphics.setClip(0, 0, dimension.width, dimension.height);
            }
        }
        int n5 = this.getGapX();
        int n6 = this.getGapY();
        graphics.translate(n5, n6);
        try {
            this.paint2(graphics);
        }
        catch (Throwable throwable) {}
        graphics.translate(-n5, -n6);
    }

    public abstract void paint2(Graphics var1);

    public abstract void pMouse(MouseEvent var1);

    protected void processEvent(AWTEvent aWTEvent) {
        try {
            int n;
            int n2;
            int n3 = aWTEvent.getID();
            Dimension dimension = this.getSizeW();
            Point point = this.getLocation();
            switch (n3) {
                case 101: {
                    dimension.setSize(super.getSize());
                    int n4 = dimension.width;
                    n2 = dimension.height;
                    this.inParent();
                    if (!this.isRepaint) break;
                    this.getParent().repaint(0L, point.x, point.y, n4, n2);
                    break;
                }
                case 100: {
                    point.setLocation(super.getLocation());
                    n = point.x;
                    int n5 = point.y;
                    this.inParent();
                    if (!this.isRepaint) break;
                    this.getParent().repaint(0L, n, n5, dimension.width, dimension.height);
                }
            }
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                mouseEvent.consume();
                n2 = mouseEvent.getX();
                n = mouseEvent.getY();
                if (this.isGUI) {
                    Serializable serializable;
                    Serializable serializable2;
                    dimension = this.getSizeW();
                    Dimension dimension2 = this.getSize();
                    int n6 = dimension2.width;
                    int n7 = dimension2.height;
                    int cfr_ignored_0 = this.iGap * 2;
                    boolean bl = false;
                    switch (mouseEvent.getID()) {
                        case 503: {
                            if (!this.getCursor().equals(this.getCur(n2, n))) {
                                this.setCursor(this.getCur(n2, n));
                            }
                            if (!this.isUpDown || ((Container)(serializable2 = this.getParent())).getComponent(0) == this) break;
                            ((Container)serializable2).remove(this);
                            ((Container)serializable2).add((Component)this, 0);
                            break;
                        }
                        case 501: {
                            this.oldX = n2;
                            this.oldY = n;
                            int n8 = this.inCorner(n2, n);
                            if (n8 != 0) {
                                this.isMove = true;
                                this.isResize = true;
                                this.isPaint = false;
                                this.countResize = 0;
                                return;
                            }
                            serializable = this.getParent();
                            if (n > this.iBSize) break;
                            if (n2 >= dimension.width - this.iBSize) {
                                if (this.isHide) {
                                    ((Container)serializable).remove(this);
                                }
                                return;
                            }
                            if (mouseEvent.getClickCount() % 2 == 0) {
                                Dimension dimension3 = this.getMaximumSize();
                                Dimension dimension4 = this.getMinimumSize();
                                Dimension dimension5 = ((Component)serializable).getSize();
                                int n9 = Math.min(dimension3.width, dimension5.width - this.getGapW());
                                int n10 = Math.min(dimension3.height, dimension5.height - this.getGapH());
                                if (n6 >= n9 && n7 >= n10) {
                                    this.setSize(this.getPreferredSize());
                                } else {
                                    if (n6 <= dimension4.width && n7 >= n10) {
                                        n10 = dimension4.height;
                                    } else if (n7 <= dimension4.height && n6 >= n9) {
                                        n9 = dimension4.width;
                                    }
                                    this.setSize(n9, n10);
                                }
                                return;
                            }
                            this.isMove = true;
                            this.isResize = false;
                            this.isPaint = false;
                            return;
                        }
                        case 506: {
                            if (!this.isMove || ++this.countResize < 4) break;
                            bl = true;
                            this.countResize = 0;
                            break;
                        }
                        case 502: {
                            if (!this.isMove) break;
                            this.isMove = false;
                            bl = true;
                            this.isPaint = true;
                        }
                    }
                    if (bl) {
                        serializable2 = this.getLocation();
                        int cfr_ignored_1 = ((Point)serializable2).x;
                        int cfr_ignored_2 = ((Point)serializable2).y;
                        int cfr_ignored_3 = dimension2.width;
                        int cfr_ignored_4 = dimension2.height;
                        if (this.isResize) {
                            serializable = this.dL;
                            Dimension dimension6 = this.dS;
                            int n11 = dimension2.width + (n2 - this.oldX);
                            int n12 = dimension2.height + (n - this.oldY);
                            this.setSize(n11 < dimension6.width ? dimension6.width : (n11 > ((Dimension)serializable).width ? ((Dimension)serializable).width : n11), n12 < dimension6.height ? dimension6.height : (n12 > ((Dimension)serializable).height ? ((Dimension)serializable).height : n12));
                            this.oldX = n2;
                            this.oldY = n;
                        } else {
                            serializable = this.getLocation();
                            Dimension dimension7 = this.getParent().getSize();
                            n2 = (n2 = ((Point)serializable).x + n2 - this.oldX) <= 0 ? 0 : (n2 + dimension.width >= dimension7.width ? dimension7.width - dimension.width : n2);
                            n = ((Point)serializable).y + n - this.oldY;
                            n = n <= 0 ? 0 : (n + dimension.height >= dimension7.height ? dimension7.height - dimension.height : n);
                            this.setLocation(n2, n);
                        }
                        if (this.isPaint) {
                            this.repaint();
                        }
                    }
                }
                n2 = this.getGapX();
                n = this.getGapY();
                if (!this.isMove) {
                    mouseEvent.translatePoint(-n2, -n);
                    this.pMouse(mouseEvent);
                    mouseEvent.translatePoint(n2, n);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {}
    }

    public void setDimension(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        Dimension dimension4 = dimension2 = dimension2 == null ? this.getSize() : dimension2;
        Dimension dimension5 = dimension == null ? (this.dS == null ? new Dimension() : this.dS) : (this.dS = dimension);
        this.dL = dimension3 == null ? (this.dL == null ? new Dimension(9999, 9999) : this.dL) : dimension3;
        this.dM = new Dimension(dimension2);
        this.setSize(dimension2.width, dimension2.height);
    }

    public void setLocation(int n, int n2) {
        this.getLocation().setLocation(n, n2);
        super.setLocation(n, n2);
    }

    public void setSize(int n, int n2) {
        Dimension dimension = this.getMaximumSize();
        Dimension dimension2 = this.getMinimumSize();
        int n3 = n > dimension.width ? dimension.width : (n = n < dimension2.width ? dimension2.width : n);
        n2 = n2 > dimension.height ? dimension.height : (n2 < dimension2.height ? dimension2.height : n2);
        Dimension dimension3 = this.getSize();
        if (dimension3.width == n && dimension3.height == n2) {
            return;
        }
        this.getSizeW().setSize(n += this.getGapW(), n2 += this.getGapH());
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    private void setup() {
        isWin = Awt.isWin();
        this.clFrame = Color.black;
        this.clBar = new Color(0x5555FF);
        this.clLBar = this.clBar.brighter();
        this.clBarT = Color.white;
        Q = Awt.q();
        fontBar = new Font("sansserif", 0, (int)(10.0f * Q));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

