/*
 * Decompiled with CFR 0.152.
 */
package syi.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import syi.awt.LComponent;

public class Awt {
    public static Frame main_frame = null;
    public static Color cC;
    public static Color cDk;
    public static Color cLt;
    public static Color cBk;
    public static Color cFore;
    public static Color cF;
    public static Color cFSel;
    public static Color clBar;
    public static Color clLBar;
    public static Color clBarT;
    private static Font fontDef;
    private static float Q;
    private static MediaTracker mt;

    static {
        fontDef = null;
        Q = 0.0f;
        mt = null;
    }

    public static final void drawFrame(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
        Awt.setup();
        Awt.drawFrame(graphics, bl, n, n2, n3, n4, cDk, cLt);
    }

    public static final void drawFrame(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, Color color, Color color2) {
        Awt.setup();
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(color == null ? cDk : color);
        graphics.fillRect(n, n2, n3, 1);
        graphics.fillRect(n, n2 + 1, 1, n4 - 2);
        graphics.fillRect(n + 2, n6 - 2, n3 - 2, 1);
        graphics.fillRect(n5 - 1, n2 + 2, 1, n4 - 4);
        graphics.setColor(color2 == null ? cLt : color2);
        if (!bl) {
            graphics.fillRect(n + 1, n2 + 1, n3 - 2, 1);
            graphics.fillRect(n + 1, n2 + 2, 1, n4 - 4);
        }
        graphics.fillRect(n + 1, n6 - 1, n3 - 1, 1);
        graphics.fillRect(n5, n2 + 1, 1, n4 - 2);
    }

    public static final void fillFrame(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
        Awt.fillFrame(graphics, bl, n, n2, n3, n4, cC, cDk, cDk, cLt);
    }

    public static final void fillFrame(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Awt.drawFrame(graphics, bl, n, n2, n3, n4, color3, color4);
        graphics.setColor(bl ? (color2 == null ? cDk : color2) : (color == null ? cC : color));
        graphics.fillRect(n + 2, n2 + 2, n3 - 3, n4 - 4);
    }

    public static void getDef(Component component) {
        Awt.setup();
        component.setBackground(cBk);
        component.setForeground(cFore);
        component.setFont(Awt.getDefFont());
        if (component instanceof LComponent) {
            LComponent lComponent = (LComponent)component;
            lComponent.clBar = clBar;
            lComponent.clLBar = clLBar;
            lComponent.clBarT = clBarT;
            lComponent.clFrame = cF;
        }
    }

    public static Font getDefFont() {
        if (fontDef == null) {
            fontDef = new Font("sansserif", 0, (int)(15.0f * Awt.q()));
        }
        return fontDef;
    }

    public static Component getParent(Component component) {
        Container container = component.getParent();
        return container == null ? component : (container instanceof Window ? container : Awt.getParent(container));
    }

    public static Frame getPFrame() {
        if (main_frame == null) {
            main_frame = new Frame();
        }
        return main_frame;
    }

    public static boolean isR(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown() || mouseEvent.isControlDown() || (mouseEvent.getModifiers() & 4) != 0;
    }

    public static boolean isWin() {
        String string = "Win";
        return System.getProperty("os.name", string).startsWith(string);
    }

    public static void moveCenter(Window window) {
        Dimension dimension = window.getToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        ((Component)window).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
    }

    public static InputStream openStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(true);
        return uRLConnection.getInputStream();
    }

    public static float q() {
        if (Q == 0.0f) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 2264;
            int n2 = dimension.width + dimension.height;
            Q = Math.min(1.0f + (float)(n2 - n) / (float)n / 2.0f, 2.0f);
        }
        return Q;
    }

    public static String replaceText(String string, String string2, String string3) {
        if (string.indexOf(string3) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char[] cArray = string3.toCharArray();
            if (cArray.length <= 0) {
                return string;
            }
            int n = 0;
            int n2 = 0;
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n4);
                if (c == cArray[n2]) {
                    if (n2 == 0) {
                        n = n4;
                    }
                    if (++n2 >= cArray.length) {
                        n2 = 0;
                        stringBuffer.append(string2);
                    }
                } else {
                    if (n2 > 0) {
                        int n5 = 0;
                        while (n5 < n2) {
                            stringBuffer.append(string.charAt(n + n5));
                            ++n5;
                        }
                        n2 = 0;
                    }
                    stringBuffer.append(c);
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println("replace" + runtimeException);
        }
        return stringBuffer.toString();
    }

    public static void setDef(Component component, boolean bl) {
        try {
            Component[] componentArray;
            if (!bl) {
                bl = true;
            } else {
                componentArray = component.getParent();
                componentArray.setFont(componentArray.getFont());
                componentArray.setForeground(componentArray.getForeground());
                componentArray.setBackground(componentArray.getBackground());
            }
            if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
                int n = 0;
                while (n < componentArray.length) {
                    component = componentArray[n];
                    Awt.setDef(component, true);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setPFrame(Frame frame) {
        main_frame = frame;
    }

    public static final void setup() {
        if (cC == null) {
            cC = new Color(0xCDCDCD);
            cLt = null;
            cDk = null;
        }
        if (cDk == null) {
            cDk = cC.darker();
        }
        if (cLt == null) {
            cLt = cC.brighter();
        }
        if (cBk == null) {
            cBk = new Color(0xCFCFFF);
        }
        if (cFore == null) {
            cFore = new Color(5263480);
        }
        if (cF == null) {
            cF = cFore;
        }
        if (cFSel == null) {
            cFSel = new Color(0xEE3333);
        }
        if (clBar == null) {
            clBar = new Color(0x6666FF);
        }
        if (clLBar == null) {
            clLBar = new Color(0x8888FF);
        }
        if (clBarT == null) {
            clBarT = Color.white;
        }
    }

    public static Image toMin(Image image, int n, int n2) {
        Image image2 = image.getScaledInstance(n, n2, 16);
        image.flush();
        Awt.wait(image2);
        return image2;
    }

    public static String trimString(String string, String string2, String string3) {
        if (string == null || string.length() <= 0 || string2 == null || string3 == null) {
            return "";
        }
        try {
            int n = string.indexOf(string2);
            if (n == -1) {
                return "";
            }
            int n2 = string.indexOf(string3, n + string2.length());
            if (n2 == -1) {
                n2 = string.length() - 1;
            }
            return string.substring(n + string2.length(), n2);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("t_trimString:" + runtimeException.toString());
            return "";
        }
    }

    public static int[] getPix(Image image) {
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), true);
            pixelGrabber.grabPixels();
            return (int[])pixelGrabber.getPixels();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void wait(Image image) {
        if (mt == null) {
            mt = new MediaTracker(Awt.getPFrame());
        }
        try {
            mt.addImage(image, 0);
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        mt.removeImage(image, 0);
    }
}

