/*
 * Decompiled with CFR 0.152.
 */
package paintchat.pro;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.StringReader;
import paintchat.M;
import paintchat.Res;
import paintchat.pro.Tools;
import syi.awt.Awt;
import syi.awt.LComponent;

public class TPalette
extends LComponent {
    private int lenColor = 255;
    private int iDrag = -1;
    private M.Info info;
    private M mg;
    private Tools tools;
    private Res res;
    private Res config;
    private int sizePalette = 20;
    private int selPalette = 0;
    private int oldColor = 0;
    private Color[] cls;
    private int isRGB = 1;
    private float[] fhsb = new float[3];
    private int iColor;
    private static Font clFont = null;
    private static final char[][] clValue = new char[][]{{'H', 'S', 'B', 'A'}, {'R', 'G', 'B', 'A'}};
    private static Color[][] clRGB = null;
    private static int[] DEFC;

    static {
        int[] nArray = new int[20];
        nArray[1] = 0xFFFFFF;
        nArray[2] = 11826549;
        nArray[3] = 0x888888;
        nArray[4] = 16422550;
        nArray[5] = 12621504;
        nArray[6] = 0xFFB6FF;
        nArray[7] = 0x8080FF;
        nArray[8] = 2475977;
        nArray[9] = 15197581;
        nArray[10] = 15177261;
        nArray[11] = 10079099;
        nArray[12] = 16575714;
        nArray[13] = 16375247;
        nArray[14] = 0xFFFFFF;
        nArray[15] = 0xFFFFFF;
        nArray[16] = 0xFFFFFF;
        nArray[17] = 0xFFFFFF;
        nArray[18] = 0xFFFFFF;
        nArray[19] = 0xFFFFFF;
        DEFC = nArray;
    }

    public TPalette() {
        if (clRGB == null) {
            clRGB = new Color[][]{{Color.magenta, Color.cyan, Color.white, Color.lightGray}, {new Color(16422550), new Color(8581688), new Color(0x8080FF), Color.lightGray}};
        }
    }

    public void changeRH() {
        int n = this.getRGB();
        this.isRGB = this.isRGB == 0 ? 1 : 0;
        this.setColor(n);
    }

    public String getC() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.cls.length) {
                if (n != 0) {
                    stringBuffer.append('\n');
                }
                int n2 = this.cls[n].getRGB();
                stringBuffer.append("#" + Integer.toHexString(0xFF000000 | n2 & 0xFFFFFF).substring(2).toUpperCase());
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getRGB() {
        return this.isRGB == 1 ? this.iColor : Color.HSBtoRGB((float)(this.iColor >>> 16 & 0xFF) / 255.0f, (float)(this.iColor >>> 8 & 0xFF) / 255.0f, (float)(this.iColor & 0xFF) / 255.0f) & 0xFFFFFF;
    }

    public void init(Tools tools, M.Info info, Res res, Res res2) {
        this.info = info;
        this.mg = info.m;
        this.res = res2;
        this.config = res;
        this.tools = tools;
        this.setDimension(new Dimension((int)(42.0f * LComponent.Q), (int)(42.0f * LComponent.Q)), new Dimension((int)(112.0f * LComponent.Q), (int)(202.0f * LComponent.Q)), new Dimension((int)(300.0f * LComponent.Q), (int)(300.0f * LComponent.Q)));
    }

    public void paint2(Graphics graphics) {
        try {
            this.initP();
            Dimension dimension = this.getSize();
            int n = Math.min((dimension.height - 1) / 10, 64);
            int n2 = (int)((float)n * 1.5f);
            int n3 = n <= 12 ? 0 : 2;
            int n4 = this.cls.length;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n4) {
                graphics.setColor(this.cls[n7]);
                graphics.fillRect(n5 + 1, n6 + 1, n2 - 1 - n3, n - 1 - n3);
                graphics.setColor(Awt.cF);
                graphics.drawRect(n5, n6, n2 - n3, n - n3);
                if (this.selPalette == n7) {
                    graphics.setColor(Awt.cFSel);
                    graphics.drawRect(n5 + 1, n6 + 1, n2 - n3 - 2, n - n3 - 2);
                }
                if (n5 == 0) {
                    n5 += n2;
                } else {
                    n5 = 0;
                    n6 += n;
                }
                ++n7;
            }
            n7 = n2 * 2;
            n6 = this.pBar(graphics, n7, 0, n);
            graphics.setColor(this.getBackground());
            graphics.fillRect(n5 + n7, n6, dimension.width - n7, dimension.height - n6);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private int pBar(Graphics graphics, int n, int n2, int n3) {
        Dimension dimension = this.getSize();
        int n4 = dimension.width - n - 1;
        int cfr_ignored_0 = dimension.height - n2;
        Color color = this.getBackground();
        Color color2 = Awt.cFore;
        boolean bl = this.mg.isText();
        int n5 = bl ? 255 : this.info.getPenMask()[this.mg.iPenM].length;
        int n6 = Math.min(n3 * 6, n5 * 8 + 1);
        int n7 = this.mg.iSize;
        this.mg.iSize = n7 = n7 <= 0 ? 0 : (n7 >= n5 ? n5 - 1 : n7);
        String string = bl ? String.valueOf(this.mg.iSize) + "pt" : String.valueOf((int)Math.sqrt(this.info.getPenMask()[this.mg.iPenM][this.mg.iSize].length)) + "px";
        graphics.setColor(Awt.cF);
        graphics.drawRect(n, n2, n4, n6);
        int n8 = (int)((float)n6 * ((float)(n7 + 1) / (float)n5));
        graphics.setColor(this.cls[this.selPalette]);
        graphics.fillRect(n + 1, n2 + 1, n4 - 1, n8 - 1);
        graphics.setColor(color);
        graphics.fillRect(n + 1, n2 + 1 + n8, n4 - 1, n6 - n8 - 1);
        graphics.setColor(color2);
        graphics.setFont(Awt.getDefFont());
        graphics.setXORMode(color);
        graphics.drawString(string, n + 2, n2 + n6 - 2);
        graphics.setPaintMode();
        if (clFont == null || clFont.getSize() != Math.max(n3 - 2, 1)) {
            clFont = new Font("sansserif", 0, Math.max(n3 - 4, 1));
        }
        graphics.setFont(clFont);
        int n9 = this.iColor << 8 | this.mg.iAlpha;
        int n10 = 24;
        n2 += n6;
        int n11 = 0;
        while (n11 < 4) {
            graphics.setColor(Awt.cF);
            graphics.drawRect(n, n2 + 1, n4, n3 - 2);
            graphics.setColor(Color.white);
            graphics.fillRect(n + 1, n2 + 2, n4 - 1, 1);
            graphics.fillRect(n + 1, n2 + 3, 1, n3 - 4);
            n8 = (int)((float)(n4 - 2) * ((float)(n9 >>> n10 & 0xFF) / 255.0f));
            graphics.setColor(clRGB[this.isRGB][n11]);
            graphics.fillRect(n + 2, n2 + 3, n8, n3 - 4);
            graphics.setColor(Color.gray);
            graphics.fillRect(n + 1 + n8, n2 + 3, 1, n3 - 4);
            graphics.setColor(color);
            graphics.fillRect(n + 2 + n8, n2 + 3, n4 - n8 - 2, n3 - 4);
            graphics.setColor(color2);
            graphics.drawString(String.valueOf(String.valueOf(clValue[this.isRGB][n11])) + (n9 >>> n10 & 0xFF), n + 2, n2 + n3 - 2);
            n2 += n3;
            n10 -= 8;
            ++n11;
        }
        return n2;
    }

    public void pMouse(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Dimension dimension = this.getSize();
        int n4 = (dimension.height - 1) / 10;
        int n5 = (int)((float)n4 * 1.5f);
        int n6 = n5 * 2 + 1;
        boolean bl = Awt.isR(mouseEvent);
        boolean bl2 = this.mg.isText();
        int n7 = bl2 ? 255 : this.info.getPenMask()[this.mg.iPenM].length;
        int n8 = Math.min(n4 * 6, n7 * 8 + 1);
        if (n2 <= n6 && n == 501) {
            this.iDrag = -1;
            int n9 = Math.min(n3 / n4 * 2 + n2 / n5, 19);
            if (bl) {
                this.cls[n9] = new Color(this.mg.iColor);
            } else if (mouseEvent.isShiftDown()) {
                this.cls[n9] = new Color(DEFC[n9]);
            } else {
                this.selPalette = n9;
                this.tools.setRGB(this.cls[n9].getRGB());
            }
            this.repaint();
            return;
        }
        boolean bl3 = false;
        switch (n) {
            case 501: {
                if (n3 < n8) {
                    if (bl) {
                        this.tools.setField(this, "iPenM", "penm_", n2, n3);
                        return;
                    }
                    this.iDrag = 0;
                } else {
                    if (bl) {
                        this.changeRH();
                        return;
                    }
                    this.iDrag = (n3 - n8) / n4;
                    this.iDrag = (this.iDrag <= 0 ? 0 : (this.iDrag >= 3 ? 3 : this.iDrag)) + 1;
                }
                bl3 = true;
                break;
            }
            case 502: {
                this.iDrag = -1;
                break;
            }
            case 506: {
                if (this.iDrag < 0) break;
                bl3 = true;
            }
        }
        if (bl3) {
            if (this.iDrag == 0) {
                this.setLineSize((int)((float)n3 / (float)n8 * (float)n7));
            } else {
                int n10 = (int)((float)(n2 - n6) / (float)(dimension.width - n6) * 255.0f);
                int n11 = 24 - 8 * (this.iDrag - 1);
                int n12 = this.iColor << 8 | this.mg.iAlpha;
                n12 = n12 & (0xFFFFFFFF ^ 255 << n11) | Math.max(Math.min(n10, 255), 0) << n11;
                this.iColor = n12 >>> 8;
                this.mg.iAlpha = Math.max(n12 & 0xFF, 1);
                n12 = this.iColor;
                this.tools.setRGB(this.getRGB());
                boolean bl4 = this.iColor == n12;
                this.iColor = n12;
                if (bl4) {
                    this.repaint();
                }
            }
        }
    }

    public void setC(String string) {
        try {
            this.initP();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (n < this.cls.length) {
                    this.cls[n] = Color.decode(string);
                }
                if (n >= DEFC.length) continue;
                TPalette.DEFC[n++] = this.cls[n].getRGB() & 0xFFFFFF;
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setColor(int n) {
        boolean bl;
        boolean bl2 = bl = this.getRGB() != (n &= 0xFFFFFF);
        if (this.isRGB == 1) {
            this.iColor = n;
        } else {
            Color.RGBtoHSB(n >>> 16, n >>> 8 & 0xFF, n & 0xFF, this.fhsb);
            this.iColor = (int)(this.fhsb[0] * 255.0f) << 16 | (int)(this.fhsb[1] * 255.0f) << 8 | (int)(this.fhsb[2] * 255.0f);
        }
        if ((this.cls[this.selPalette].getRGB() & 0xFFFFFF) != n) {
            this.cls[this.selPalette] = new Color(this.mg.iColor);
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    public void setLineSize(int n) {
        int n2 = this.mg.isText() ? 255 : this.info.getPenMask()[this.mg.iPenM].length;
        int n3 = this.mg.iSize;
        this.mg.iSize = Math.min(Math.max(0, n), n2);
        if (n3 != this.mg.iSize) {
            this.repaint();
            this.tools.tP.repaint();
        }
    }

    private void initP() {
        if (this.cls != null) {
            return;
        }
        this.cls = new Color[this.sizePalette];
        int n = 0;
        while (n < this.sizePalette) {
            this.cls[n] = new Color(this.config.getP("color_" + (n + 1), DEFC[n]));
            ++n;
        }
    }
}

