/*
 * Decompiled with CFR 0.152.
 */
package paintchat;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import syi.awt.Awt;

public class SRaster
implements ImageProducer {
    private int width;
    private int height;
    private ColorModel model;
    private int[] pixels;
    private ImageConsumer consumer = null;
    private static Hashtable properties = null;
    private boolean isWin;

    public SRaster(ColorModel colorModel, int[] nArray, int n, int n2) {
        this.model = colorModel;
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
        if (properties == null) {
            properties = new Hashtable();
            this.isWin = Awt.isWin();
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        try {
            this.consumer = imageConsumer;
            imageConsumer.setDimensions(this.width, this.height);
            imageConsumer.setColorModel(this.model);
            imageConsumer.setProperties(properties);
            imageConsumer.setHints(30);
            this.sendPix();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.consumer;
    }

    public void newPixels(Image image, int[] nArray, int n, int n2) {
        this.pixels = nArray;
        this.newPixels(image, n, n2);
    }

    public void newPixels(Image image, int[] nArray, int n, int n2, int n3) {
        if (n3 != 1) {
            this.scale(nArray, n, n2, n3);
        }
        this.pixels = nArray;
        this.newPixels(image, n / n3, n2 / n3);
    }

    public void newPixels(Image image, int n, int n2) {
        if (this.width != n || this.height != n2 || this.consumer == null || !this.isWin) {
            this.width = n;
            this.height = n2;
            image.flush();
        } else {
            this.sendPix();
        }
    }

    public void newPixels(Image image, int n, int n2, int n3) {
        if (n3 != 1) {
            this.scale(this.pixels, n, n2, n3);
            n /= n3;
            n2 /= n3;
        }
        this.newPixels(image, n, n2);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public final void scale(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int cfr_ignored_0 = n * n2;
        int n6 = n3 * n3;
        int n7 = 0;
        while (n7 < n2) {
            n4 = n * n7;
            int n8 = 0;
            while (n8 < n) {
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = n4;
                int n13 = 0;
                while (n13 < n3) {
                    int n14 = 0;
                    while (n14 < n3) {
                        int n15 = nArray[n12++];
                        n11 += n15 >>> 16 & 0xFF;
                        n10 += n15 >>> 8 & 0xFF;
                        n9 += n15 & 0xFF;
                        ++n14;
                    }
                    n12 += n - n3;
                    ++n13;
                }
                nArray[n5++] = n11 / n6 << 16 | n10 / n6 << 8 | n9 / n6;
                n4 += n3;
                n8 += n3;
            }
            n7 += n3;
        }
    }

    private void sendPix() {
        if (this.consumer != null) {
            this.consumer.setPixels(0, 0, this.width, this.height, this.model, this.pixels, 0, this.width);
            this.consumer.imageComplete(3);
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }
}

