/*
 * Decompiled with CFR 0.152.
 */
package syi.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteStream
extends OutputStream {
    private byte[] buffer;
    private int last = 0;

    public ByteStream() {
        this(512);
    }

    public ByteStream(byte[] byArray) {
        this.buffer = byArray;
    }

    public ByteStream(int n) {
        this.buffer = new byte[n <= 0 ? 512 : n];
    }

    public final void addSize(int n) {
        int n2 = this.last + n;
        if (this.buffer.length < n2) {
            byte[] byArray = new byte[Math.max((int)((float)this.buffer.length * 1.5f), n2) + 1];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }

    public void gc() {
        if (this.buffer.length == this.last) {
            return;
        }
        byte[] byArray = new byte[this.last];
        if (this.last != 0) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.last);
        }
        this.buffer = byArray;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public final void insert(int n, int n2) {
        this.buffer[n] = (byte)n2;
    }

    public void reset() {
        this.last = 0;
    }

    public void reset(int n) {
        int n2 = this.last;
        this.reset();
        if (n < n2) {
            this.write(this.buffer, n, n2 - n);
        }
    }

    public void seek(int n) {
        this.last = n;
    }

    public final int size() {
        return this.last;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.last];
        if (this.last > 0) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.last);
        }
        return byArray;
    }

    public final void w(long l, int n) throws IOException {
        int n2 = n - 1;
        while (n2 >= 0) {
            this.write((int)(l >>> (n2 << 3)) & 0xFF);
            --n2;
        }
    }

    public final void w2(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) {
        this.addSize(n2);
        System.arraycopy(byArray, n, this.buffer, this.last, n2);
        this.last += n2;
    }

    public final void write(int n) throws IOException {
        this.addSize(1);
        this.buffer[this.last++] = (byte)n;
    }

    public void write(InputStream inputStream) throws IOException {
        this.addSize(128);
        try {
            int n;
            while ((n = inputStream.read(this.buffer, this.last, this.buffer.length - this.last)) != -1) {
                this.last += n;
                if (this.last < this.buffer.length) continue;
                this.addSize(256);
            }
        }
        catch (IOException iOException) {}
    }

    public void write(InputStream inputStream, int n) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        this.addSize(n);
        int n3 = 0;
        while ((n2 = inputStream.read(this.buffer, this.last, n - n3)) != -1) {
            this.last += n2;
            if ((n3 += n2) >= n) break;
        }
        if (n3 < n) {
            throw new EOFException();
        }
    }

    public byte[] writeTo(byte[] byArray, int n) {
        int n2 = n + this.last;
        if (byArray == null) {
            byArray = new byte[n2];
        }
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        System.arraycopy(this.buffer, 0, byArray, n, this.last);
        return byArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.last == 0) {
            return;
        }
        outputStream.write(this.buffer, 0, this.last);
    }
}

