/*
 * Decompiled with CFR 0.152.
 */
package pch2;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import paintchat.Res;
import pch2.PCHCanvas;
import pch2.PCHPanel;
import pch2.PCHProgress;
import syi.util.ByteStream;

public class PCHViewer
extends Applet
implements Runnable {
    private volatile boolean isStart = false;
    private boolean live = true;
    private Thread tLoad;
    private Vector vList = new Vector();
    private String pchName = "";
    private PCHCanvas pch = null;
    private PCHPanel pchPanel = null;
    private Hashtable table = new Hashtable();
    private Res config;
    private Object base;
    public int speed;
    private int imW;
    private int imH;
    public boolean run;
    public boolean isBufferProgress;
    public boolean isBufferCanvas;
    public boolean isProgress;
    public static final String STR_VERSION = "(C)\u3057\u3043\u3061\u3083\u3093 PCHViewer v3.00";
    private static boolean isJa;
    private Image imIcon = null;
    private Color clBack;
    private Color clFore;
    private Color clFrame;
    private Color clIcon;
    private Color clBar;
    private Color clSelect;

    public void clearPCH() {
        try {
            this.getPCH().clearPCH();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void clearPCH(String string) {
        try {
            this.getPCH(string).clearPCH();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void destroy() {
        try {
            this.removeAllPCH();
            this.live = false;
            if (this.tLoad != null) {
                this.tLoad.interrupt();
                this.tLoad = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private synchronized Image getIcon() {
        try {
            if (this.imIcon == null) {
                int[] nArray = new int[]{-3297361, -16777216, -1, -8551800, -393216};
                byte[] byArray = new byte[77];
                byArray[0] = -32;
                byArray[1] = 1;
                byArray[2] = 64;
                byArray[3] = 49;
                byArray[4] = 80;
                byArray[5] = 1;
                byArray[6] = 32;
                byArray[7] = 33;
                byArray[8] = 18;
                byArray[9] = 17;
                byArray[10] = 64;
                byArray[11] = 1;
                byArray[13] = 17;
                byArray[14] = 98;
                byArray[15] = 1;
                byArray[16] = 48;
                byArray[17] = 33;
                byArray[18] = 98;
                byArray[19] = 1;
                byArray[20] = 48;
                byArray[21] = 33;
                byArray[22] = 82;
                byArray[23] = 33;
                byArray[24] = 48;
                byArray[25] = 1;
                byArray[26] = 98;
                byArray[27] = 17;
                byArray[28] = 3;
                byArray[29] = 1;
                byArray[30] = 48;
                byArray[31] = 1;
                byArray[32] = 34;
                byArray[33] = 65;
                byArray[34] = 19;
                byArray[35] = 1;
                byArray[36] = 32;
                byArray[37] = 17;
                byArray[38] = 2;
                byArray[39] = -125;
                byArray[40] = 1;
                byArray[41] = 32;
                byArray[42] = 1;
                byArray[43] = 18;
                byArray[44] = -125;
                byArray[45] = 1;
                byArray[46] = 32;
                byArray[47] = 1;
                byArray[48] = 18;
                byArray[49] = 83;
                byArray[50] = 2;
                byArray[51] = 3;
                byArray[52] = 17;
                byArray[53] = 32;
                byArray[54] = 1;
                byArray[55] = 18;
                byArray[56] = 1;
                byArray[57] = 51;
                byArray[58] = 18;
                byArray[59] = 97;
                byArray[60] = 18;
                byArray[61] = 113;
                byArray[62] = 82;
                byArray[63] = 1;
                byArray[64] = 2;
                byArray[65] = 48;
                byArray[66] = 52;
                byArray[67] = 18;
                byArray[68] = 65;
                byArray[69] = 2;
                byArray[70] = 49;
                byArray[71] = 36;
                byArray[72] = 33;
                byArray[73] = 82;
                byArray[74] = 48;
                byArray[75] = 20;
                byArray[76] = -110;
                byte[] byArray2 = byArray;
                int n = 0;
                int[] nArray2 = new int[256];
                int n2 = 0;
                while (n2 < byArray2.length) {
                    int n3 = nArray[byArray2[n2] & 0xF];
                    int n4 = (byArray2[n2] >> 4 & 0xF) + 1;
                    int n5 = 0;
                    while (n5 < n4) {
                        nArray2[n++] = n3;
                        ++n5;
                    }
                    ++n2;
                }
                this.imIcon = this.createImage(new MemoryImageSource(16, 16, nArray2, 0, 16));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.imIcon;
    }

    public int getLineCount() {
        try {
            return this.getPCH().getLineCount();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public int getLineCount(Object object) {
        try {
            return this.getPCH(object).getLineCount();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private synchronized PCHCanvas getPCH() {
        if (this.pchName.length() > 0) {
            return this.getPCH(this.pchName);
        }
        if (this.pch == null) {
            this.setLayout(new BorderLayout());
            this.pchPanel = new PCHPanel();
            PCHCanvas pCHCanvas = new PCHCanvas(this, this.base, this.isBufferCanvas, this.config);
            pCHCanvas.setSpeed(this.speed);
            pCHCanvas.setBackground(Color.white);
            pCHCanvas.setForeground(this.clFore);
            this.pchPanel.add(pCHCanvas);
            if (this.isProgress) {
                this.add((Component)this.getProgress(pCHCanvas), "South");
            }
            this.add((Component)this.pchPanel, "Center");
            this.addNotify();
            this.pch = pCHCanvas;
            this.validate();
        }
        return this.pch;
    }

    private synchronized PCHCanvas getPCH(Object object) {
        Container container;
        PCHCanvas pCHCanvas = (PCHCanvas)this.table.get(object);
        if (pCHCanvas == null) {
            container = new PCHPanel();
            pCHCanvas = new PCHCanvas(this, this.base, this.isBufferCanvas, this.config);
            pCHCanvas.setSpeed(this.speed);
            pCHCanvas.setBackground(Color.white);
            pCHCanvas.setForeground(this.clFore);
            container.add(pCHCanvas);
            this.table.put(object, pCHCanvas);
            Frame frame = new Frame(STR_VERSION);
            frame.addWindowListener(pCHCanvas);
            frame.setLayout(new BorderLayout());
            ((Component)frame).setBackground(this.clBack);
            frame.setForeground(this.clFore);
            Image image = this.getIcon();
            if (image != null) {
                frame.setIconImage(image);
            }
            frame.add((Component)container, "Center");
            if (this.isProgress) {
                frame.add((Component)this.getProgress(pCHCanvas), "South");
            }
            frame.addNotify();
            frame.pack();
        }
        if (!(container = (Frame)pCHCanvas.getParent().getParent()).isVisible()) {
            container.setVisible(true);
        }
        return pCHCanvas;
    }

    private PCHProgress getProgress(PCHCanvas pCHCanvas) {
        PCHProgress pCHProgress = new PCHProgress(this.isBufferProgress);
        pCHProgress.setPCHCanvas(pCHCanvas);
        pCHProgress.setColor(this.clBack, this.clFore, this.clIcon, this.clBar, this.clFrame, this.clSelect);
        pCHCanvas.setProgress(pCHProgress);
        return pCHProgress;
    }

    public int getSeek() {
        try {
            return this.getPCH().getSeek();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public int getSeek(Object object) {
        try {
            this.getPCH(object).getSeek();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return 0;
    }

    private int i(String string) throws NumberFormatException {
        return Integer.decode(string);
    }

    public void init() {
        try {
            this.enableEvents(16L);
            isJa = Locale.getDefault().getLanguage().equalsIgnoreCase("ja");
            PCHProgress.isJa = isJa = this.p("ja", isJa);
            this.pchName = this.p("pch_name", "");
            this.speed = this.p("speed", 10);
            this.isProgress = this.p("progress", true);
            this.isBufferCanvas = this.p("buffer_canvas", false);
            this.isBufferProgress = this.p("buffer_progress", true);
            this.imW = this.p("image_width", this.p("width", 300));
            this.imH = this.p("image_height", this.p("height", 300));
            this.clBack = new Color(this.p("color_back", 0xCCCCFF));
            this.clFore = new Color(this.p("color_text", 5263480));
            this.clIcon = new Color(this.p("color_icon", 0xCCCCFF));
            this.clFrame = new Color(this.p("color_frame", 5263480));
            this.clBar = new Color(this.p("color_bar", 0xEDEDFF));
            this.clSelect = new Color(this.p("color_bar_select", 4158837));
            this.setBackground(this.clBack);
            this.setForeground(this.clFore);
            this.run = this.p("run", true);
            try {
                Window window = PCHCanvas.getParentTop(this);
                if (window instanceof Frame) {
                    ((Frame)window).setIconImage(this.getIcon());
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private boolean isStr(String string) {
        return string != null && string.length() > 0 && string.toLowerCase().startsWith("undef");
    }

    private void loadConfig() throws IOException {
        if (this.config != null) {
            return;
        }
        String string = this.p("dir_resource", "./res/");
        char c = string.charAt(string.length() - 1);
        if (c == '&' || c == '?' || c == '=') {
            this.base = string;
        } else {
            if (string.charAt(string.length() - 1) != '/') {
                string = String.valueOf(string) + '/';
            }
            this.base = new URL(this.getCodeBase(), string);
        }
        this.config = new Res(this, this.base, new ByteStream());
        this.config.loadZip(this.p("res.zip", "res/res.zip"));
    }

    public synchronized void loadPCH(Object object, String string) {
        try {
            Object object2 = this.vList;
            synchronized (object2) {
                this.vList.addElement(object);
                this.vList.addElement(string);
            }
            object2 = this.tLoad;
            synchronized (object2) {
                this.tLoad.notify();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void loadPCH(String string) {
        try {
            Object object = this.vList;
            synchronized (object) {
                this.vList.addElement("");
                this.vList.addElement(string);
            }
            object = this.tLoad;
            synchronized (object) {
                this.tLoad.notify();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private int p(String string, int n) {
        try {
            String string2 = this.getParameter(string);
            if (string2 == null || string2.length() <= 0) {
                return n;
            }
            return Res.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private String p(String string, String string2) {
        try {
            String string3 = this.getParameter(string);
            if (string3 != null && string3.length() > 0) {
                return string3;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string2;
    }

    private boolean p(String string, boolean bl) {
        try {
            String string2 = this.getParameter(string);
            if (string2 != null && string2.length() > 0) {
                char c = Character.toLowerCase(string2.charAt(0));
                return c == 't' || c == 'y' || c == 'o' || c == '1';
            }
        }
        catch (RuntimeException runtimeException) {}
        return bl;
    }

    public void paint(Graphics graphics) {
    }

    public synchronized void playPCH() {
        try {
            this.getPCH().playPCH();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void playPCH(Object object) {
        try {
            this.getPCH(object).playPCH();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void removeAllPCH() {
        try {
            if (this.pch != null) {
                this.pch.destroyPCH();
                this.pch = null;
            }
            Enumeration enumeration = this.table.elements();
            while (enumeration.hasMoreElements()) {
                PCHCanvas pCHCanvas = (PCHCanvas)enumeration.nextElement();
                pCHCanvas.destroyPCH();
                Window window = PCHCanvas.getParentTop(pCHCanvas);
                if (window == null) continue;
                window.dispose();
            }
            this.table.clear();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void removePCH(Object object) {
        try {
            PCHCanvas pCHCanvas = (PCHCanvas)this.table.get(object);
            if (pCHCanvas != null) {
                this.table.remove(object);
                pCHCanvas.destroyPCH();
                Window window = PCHCanvas.getParentTop(pCHCanvas);
                if (window != null) {
                    window.dispose();
                }
                if (pCHCanvas == this.pch) {
                    this.remove(this.pch);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.loadConfig();
            block9: while (true) {
                if (!this.live) {
                    return;
                }
                while (true) {
                    String string;
                    Thread thread;
                    if (this.vList.isEmpty()) {
                        thread = this.tLoad;
                        synchronized (thread) {
                            this.tLoad.wait();
                            continue block9;
                        }
                    }
                    Vector vector = this.vList;
                    synchronized (vector) {
                        thread = this.vList.firstElement();
                        this.vList.removeElementAt(0);
                        string = (String)this.vList.firstElement();
                        this.vList.removeElementAt(0);
                    }
                    PCHCanvas pCHCanvas = thread.equals("") ? this.getPCH() : this.getPCH(thread);
                    pCHCanvas.loadPCH(new URL(this.getCodeBase(), string), this.imW, this.imH);
                    if (!this.run) continue;
                    pCHCanvas.playPCH();
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setBuffer(String string) {
        if (string.length() > 0) {
            boolean bl;
            char c = Character.toLowerCase(string.charAt(0));
            this.isBufferCanvas = bl = c == 't' || c == '1' || c == 'o';
            this.isBufferProgress = bl;
        }
    }

    public void setMark(Object object, String string) {
        try {
            this.getPCH(object).setMark(this.i(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setMark(String string) {
        try {
            this.getPCH().setMark(this.i(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSize(Object object, String string, String string2) {
        try {
            int n = this.i(string);
            int n2 = this.i(string2);
            PCHCanvas pCHCanvas = this.getPCH(object);
            pCHCanvas.setSize(n, n2);
            ((Window)pCHCanvas.getParent()).pack();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSize(String string, String string2) {
        try {
            if (this.pchName.length() > 0) {
                this.setSize(this.pchName, string, string2);
                return;
            }
            int n = this.i(string);
            int n2 = this.i(string2);
            this.getPCH().setSize(n, n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSpeed(Object object, String string) {
        try {
            this.getPCH(object).setSpeed(Integer.decode(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSpeed(String string) {
        try {
            this.getPCH().setSpeed(Integer.decode(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setVisit(Object object, String string, String string2) {
        try {
            this.getPCH(object).setVisit(this.i(string), this.i(string2) != 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setVisit(String string, String string2) {
        try {
            this.getPCH().setVisit(this.i(string), this.i(string2) != 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void start() {
        try {
            PCHViewer pCHViewer = this;
            synchronized (pCHViewer) {
                if (this.isStart) {
                    return;
                }
                this.isStart = true;
                try {
                    this.tLoad = new Thread(this);
                    this.tLoad.setDaemon(true);
                    this.tLoad.setPriority(1);
                    this.tLoad.start();
                    this.showStatus(STR_VERSION);
                    String string = this.p("pch_file", "");
                    if (string.length() > 0) {
                        this.loadPCH(string);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void suspendPCH() {
        try {
            this.getPCH().suspendDraw();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void suspendPCH(Object object) {
        try {
            this.getPCH(object).suspendDraw();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

