/*
 * Decompiled with CFR 0.152.
 */
package pch2;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import pch2.PCHCanvas;

public class PCHProgress
extends Canvas {
    private PCHCanvas pch;
    private boolean isBuffer;
    private int selTool = -1;
    private int putTool = -1;
    private Rectangle[] rects = null;
    private Image image = null;
    private Graphics back = null;
    private Graphics primary = null;
    private Color clBack;
    private Color clIcon;
    private Color clFore;
    private Color clBar;
    private Color clFrame;
    private Color clSelect;
    public static boolean isJa;
    private static final Font font;
    private static final int I_BODY = 0;
    private static final int I_PLAY = 1;
    private static final int I_STOP = 2;
    private static final int I_RESTART = 3;
    private static final int I_SPEED = 4;
    private static final int I_ADD = 5;
    private static final int I_SUB = 6;
    private static final int I_BAR = 7;
    private static final int I_SIZE_ICON = 20;
    public static final int I_SIZE_PRE = 26;

    static {
        font = new Font("sansserif", 0, 12);
    }

    public PCHProgress(boolean bl) {
        this.enableEvents(49L);
        this.isBuffer = bl;
    }

    public void action(Point point) {
        if (this.rects == null) {
            return;
        }
        int n = 1;
        int n2 = this.rects.length;
        while (n < n2) {
            if (this.rects[n].contains(point)) {
                if (this.putTool == n) break;
                this.putTool = n;
                this.drawIcon(n);
                return;
            }
            ++n;
        }
        if (n >= n2) {
            return;
        }
        if (this.pch == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.pch.playPCH();
                break;
            }
            case 2: {
                this.pch.suspendDraw();
                break;
            }
            case 3: {
                this.pch.setMark(0);
                this.pch.setMark(-1);
                this.drawIcon(7);
                break;
            }
            case 4: {
                int n3 = this.pch.getSpeed();
                switch (n3) {
                    case 0: {
                        n3 = 10;
                        break;
                    }
                    case 10: {
                        n3 = 20;
                        break;
                    }
                    case 20: {
                        n3 = -1;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
                this.pch.setSpeed(n3);
                break;
            }
            case 5: {
                this.pch.setScale(1, false);
                break;
            }
            case 6: {
                this.pch.setScale(-1, false);
            }
        }
    }

    public void drawBar() {
        this.drawIcon(7);
    }

    private void drawIcon(int n) {
        Graphics graphics = this.getPrimary();
        if (graphics == null) {
            return;
        }
        if (this.isBuffer) {
            this.drawIcon(this.back, n);
            if (this.rects != null && n > 0 && n < this.rects.length) {
                Rectangle rectangle = this.rects[n];
                graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
            }
        } else {
            this.drawIcon(graphics, n);
        }
    }

    private void drawIcon(Graphics graphics, int n) {
        if (graphics == null) {
            return;
        }
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            try {
                if (this.rects == null || n < 0 || n >= this.rects.length || graphics == null) {
                    return;
                }
                Rectangle rectangle = this.rects[n];
                Color color = n == 0 ? this.clBack : this.clIcon;
                Color color2 = color = n == this.putTool ? color.darker() : color;
                if (n != 7) {
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                }
                if (n == this.selTool && n != this.putTool || n == 0) {
                    graphics.setColor(color.brighter());
                    graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                }
                graphics.setColor(n == this.selTool ? this.clSelect : this.clFrame);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                switch (n) {
                    case 1: {
                        int[] nArray = new int[]{rectangle.x + 7, rectangle.x + 13, rectangle.x + 7};
                        int[] nArray2 = new int[]{rectangle.y + 4, rectangle.y + 10, rectangle.y + 16};
                        graphics.setColor(this.clFore);
                        graphics.fillPolygon(nArray, nArray2, nArray.length);
                        graphics.setColor(this.clFore.brighter());
                        graphics.drawPolygon(nArray, nArray2, nArray.length);
                        break;
                    }
                    case 2: {
                        graphics.setColor(this.clFore);
                        graphics.fillRect(rectangle.x + 5, rectangle.y + 6, 9, 9);
                        graphics.setColor(this.clFore.brighter());
                        graphics.drawRect(rectangle.x + 4, rectangle.y + 5, 10, 10);
                        break;
                    }
                    case 3: {
                        int[] nArray = new int[]{rectangle.x + 8, rectangle.x + 2, rectangle.x + 8};
                        int[] nArray3 = new int[]{nArray[0] + 8, nArray[1] + 8, nArray[2] + 8};
                        int[] nArray4 = new int[]{rectangle.y + 4, rectangle.y + 10, rectangle.y + 16};
                        graphics.setColor(this.clFore);
                        graphics.fillPolygon(nArray, nArray4, nArray.length);
                        graphics.fillPolygon(nArray3, nArray4, nArray.length);
                        graphics.setColor(this.clFore.brighter());
                        graphics.drawPolygon(nArray, nArray4, nArray.length);
                        graphics.drawPolygon(nArray3, nArray4, nArray.length);
                        break;
                    }
                    case 4: {
                        String[][] stringArrayArray = new String[][]{{"Mx", "H", "M", "L"}, {"\u6700", "\u65e9", "\u65e2", "\u920d"}};
                        String[] stringArray = isJa ? stringArrayArray[1] : stringArrayArray[0];
                        int n2 = this.pch.getSpeed();
                        n2 = n2 < 0 ? 0 : (n2 == 0 ? 1 : (n2 <= 10 ? 2 : 3));
                        graphics.setColor(this.clFore);
                        graphics.drawString(stringArray[n2], rectangle.x + 4, rectangle.y + rectangle.height - 4);
                        break;
                    }
                    case 5: {
                        int n3 = rectangle.width / 2;
                        int n4 = rectangle.height / 2;
                        graphics.fillRect(rectangle.x + n3 / 2, rectangle.y + n4 - 1, n3, 2);
                        graphics.fillRect(rectangle.x + n3 - 1, rectangle.y + n4 / 2, 2, n4);
                        break;
                    }
                    case 6: {
                        int n5 = rectangle.width / 2;
                        int n6 = rectangle.height / 2;
                        graphics.fillRect(rectangle.x + n5 / 2, rectangle.y + n6 - 1, n5, 2);
                        break;
                    }
                    case 7: {
                        int n7 = this.pch.getLineCount();
                        int n8 = this.pch.getSeek();
                        int n9 = (int)((float)rectangle.width * ((float)n8 / (float)n7)) - 5;
                        if (n9 <= 0) {
                            n9 = 1;
                        }
                        graphics.setColor(this.clBar);
                        graphics.fillRect(rectangle.x + 3, rectangle.y + 2, n9, rectangle.height - 4);
                        graphics.setColor(color);
                        graphics.fillRect(rectangle.x + 3 + n9, rectangle.y + 2, rectangle.width - n9 - 5, rectangle.height - 4);
                        graphics.setColor(this.clFore);
                        graphics.fillRect(rectangle.x + Math.min(Math.max((int)((float)this.pch.getMark() / (float)n7 * (float)rectangle.width), 3), rectangle.width - 3), rectangle.y + 2, 1, rectangle.height - 4);
                        graphics.drawString(String.valueOf(String.valueOf(n8)) + '/' + n7, rectangle.x + 3, rectangle.y + rectangle.height - 3);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(26, 26);
    }

    public Dimension getPreferredSize() {
        Container container = this.getParent();
        return container == null ? this.getMinimumSize() : new Dimension(container.getSize().width, 26);
    }

    private Graphics getPrimary() {
        if (this.primary == null) {
            if (this.getParent() == null) {
                return null;
            }
            this.primary = this.getGraphics();
            if (this.primary == null) {
                return null;
            }
            this.primary.setFont(font);
        }
        return this.primary;
    }

    private void iPaint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = 0;
        while (n < this.rects.length) {
            this.drawIcon(graphics, n);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.rects == null) {
                this.upRect();
                this.iPaint(this.back);
            }
            graphics = this.getPrimary();
            if (this.isBuffer) {
                Dimension dimension = this.getSize();
                graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, 0, 0, dimension.width, dimension.height, null);
            } else {
                this.iPaint(graphics);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        try {
            int n = componentEvent.getID();
            if (this.rects == null) {
                return;
            }
            if (n == 101) {
                this.upRect();
                this.iPaint(this.back);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getID();
            Point point = mouseEvent.getPoint();
            switch (n) {
                case 503: {
                    this.selIcon(point);
                    break;
                }
                case 506: {
                    if (this.putTool != 7) break;
                    this.setMark(point);
                    break;
                }
                case 501: {
                    this.action(point);
                    if (this.putTool != 7) break;
                    this.setMark(point);
                    break;
                }
                case 502: {
                    this.action(point);
                    this.releaseIcon();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
    }

    private void releaseIcon() {
        int n = this.putTool;
        this.putTool = -1;
        this.drawIcon(n);
    }

    private void selIcon(Point point) {
        if (this.rects == null) {
            return;
        }
        int n = this.selTool;
        int n2 = this.rects.length;
        int n3 = 1;
        while (n3 < n2) {
            if (this.rects[n3].contains(point)) break;
            ++n3;
        }
        if (n3 >= n2) {
            n3 = -1;
        }
        if (this.selTool == n3) {
            return;
        }
        this.selTool = n3;
        if (n != -1) {
            this.drawIcon(n);
        }
        if (n3 != -1) {
            this.drawIcon(n3);
        }
    }

    public void setColor(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        this.clBack = color;
        this.clFore = color2;
        this.clIcon = color3;
        this.clBar = color4;
        this.clFrame = color5;
        this.clSelect = color6;
        this.setBackground(color);
        this.setForeground(color2);
    }

    private synchronized void setMark(Point point) {
        try {
            int n = point.x - this.rects[7].x;
            int n2 = this.rects[7].width;
            int n3 = this.pch.getLineCount();
            n = n <= 0 ? 0 : (n >= n2 ? n3 : (int)((float)n / (float)n2 * (float)n3));
            this.pch.setMark(n);
            this.drawIcon(7);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void setPCHCanvas(PCHCanvas pCHCanvas) {
        this.pch = pCHCanvas;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private synchronized void upRect() {
        int n;
        if (this.rects == null) {
            this.rects = new Rectangle[8];
            n = 0;
            while (n < this.rects.length) {
                this.rects[n] = new Rectangle();
                ++n;
            }
        }
        Dimension dimension = this.getSize();
        int n2 = 3;
        int n3 = 3;
        n = 1;
        while (n < this.rects.length) {
            this.rects[n].setSize(20, 20);
            ++n;
        }
        n = 1;
        while (n < this.rects.length) {
            Rectangle rectangle = this.rects[n];
            rectangle.setLocation(n2, n3);
            n2 += 23;
            ++n;
        }
        this.rects[7].setSize(dimension.width - this.rects[7].x - 3, 20);
        this.rects[0].setBounds(0, 0, dimension.width, dimension.height);
        if (this.isBuffer && (this.image == null || this.image.getWidth(null) < dimension.width || this.image.getHeight(null) < dimension.height)) {
            if (this.image != null) {
                this.image.flush();
                this.back.dispose();
            }
            this.image = this.createImage(dimension.width, dimension.height);
            this.back = this.image.getGraphics();
            this.back.setFont(font);
        }
    }
}

