/*
 * Decompiled with CFR 0.152.
 */
package pch2;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.Inflater;
import paintchat.LO;
import paintchat.M;
import paintchat.Mg;
import paintchat.Res;
import pch2.PCHProgress;
import syi.awt.Awt;
import syi.util.ByteStream;

public class PCHCanvas
extends Canvas
implements Runnable,
WindowListener {
    public static final String STR_VERSION = "(C)\u3057\u3043\u3061\u3083\u3093 PCHCanvas v1.14";
    private Object oSync = new Object();
    public static boolean isWin = true;
    private boolean live = true;
    private boolean liveDraw = false;
    private boolean liveLoad = false;
    private boolean isSuspend = false;
    private boolean isOldVersion = false;
    private Res cf;
    private Image image = null;
    private Applet applet;
    private Graphics primary;
    private Graphics back;
    private Mg mgLine = new Mg();
    private M mgLine2 = new M();
    private Mg.Info info;
    private Mg.User user;
    private M.Info info2;
    private M.User user2;
    private boolean is_init = false;
    private int[] b_bk = null;
    private int b_bk_w = 0;
    private int b_bk_h = 0;
    private URL urlPCH = null;
    private int seek = 0;
    private int mark = 0;
    private int lineCount = 0;
    private int lineMax = 0;
    private byte[][] mglines = null;
    private Thread tDraw = null;
    private Thread tLoad = null;
    private PCHProgress progress = null;
    private Point pressPo = null;

    public PCHCanvas(Applet applet, Object object, boolean bl, Res res) {
        this.enableEvents(49L);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.cf = new Res(applet, object, new ByteStream());
        Enumeration enumeration = res.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.cf.put(k, res.get(k));
        }
        this.applet = applet;
    }

    public synchronized void addMg(byte[] byArray) {
        if (this.mglines == null) {
            this.mglines = new byte[this.lineMax][];
        }
        if (this.lineCount >= this.lineMax) {
            this.lineMax = (int)((float)this.lineMax * 1.25f);
            byte[][] byArray2 = new byte[this.lineMax][];
            System.arraycopy(this.mglines, 0, byArray2, 0, this.mglines.length);
            this.mglines = byArray2;
        }
        this.mglines[this.lineCount++] = byArray;
        ++this.mark;
        if (this.progress != null) {
            this.progress.drawBar();
        }
    }

    private synchronized void clearCanvas() {
        try {
            int n;
            int n2;
            int n3;
            Object object;
            int n4 = this.cf.getP("layer_count", 2);
            if (this.isOldVersion) {
                if (this.info == null) {
                    return;
                }
                this.info.setL(n4);
                int[][] nArray = this.info.getOffset();
                int n5 = nArray[0].length;
                object = nArray[0];
                this.mgLine.memset((int[])object, 0xFFFFFF);
                int n6 = 1;
                while (n6 < nArray.length) {
                    System.arraycopy(object, 0, nArray[n6], 0, n5);
                    ++n6;
                }
                n3 = this.info.Q;
                n2 = this.info.W;
                n = this.info.H;
            } else {
                if (this.info2 == null) {
                    return;
                }
                this.info2.setL(n4);
                LO[] lOArray = this.info2.layers;
                int n7 = 0;
                while (n7 < this.info2.L) {
                    lOArray[n7].clear();
                    ++n7;
                }
                n3 = this.info2.Q;
                n2 = this.info2.W;
                n = this.info2.H;
            }
            String string = this.applet.getParameter("image_canvas");
            if (string != null && string.length() > 0) {
                if (this.b_bk == null) {
                    object = this.applet.getImage(new URL(this.applet.getCodeBase(), string));
                    Awt.wait((Image)object);
                    if (n3 != 1) {
                        Image image = ((Image)object).getScaledInstance(((Image)object).getWidth(null) * n3, ((Image)object).getHeight(null) * n3, 16);
                        Awt.wait(image);
                        ((Image)object).flush();
                        object = image;
                    }
                    this.b_bk_w = ((Image)object).getWidth(null);
                    this.b_bk_h = Math.min(((Image)object).getHeight(null), n);
                    PixelGrabber pixelGrabber = new PixelGrabber((Image)object, 0, 0, this.b_bk_w, this.b_bk_h, true);
                    pixelGrabber.grabPixels();
                    this.b_bk = (int[])pixelGrabber.getPixels();
                    ((Image)object).flush();
                }
                this.info2.layers[0].reserve();
                int n8 = 0;
                while (n8 < this.b_bk_h) {
                    System.arraycopy(this.b_bk, n8 * this.b_bk_w, this.info2.layers[0].offset, n8 * n2, Math.min(this.b_bk_w, n2));
                    ++n8;
                }
            }
            if (this.back != null) {
                this.back.setColor(Color.white);
                this.back.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void clearPCH() {
        this.stopLoad();
        this.setMark(0);
        this.lineCount = 0;
        int n = this.mglines.length;
        int n2 = 0;
        while (n2 < n) {
            this.mglines[n2] = null;
            ++n2;
        }
    }

    public synchronized void destroyPCH() {
        block7: {
            Container container = this.getParent();
            if (container instanceof Window) {
                ((Window)container).dispose();
            } else {
                container.remove(this);
            }
            this.stopLoad();
            try {
                if (this.tDraw == null) break block7;
                this.liveDraw = false;
                this.tDraw.interrupt();
                if (!this.isSuspend) break block7;
                Thread thread = this.tDraw;
                synchronized (thread) {
                    this.tDraw.notify();
                    this.tDraw.join();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void error(String string) {
        try {
            if (this.image == null) {
                return;
            }
            Dimension dimension = this.getSize();
            new Font("Sans", 0, 16);
            this.back.setColor(new Color(0xCCCCFF));
            this.back.fillRect(0, 0, dimension.width, dimension.height);
            this.back.setColor(new Color(5263480));
            this.back.drawString(STR_VERSION, 5, 32);
            this.back.drawString(string, 5, 64);
            this.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getLineCount() {
        return this.lineMax;
    }

    public int getMark() {
        return this.mark;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public static Window getParentTop(Component component) {
        try {
            Container container = component.getParent();
            while (!(container instanceof Window)) {
                container = container.getParent();
            }
            return (Window)container;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public int getSeek() {
        return this.seek;
    }

    public int getSpeed() {
        this.initUser();
        return this.user != null ? this.user.wait : (this.user2 != null ? this.user2.wait : 0);
    }

    private void initUser() {
        if (this.isOldVersion) {
            if (this.info != null) {
                return;
            }
            Mg mg = this.mgLine;
            synchronized (mg) {
                if (this.user == null) {
                    this.user = this.mgLine.newUser(this);
                }
            }
        }
        if (this.info2 != null) {
            return;
        }
        M m = this.mgLine2;
        synchronized (m) {
            if (this.user2 == null) {
                this.user2 = this.mgLine2.newUser(this);
            }
        }
    }

    private void loadConfig(InputStream inputStream, ByteStream byteStream) throws IOException {
        Container container;
        byteStream.reset();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n2 == 13) continue;
            if (n2 == 10) {
                if (++n >= 2) {
                    break;
                }
            } else {
                n = 0;
            }
            byteStream.write(n2);
        }
        this.cf.load(new String(byteStream.getBuffer(), 0, byteStream.size(), "UTF8"));
        this.isOldVersion = this.cf.getP("version", 1) <= 1;
        this.mglines = null;
        this.lineMax = this.cf.getP("count_lines", 5);
        this.initUser();
        Dimension dimension = this.getSize();
        int n3 = Math.max(this.cf.getP("Client_Image_Width", this.cf.getP("image_width", dimension.width)), 1);
        int n4 = Math.max(this.cf.getP("Client_Image_Height", this.cf.getP("image_height", dimension.height)), 1);
        int n5 = this.cf.getP("layer_count", 2);
        int n6 = this.cf.getP("quality", 1);
        if (this.isOldVersion) {
            this.info = this.mgLine.newInfo(this.applet, this, this.cf);
            this.info.setSize(n3, n4, n6);
            this.info.setL(n5);
        } else {
            this.info2 = this.mgLine2.newInfo(this.applet, this, this.cf);
            this.info2.setSize(n3, n4, n6);
            this.info2.setL(n5);
        }
        this.setCanvasSize(n3, n4);
        if ((n3 > dimension.width || n4 > dimension.height) && (container = this.getParent()) instanceof Window) {
            ((Window)container).pack();
        }
        this.updateInfo();
        this.moveCenter();
        this.is_init = true;
    }

    public synchronized void loadPCH(URL uRL, int n, int n2) throws InterruptedException {
        if (uRL == null) {
            return;
        }
        if (this.urlPCH != null && uRL.equals(this.urlPCH)) {
            this.setMark(0);
            this.setMark(-1);
            return;
        }
        this.urlPCH = uRL;
        this.stopLoad();
        this.liveLoad = true;
        Thread thread = new Thread((Runnable)this, "l");
        thread.setDaemon(true);
        thread.setPriority(1);
        this.tLoad = thread;
        thread.start();
    }

    private void m_paint(Graphics graphics, Rectangle rectangle) {
        try {
            Object object = this.oSync;
            synchronized (object) {
                int n;
                int n2;
                int n3;
                int n4;
                if (graphics == null) {
                    graphics = this.primary;
                }
                if (graphics == null) {
                    return;
                }
                Dimension dimension = this.getSize();
                if (rectangle == null) {
                    n4 = 0;
                    n3 = 0;
                    n2 = dimension.width;
                    n = dimension.height;
                } else {
                    n4 = rectangle.x < 0 ? 0 : rectangle.x;
                    n3 = rectangle.y < 0 ? 0 : rectangle.y;
                    n2 = rectangle.x + rectangle.width > dimension.width ? dimension.width - rectangle.x : dimension.width;
                    int n5 = n = rectangle.y + rectangle.height > dimension.height ? dimension.height - rectangle.y : dimension.height;
                }
                if (n2 <= 0 || n <= 0) {
                    return;
                }
                if (this.isOldVersion) {
                    if (this.mgLine == null) {
                        return;
                    }
                    Mg mg = this.mgLine;
                    synchronized (mg) {
                        this.mgLine.m_paint(n4, n3, n2, n);
                    }
                }
                if (this.mgLine2 == null) {
                    return;
                }
                M m = this.mgLine2;
                synchronized (m) {
                    this.mgLine2.m_paint(n4, n3, n2, n);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void m_po(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 <= 0 || n4 <= 0 || !this.is_init) {
            return;
        }
        if (this.isOldVersion) {
            if (this.mgLine == null) {
                return;
            }
            Mg mg = this.mgLine;
            synchronized (mg) {
                this.mgLine.m_paint(n, n2, n3, n4);
            }
        }
        this.getSize();
        if (this.mgLine2 == null) {
            return;
        }
        M m = this.mgLine2;
        synchronized (m) {
            this.mgLine2.m_paint(n, n2, n3, n4);
        }
    }

    public void paint(Graphics graphics) {
        try {
            this.m_paint(graphics, graphics.getClipBounds());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void playPCH() {
        if (this.tDraw == null || !this.liveDraw) {
            this.tDraw = new Thread((Runnable)this, "d");
            this.liveDraw = true;
            this.tDraw.setDaemon(true);
            this.tDraw.setPriority(1);
            this.tDraw.start();
        } else if (this.isSuspend) {
            Thread thread = this.tDraw;
            synchronized (thread) {
                this.tDraw.notify();
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        try {
            if (componentEvent.getID() == 102 || componentEvent.getID() == 101) {
                this.updateInfo();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        try {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.pressPo = mouseEvent.getPoint();
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                case 502: {
                    this.pressPo = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    this.repaint();
                    break;
                }
                case 506: {
                    this.scroll(mouseEvent.getPoint(), true, false);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private int r(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private void rDraw() throws InterruptedException {
        if (this.seek == 0) {
            this.clearCanvas();
        }
        while (this.liveDraw) {
            Object object;
            if (this.seek < this.mark) {
                if (this.seek == 0) {
                    this.clearCanvas();
                }
                if (this.isOldVersion) {
                    this.mgLine.set(this.mglines[this.seek++], 0);
                    if (this.progress != null) {
                        this.progress.drawBar();
                    }
                    if (this.mgLine.iLayer >= this.info.L) {
                        this.info.setL(this.mgLine.iLayer + 1);
                    }
                    object = this.oSync;
                    synchronized (object) {
                        this.mgLine.draw();
                    }
                } else {
                    this.mgLine2.set(this.mglines[this.seek++], 0);
                    if (this.progress != null) {
                        this.progress.drawBar();
                    }
                    if (this.mgLine2.iLayer >= this.info2.L) {
                        this.info2.setL(this.mgLine2.iLayer + 1);
                    }
                    object = this.oSync;
                    synchronized (object) {
                        this.mgLine2.draw();
                    }
                }
            } else {
                Thread.sleep(1000L);
            }
            if (!this.isSuspend) continue;
            this.m_paint(null, null);
            object = this.tDraw;
            synchronized (object) {
                if (this.isSuspend) {
                    this.tDraw.wait();
                }
                this.isSuspend = false;
            }
        }
    }

    private void rLoad() throws InterruptedException {
        Inflater inflater = new Inflater(false);
        ByteStream byteStream = new ByteStream();
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(this.urlPCH.openStream());
            this.loadConfig(dataInputStream, byteStream);
            byteStream.reset();
            byte[] byArray = new byte[1024];
            byte[] byArray2 = new byte[512];
            while (this.liveLoad) {
                int n = dataInputStream.readUnsignedShort();
                if (n >= 0) {
                    inflater.reset();
                    int n2 = 0;
                    block6: while (this.liveLoad && n2 < n) {
                        int n3 = Math.min(n - n2, byArray.length);
                        dataInputStream.readFully(byArray, 0, n3);
                        n2 += n3;
                        inflater.setInput(byArray, 0, n3);
                        while (this.liveLoad) {
                            int n4 = inflater.inflate(byArray2, 0, byArray2.length);
                            if (n4 <= 0) {
                                if (inflater.needsInput()) continue block6;
                                continue;
                            }
                            byteStream.write(byArray2, 0, n4);
                            if (byteStream.size() < 2) continue;
                            n4 = 0;
                            while (byteStream.size() - n4 >= 2) {
                                byte[] byArray3 = byteStream.getBuffer();
                                n3 = ((byArray3[n4] & 0xFF) << 8 | byArray3[n4 + 1] & 0xFF) + 2;
                                if (byteStream.size() - n4 < n3) break;
                                byte[] byArray4 = new byte[n3];
                                System.arraycopy(byArray3, n4, byArray4, 0, n3);
                                n4 += n3;
                                this.addMg(byArray4);
                                if (!this.liveLoad) break;
                            }
                            if (n4 <= 0) continue;
                            byteStream.reset(n4);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.error(throwable.getMessage());
        }
        if (dataInputStream != null) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
        inflater.end();
    }

    public void run() {
        try {
            switch (Thread.currentThread().getName().charAt(0)) {
                case 'l': {
                    this.rLoad();
                    break;
                }
                case 'd': {
                    this.rDraw();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private synchronized void scroll(Point point, boolean bl, boolean bl2) {
        if (bl2) {
            this.setLocation(point);
            bl = true;
        } else if (this.pressPo == null || this.primary == null || this.pressPo.equals(point)) {
            return;
        }
        Object object = this.oSync;
        synchronized (object) {
            int n = point.x - this.pressPo.x;
            int n2 = point.y - this.pressPo.y;
            if (bl) {
                n = -n;
                n2 = -n2;
            }
            Point point2 = this.getLocation();
            this.setLocation(point2.x - n, point2.y - n2);
        }
    }

    public synchronized void setMark(int n) {
        int n2 = n = n < 0 || n >= this.lineCount ? this.lineCount : n;
        if (n < this.seek) {
            this.seek = 0;
            this.clearCanvas();
        }
        this.mark = n;
    }

    public void setProgress(PCHProgress pCHProgress) {
        this.progress = pCHProgress;
    }

    public void setSpeed(int n) {
        try {
            this.initUser();
            if (this.user != null) {
                this.user.wait = n;
            }
            if (this.user2 != null) {
                this.user2.wait = n;
            }
            if (this.progress != null) {
                this.progress.repaint();
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void updateInfo() {
        Object object = this.oSync;
        synchronized (object) {
            if (this.primary != null) {
                this.primary.dispose();
            }
            this.primary = this.getGraphics();
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (this.back != null) {
                n = this.image.getWidth(null);
                n2 = this.image.getHeight(null);
            }
            if (this.info != null) {
                this.info.setComponent(this, this.back != null ? this.back : this.primary, n, n2);
                n = this.info.imW;
                n2 = this.info.imH;
            }
            if (this.info2 != null) {
                this.info2.setComponent(this, this.back != null ? this.back : this.primary, n, n2);
                n = this.info2.imW;
                n2 = this.info2.imH;
            }
        }
    }

    public synchronized void setVisit(int n, boolean bl) {
        int n2;
        int n3 = n2 = this.isOldVersion ? this.info.visit.length : this.info2.L;
        if (n <= -1 || n >= n2) {
            return;
        }
        if (this.isOldVersion) {
            this.info.visit[n] = bl ? 255 : 0;
        } else {
            this.info2.layers[n].iAlpha = bl ? 1 : 0;
        }
        this.repaint();
    }

    public synchronized void stopLoad() {
        if (this.tLoad != null) {
            this.liveLoad = false;
            this.tLoad.interrupt();
            this.tLoad = null;
        }
    }

    public void suspendDraw() {
        this.isSuspend = true;
    }

    public void setScale(int n, boolean bl) {
        Object object = this.oSync;
        synchronized (object) {
            if (this.isOldVersion) {
                if (this.info != null) {
                    this.info.addScale(n, bl);
                    this.setCanvasSize(this.info.W, this.info.H);
                }
            } else if (this.info2 != null) {
                this.info2.addScale(n, bl);
                this.setCanvasSize(this.info2.W, this.info2.H);
            }
        }
        this.repaint();
    }

    public float getScale() {
        if (this.info != null) {
            return (float)this.info.scale / (float)this.info.Q;
        }
        if (this.info2 != null) {
            return (float)this.info2.scale / (float)this.info2.Q;
        }
        return 1.0f;
    }

    public void moveCenter() {
        Dimension dimension = this.getParent().getSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void setCanvasSize(int n, int n2) {
        Object object = this.oSync;
        synchronized (object) {
            if (this.isOldVersion) {
                n = (int)((float)(this.info.W * this.info.scale) / (float)this.info.Q);
                n2 = (int)((float)(this.info.H * this.info.scale) / (float)this.info.Q);
            } else {
                n = (int)((float)(this.info2.W * this.info2.scale) / (float)this.info2.Q);
                n2 = (int)((float)(this.info2.H * this.info2.scale) / (float)this.info2.Q);
            }
            this.setSize(n, n2);
            try {
                Container container = this.getParent().getParent();
                if (container instanceof Window) {
                    container.setVisible(false);
                    container.setSize(n, n2 + 60);
                    container.setVisible(true);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.suspendDraw();
            this.stopLoad();
            windowEvent.getWindow().dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

